/*
 * Decompiled with CFR 0.152.
 */
package com.takwolf.android.lock9;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import com.takwolf.android.lock9.R;
import java.util.ArrayList;
import java.util.List;

public class Lock9View
extends ViewGroup {
    private List<NodeView> nodeList = new ArrayList<NodeView>();
    private float x;
    private float y;
    private Drawable nodeSrc;
    private Drawable nodeOnSrc;
    private float nodeSize;
    private float nodeAreaExpand;
    private int nodeOnAnim;
    private int lineColor;
    private float lineWidth;
    private float padding;
    private float spacing;
    private boolean autoLink;
    private Vibrator vibrator;
    private boolean enableVibrate;
    private int vibrateTime;
    private Paint paint;
    private StringBuilder passwordBuilder = new StringBuilder();
    private CallBack callBack;

    public void setCallBack(CallBack callBack) {
        this.callBack = callBack;
    }

    public Lock9View(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public Lock9View(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public Lock9View(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public Lock9View(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Lock9View, defStyleAttr, defStyleRes);
        this.nodeSrc = a.getDrawable(R.styleable.Lock9View_lock9_nodeSrc);
        this.nodeOnSrc = a.getDrawable(R.styleable.Lock9View_lock9_nodeOnSrc);
        this.nodeSize = a.getDimension(R.styleable.Lock9View_lock9_nodeSize, 0.0f);
        this.nodeAreaExpand = a.getDimension(R.styleable.Lock9View_lock9_nodeAreaExpand, 0.0f);
        this.nodeOnAnim = a.getResourceId(R.styleable.Lock9View_lock9_nodeOnAnim, 0);
        this.lineColor = a.getColor(R.styleable.Lock9View_lock9_lineColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        this.lineWidth = a.getDimension(R.styleable.Lock9View_lock9_lineWidth, 0.0f);
        this.padding = a.getDimension(R.styleable.Lock9View_lock9_padding, 0.0f);
        this.spacing = a.getDimension(R.styleable.Lock9View_lock9_spacing, 0.0f);
        this.autoLink = a.getBoolean(R.styleable.Lock9View_lock9_autoLink, false);
        this.enableVibrate = a.getBoolean(R.styleable.Lock9View_lock9_enableVibrate, false);
        this.vibrateTime = a.getInt(R.styleable.Lock9View_lock9_vibrateTime, 20);
        a.recycle();
        if (this.enableVibrate && !this.isInEditMode()) {
            this.vibrator = (Vibrator)context.getSystemService("vibrator");
        }
        this.paint = new Paint(4);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.lineWidth);
        this.paint.setColor(this.lineColor);
        this.paint.setAntiAlias(true);
        for (int n = 0; n < 9; ++n) {
            NodeView node = new NodeView(this.getContext(), n + 1);
            this.addView(node);
        }
        this.setWillNotDraw(false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int size = this.measureSize(widthMeasureSpec);
        this.setMeasuredDimension(size, size);
    }

    private int measureSize(int measureSpec) {
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (specMode) {
            case -2147483648: 
            case 0x40000000: {
                return specSize;
            }
        }
        return 0;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        block4: {
            if (!changed) break block4;
            if (this.nodeSize > 0.0f) {
                float areaWidth = (right - left) / 3;
                for (int n = 0; n < 9; ++n) {
                    NodeView node = (NodeView)this.getChildAt(n);
                    int row = n / 3;
                    int col = n % 3;
                    int l = (int)((float)col * areaWidth + (areaWidth - this.nodeSize) / 2.0f);
                    int t = (int)((float)row * areaWidth + (areaWidth - this.nodeSize) / 2.0f);
                    int r = (int)((float)l + this.nodeSize);
                    int b = (int)((float)t + this.nodeSize);
                    node.layout(l, t, r, b);
                }
            } else {
                float nodeSize = ((float)(right - left) - this.padding * 2.0f - this.spacing * 2.0f) / 3.0f;
                for (int n = 0; n < 9; ++n) {
                    NodeView node = (NodeView)this.getChildAt(n);
                    int row = n / 3;
                    int col = n % 3;
                    int l = (int)(this.padding + (float)col * (nodeSize + this.spacing));
                    int t = (int)(this.padding + (float)row * (nodeSize + this.spacing));
                    int r = (int)((float)l + nodeSize);
                    int b = (int)((float)t + nodeSize);
                    node.layout(l, t, r, b);
                }
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: 
            case 2: {
                this.x = event.getX();
                this.y = event.getY();
                NodeView currentNode = this.getNodeAt(this.x, this.y);
                if (currentNode != null && !currentNode.isHighLighted()) {
                    NodeView lastNode;
                    NodeView middleNode;
                    if (this.nodeList.size() > 0 && this.autoLink && (middleNode = this.getNodeBetween(lastNode = this.nodeList.get(this.nodeList.size() - 1), currentNode)) != null && !middleNode.isHighLighted()) {
                        middleNode.setHighLighted(true, true);
                        this.nodeList.add(middleNode);
                    }
                    currentNode.setHighLighted(true, false);
                    this.nodeList.add(currentNode);
                }
                if (this.nodeList.size() <= 0) break;
                this.invalidate();
                break;
            }
            case 1: {
                if (this.nodeList.size() <= 0) break;
                if (this.callBack != null) {
                    this.passwordBuilder.setLength(0);
                    for (NodeView nodeView : this.nodeList) {
                        this.passwordBuilder.append(nodeView.getNum());
                    }
                    this.callBack.onFinish(this.passwordBuilder.toString());
                }
                this.nodeList.clear();
                for (int n = 0; n < this.getChildCount(); ++n) {
                    NodeView node = (NodeView)this.getChildAt(n);
                    node.setHighLighted(false, false);
                }
                this.invalidate();
            }
        }
        return true;
    }

    protected void onDraw(Canvas canvas) {
        for (int n = 1; n < this.nodeList.size(); ++n) {
            NodeView firstNode = this.nodeList.get(n - 1);
            NodeView secondNode = this.nodeList.get(n);
            canvas.drawLine((float)firstNode.getCenterX(), (float)firstNode.getCenterY(), (float)secondNode.getCenterX(), (float)secondNode.getCenterY(), this.paint);
        }
        if (this.nodeList.size() > 0) {
            NodeView lastNode = this.nodeList.get(this.nodeList.size() - 1);
            canvas.drawLine((float)lastNode.getCenterX(), (float)lastNode.getCenterY(), this.x, this.y, this.paint);
        }
    }

    private NodeView getNodeAt(float x, float y) {
        for (int n = 0; n < this.getChildCount(); ++n) {
            NodeView node = (NodeView)this.getChildAt(n);
            if (!(x >= (float)node.getLeft() - this.nodeAreaExpand && x < (float)node.getRight() + this.nodeAreaExpand && y >= (float)node.getTop() - this.nodeAreaExpand && y < (float)node.getBottom() + this.nodeAreaExpand)) continue;
            return node;
        }
        return null;
    }

    private NodeView getNodeBetween(NodeView na, NodeView nb) {
        if (na.getNum() > nb.getNum()) {
            NodeView nc = na;
            na = nb;
            nb = nc;
        }
        if (na.getNum() % 3 == 1 && nb.getNum() - na.getNum() == 2) {
            return (NodeView)this.getChildAt(na.getNum());
        }
        if (na.getNum() <= 3 && nb.getNum() - na.getNum() == 6) {
            return (NodeView)this.getChildAt(na.getNum() + 2);
        }
        if (na.getNum() == 1 && nb.getNum() == 9 || na.getNum() == 3 && nb.getNum() == 7) {
            return (NodeView)this.getChildAt(4);
        }
        return null;
    }

    private class NodeView
    extends View {
        private int num;
        private boolean highLighted;

        public NodeView(Context context, int num) {
            super(context);
            this.highLighted = false;
            this.num = num;
            this.setBackgroundDrawable(Lock9View.this.nodeSrc);
        }

        public boolean isHighLighted() {
            return this.highLighted;
        }

        public void setHighLighted(boolean highLighted, boolean isMid) {
            if (this.highLighted != highLighted) {
                this.highLighted = highLighted;
                if (Lock9View.this.nodeOnSrc != null) {
                    this.setBackgroundDrawable(highLighted ? Lock9View.this.nodeOnSrc : Lock9View.this.nodeSrc);
                }
                if (Lock9View.this.nodeOnAnim != 0) {
                    if (highLighted) {
                        this.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)Lock9View.this.nodeOnAnim));
                    } else {
                        this.clearAnimation();
                    }
                }
                if (Lock9View.this.enableVibrate && !isMid && highLighted) {
                    Lock9View.this.vibrator.vibrate((long)Lock9View.this.vibrateTime);
                }
            }
        }

        public int getCenterX() {
            return (this.getLeft() + this.getRight()) / 2;
        }

        public int getCenterY() {
            return (this.getTop() + this.getBottom()) / 2;
        }

        public int getNum() {
            return this.num;
        }
    }

    public static interface CallBack {
        public void onFinish(String var1);
    }
}

