/*
 * Decompiled with CFR 0.152.
 */
package com.takwolf.android.fragmentswitcher;

import android.content.Context;
import android.support.annotation.AttrRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.StyleRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.widget.FrameLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class FragmentSwitcher
extends FrameLayout {
    public static final int NO_KEY = -1;
    private final SparseArray<Fragment> fragments = new SparseArray();
    private Adapter adapter;
    private Adapter adapterNotUse;
    private int currentKey = -1;
    private Integer currentKeyNotUse;
    private boolean firstLayout = true;
    private List<OnFragmentSelectedListener> onFragmentSelectedListenerList;

    public FragmentSwitcher(@NonNull Context context) {
        super(context);
    }

    public FragmentSwitcher(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public FragmentSwitcher(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public FragmentSwitcher(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.firstLayout) {
            this.firstLayout = false;
            if (this.adapterNotUse != null) {
                this.setAdapter(this.adapterNotUse);
                this.adapterNotUse = null;
            }
            if (this.currentKeyNotUse != null) {
                this.setCurrentFragment(this.currentKeyNotUse);
                this.currentKeyNotUse = null;
            }
        }
    }

    public void setAdapter(Adapter adapter) {
        if (this.getId() == -1) {
            throw new RuntimeException("Must set id before call this function.");
        }
        if (this.firstLayout) {
            this.adapterNotUse = adapter;
        } else {
            if (this.adapter != null) {
                this.setCurrentFragment(-1);
                for (int i = 0; i < this.fragments.size(); ++i) {
                    int key = this.fragments.keyAt(i);
                    Fragment fragment = (Fragment)this.fragments.valueAt(i);
                    this.adapter.getFragmentManager().beginTransaction().remove(fragment).commitNowAllowingStateLoss();
                    this.adapter.onFragmentDetached(key, fragment);
                }
            }
            this.fragments.clear();
            this.adapter = adapter;
        }
    }

    public int getCurrentFragment() {
        if (this.firstLayout) {
            return this.currentKeyNotUse == null ? -1 : this.currentKeyNotUse;
        }
        return this.currentKey;
    }

    public void setCurrentFragment(int key) {
        if (key < -1) {
            throw new IllegalArgumentException("Key must >= 0 or = -1.");
        }
        if (this.firstLayout) {
            if (this.adapterNotUse == null) {
                throw new RuntimeException("Must set adapter before call this function.");
            }
            this.currentKeyNotUse = key;
        } else {
            if (this.adapter == null) {
                throw new RuntimeException("Must set adapter before call this function.");
            }
            if (this.currentKey != key) {
                Fragment fragment;
                if (this.currentKey >= 0) {
                    fragment = (Fragment)this.fragments.get(this.currentKey);
                    this.adapter.getFragmentManager().beginTransaction().hide(fragment).commitNowAllowingStateLoss();
                    fragment.setUserVisibleHint(false);
                    this.dispatchOnFragmentSelected(this.currentKey, fragment, false);
                }
                this.currentKey = key;
                if (key >= 0) {
                    fragment = (Fragment)this.fragments.get(key);
                    if (fragment == null) {
                        fragment = this.adapter.getFragment(key);
                        this.fragments.put(key, (Object)fragment);
                        this.adapter.getFragmentManager().beginTransaction().add(this.getId(), fragment).commitNowAllowingStateLoss();
                        this.adapter.onFragmentAttached(key, fragment);
                    } else {
                        this.adapter.getFragmentManager().beginTransaction().show(fragment).commitNowAllowingStateLoss();
                    }
                    fragment.setUserVisibleHint(true);
                    this.dispatchOnFragmentSelected(key, fragment, true);
                }
            }
        }
    }

    private void dispatchOnFragmentSelected(int key, @NonNull Fragment fragment, boolean selected) {
        if (this.onFragmentSelectedListenerList != null && !this.onFragmentSelectedListenerList.isEmpty()) {
            for (OnFragmentSelectedListener onFragmentSelectedListener : this.onFragmentSelectedListenerList) {
                onFragmentSelectedListener.onFragmentSelected(key, fragment, selected);
            }
        }
    }

    public void addOnFragmentSelectedListener(@NonNull OnFragmentSelectedListener listener) {
        if (this.onFragmentSelectedListenerList == null) {
            this.onFragmentSelectedListenerList = new ArrayList<OnFragmentSelectedListener>();
        }
        this.onFragmentSelectedListenerList.add(listener);
    }

    public void removeOnFragmentSelectedListener(@NonNull OnFragmentSelectedListener listener) {
        if (this.onFragmentSelectedListenerList != null) {
            this.onFragmentSelectedListenerList.remove(listener);
        }
    }

    public void clearOnFragmentSelectedListener() {
        if (this.onFragmentSelectedListenerList != null) {
            this.onFragmentSelectedListenerList.clear();
        }
    }

    public static interface OnFragmentSelectedListener {
        public void onFragmentSelected(int var1, @NonNull Fragment var2, boolean var3);
    }

    public static abstract class Adapter {
        private final FragmentManager fragmentManager;

        public Adapter(@NonNull FragmentManager fragmentManager) {
            this.fragmentManager = fragmentManager;
        }

        @NonNull
        private FragmentManager getFragmentManager() {
            return this.fragmentManager;
        }

        @NonNull
        public abstract Fragment getFragment(int var1);

        public void onFragmentAttached(int key, @NonNull Fragment fragment) {
        }

        public void onFragmentDetached(int key, @NonNull Fragment fragment) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntRange(from=0L, to=0x7FFFFFFFL)
    public static @interface Key {
    }
}

