/*
 * Decompiled with CFR 0.152.
 */
package com.takwolf.android.foreback;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public final class Foreback
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "Foreback";
    private static Foreback singleton;
    private final List<Listener> listenerList = new ArrayList<Listener>();
    private final Filter filter;
    private int foregroundCount = 0;
    private int bufferCount = 0;

    public static void init(Application application) {
        Foreback.init(application, null);
    }

    public static void init(Application application, Filter filter) {
        if (singleton == null) {
            singleton = new Foreback(filter);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)singleton);
        } else {
            Log.w((String)TAG, (String)"Foreback has been initialized.");
        }
    }

    private static void checkInit() {
        if (singleton == null) {
            throw new RuntimeException("Foreback has not been initialized.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerListener(Listener listener) {
        Foreback.checkInit();
        List<Listener> list = Foreback.singleton.listenerList;
        synchronized (list) {
            Foreback.singleton.listenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterListener(Listener listener) {
        Foreback.checkInit();
        List<Listener> list = Foreback.singleton.listenerList;
        synchronized (list) {
            Foreback.singleton.listenerList.remove(listener);
        }
    }

    public static boolean isApplicationInTheForeground() {
        Foreback.checkInit();
        return Foreback.singleton.foregroundCount > 0;
    }

    public static boolean isApplicationInTheBackground() {
        return !Foreback.isApplicationInTheForeground();
    }

    private Foreback(Filter filter) {
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Listener[] collectListeners() {
        List<Listener> list = this.listenerList;
        synchronized (list) {
            if (this.listenerList.size() > 0) {
                Listener[] listeners = new Listener[this.listenerList.size()];
                this.listenerList.toArray(listeners);
                return listeners;
            }
            return null;
        }
    }

    private void dispatchApplicationEnterForeground(Activity activity) {
        Listener[] listeners = this.collectListeners();
        if (listeners != null) {
            for (Listener listener : listeners) {
                if (listener == null) continue;
                listener.onApplicationEnterForeground(activity);
            }
        }
    }

    private void dispatchApplicationEnterBackground(Activity activity) {
        Listener[] listeners = this.collectListeners();
        if (listeners != null) {
            for (Listener listener : listeners) {
                if (listener == null) continue;
                listener.onApplicationEnterBackground(activity);
            }
        }
    }

    public void onActivityStarted(Activity activity) {
        if (this.filter == null || !this.filter.isIgnore(activity)) {
            if (this.foregroundCount <= 0) {
                this.dispatchApplicationEnterForeground(activity);
            }
            if (this.bufferCount < 0) {
                ++this.bufferCount;
            } else {
                ++this.foregroundCount;
            }
        }
    }

    public void onActivityStopped(Activity activity) {
        if (this.filter == null || !this.filter.isIgnore(activity)) {
            if (activity.isChangingConfigurations()) {
                --this.bufferCount;
            } else {
                --this.foregroundCount;
                if (this.foregroundCount <= 0) {
                    this.dispatchApplicationEnterBackground(activity);
                }
            }
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public static interface Filter {
        public boolean isIgnore(Activity var1);
    }

    public static interface Listener {
        public void onApplicationEnterForeground(Activity var1);

        public void onApplicationEnterBackground(Activity var1);
    }
}

