/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.fix.support.v7.preference;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v7.preference.Preference;
import android.support.v7.preference.PreferenceGroup;
import android.support.v7.preference.PreferenceManager;
import android.support.v7.preference.PreferenceManagerFix;
import android.support.v7.preference.PreferenceScreen;
import android.support.v7.widget.RecyclerView;
import com.takisoft.fix.support.v7.preference.EditTextPreference;
import com.takisoft.fix.support.v7.preference.EditTextPreferenceDialogFragmentCompat;
import com.takisoft.fix.support.v7.preference.PreferenceActivityResultListener;
import com.takisoft.fix.support.v7.preference.PreferenceGroupAdapter;
import java.lang.reflect.Field;
import java.util.HashMap;

public abstract class PreferenceFragmentCompat
extends android.support.v7.preference.PreferenceFragmentCompat {
    private static final String FRAGMENT_DIALOG_TAG = "android.support.v7.preference.PreferenceFragment.DIALOG";
    private static Field preferenceManagerField;
    protected static HashMap<Class<? extends Preference>, Class<? extends Fragment>> dialogPreferences;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            Context styledContext = this.getPreferenceManager().getContext();
            PreferenceManagerFix fixedManager = new PreferenceManagerFix(styledContext);
            fixedManager.setOnNavigateToScreenListener((PreferenceManager.OnNavigateToScreenListener)this);
            preferenceManagerField.set((Object)this, (Object)fixedManager);
            Bundle args = this.getArguments();
            String rootKey = args != null ? this.getArguments().getString("android.support.v7.preference.PreferenceFragmentCompat.PREFERENCE_ROOT") : null;
            this.onCreatePreferencesFix(savedInstanceState, rootKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected RecyclerView.Adapter onCreateAdapter(PreferenceScreen preferenceScreen) {
        return new PreferenceGroupAdapter((PreferenceGroup)preferenceScreen);
    }

    @Deprecated
    public void onCreatePreferences(@Nullable Bundle savedInstanceState, String rootKey) {
    }

    public abstract void onCreatePreferencesFix(@Nullable Bundle var1, String var2);

    public void onDisplayPreferenceDialog(Preference preference) {
        if (this.getFragmentManager().findFragmentByTag(FRAGMENT_DIALOG_TAG) == null) {
            EditTextPreferenceDialogFragmentCompat f = null;
            if (preference instanceof EditTextPreference) {
                f = EditTextPreferenceDialogFragmentCompat.newInstance(preference.getKey());
            } else if (dialogPreferences.containsKey(preference.getClass())) {
                try {
                    Fragment fragment = dialogPreferences.get(preference.getClass()).newInstance();
                    Bundle b = new Bundle(1);
                    b.putString("key", preference.getKey());
                    fragment.setArguments(b);
                    f = fragment;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            } else {
                super.onDisplayPreferenceDialog(preference);
            }
            if (f != null) {
                if (f instanceof DialogFragment) {
                    ((DialogFragment)f).setTargetFragment((Fragment)this, 0);
                    ((DialogFragment)f).show(this.getFragmentManager(), FRAGMENT_DIALOG_TAG);
                } else {
                    this.getFragmentManager().beginTransaction().add((Fragment)f, FRAGMENT_DIALOG_TAG).commit();
                }
            }
        }
    }

    public boolean onPreferenceTreeClick(Preference preference) {
        boolean handled = super.onPreferenceTreeClick(preference);
        if (!handled && preference instanceof PreferenceActivityResultListener) {
            ((PreferenceActivityResultListener)preference).onPreferenceClick(this, preference);
        }
        return handled;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.onActivityResult((PreferenceGroup)this.getPreferenceScreen(), requestCode, resultCode, data);
        super.onActivityResult(requestCode, resultCode, data);
    }

    protected void onActivityResult(PreferenceGroup group, int requestCode, int resultCode, Intent data) {
        int n = group.getPreferenceCount();
        for (int i = 0; i < n; ++i) {
            Preference pref = group.getPreference(i);
            if (pref instanceof PreferenceActivityResultListener) {
                ((PreferenceActivityResultListener)pref).onActivityResult(requestCode, resultCode, data);
            }
            if (!(pref instanceof PreferenceGroup)) continue;
            this.onActivityResult((PreferenceGroup)pref, requestCode, resultCode, data);
        }
    }

    public static void registerPreferenceFragment(Class<? extends Preference> prefClass, Class<? extends Fragment> fragmentClass) {
        dialogPreferences.put(prefClass, fragmentClass);
    }

    static {
        Field[] fields;
        for (Field field : fields = android.support.v7.preference.PreferenceFragmentCompat.class.getDeclaredFields()) {
            if (field.getType() != PreferenceManager.class) continue;
            preferenceManagerField = field;
            preferenceManagerField.setAccessible(true);
            break;
        }
        dialogPreferences = new HashMap();
    }
}

