/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.preference;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.v4.content.SharedPreferencesCompat;
import android.support.v7.preference.PreferenceGroup;
import android.support.v7.preference.PreferenceInflater;
import android.support.v7.preference.PreferenceManager;
import android.support.v7.preference.PreferenceScreen;
import android.util.Log;
import java.lang.reflect.Field;

public class PreferenceManagerFix
extends PreferenceManager {
    private static Field editorField;
    private boolean noCommit;
    private boolean inflateInProgress;

    public PreferenceManagerFix(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreferenceScreen inflateFromResource(Context context, int resId, PreferenceScreen rootPreferences) {
        try {
            this.inflateInProgress = true;
            this.setNoCommitFix(true);
            PreferenceInflater inflater = new PreferenceInflater(context, (PreferenceManager)this);
            String[] defPacks = inflater.getDefaultPackages();
            String[] newDefPacks = new String[defPacks.length + 1];
            newDefPacks[0] = "com.takisoft.fix.support.v7.preference.";
            System.arraycopy(defPacks, 0, newDefPacks, 1, defPacks.length);
            inflater.setDefaultPackages(newDefPacks);
            rootPreferences = (PreferenceScreen)inflater.inflate(resId, (PreferenceGroup)rootPreferences);
            rootPreferences.onAttachedToHierarchy((PreferenceManager)this);
            this.setNoCommitFix(false);
            this.inflateInProgress = false;
            PreferenceScreen preferenceScreen = rootPreferences;
            return preferenceScreen;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.inflateInProgress = false;
        }
        return super.inflateFromResource(context, resId, rootPreferences);
    }

    SharedPreferences.Editor getEditor() {
        if (!this.inflateInProgress || editorField == null) {
            return super.getEditor();
        }
        if (this.noCommit) {
            SharedPreferences.Editor editor = null;
            try {
                editor = (SharedPreferences.Editor)editorField.get((Object)this);
                if (editor == null) {
                    editor = this.getSharedPreferences().edit();
                    editorField.set((Object)this, editor);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return editor;
        }
        return this.getSharedPreferences().edit();
    }

    boolean shouldCommit() {
        if (!this.inflateInProgress) {
            return super.shouldCommit();
        }
        return this.noCommit;
    }

    private void setNoCommitFix(boolean noCommit) throws IllegalAccessException {
        SharedPreferences.Editor editor = (SharedPreferences.Editor)editorField.get((Object)this);
        if (!noCommit && editor != null) {
            SharedPreferencesCompat.EditorCompat.getInstance().apply(editor);
        }
        this.noCommit = noCommit;
    }

    static {
        Field[] fields;
        for (Field field : fields = PreferenceManager.class.getDeclaredFields()) {
            Log.d((String)"FIELD", (String)field.toString());
            if (field.getType() != SharedPreferences.Editor.class) continue;
            editorField = field;
            editorField.setAccessible(true);
            break;
        }
    }
}

