/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.preference;

import android.os.Bundle;
import android.support.v7.preference.EditTextPreferenceFix;
import android.support.v7.preference.PreferenceDialogFragmentCompat;
import android.text.Editable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.EditText;

public class EditTextPreferenceDialogFragmentCompatFix
extends PreferenceDialogFragmentCompat {
    private EditText mEditText;

    public static EditTextPreferenceDialogFragmentCompatFix newInstance(String key) {
        EditTextPreferenceDialogFragmentCompatFix fragment = new EditTextPreferenceDialogFragmentCompatFix();
        Bundle b = new Bundle(1);
        b.putString("key", key);
        fragment.setArguments(b);
        return fragment;
    }

    protected void onBindDialogView(View view) {
        ViewParent oldParent;
        super.onBindDialogView(view);
        this.mEditText = this.getEditTextPreference().getEditText();
        this.mEditText.setText((CharSequence)this.getEditTextPreference().getText());
        Editable text = this.mEditText.getText();
        if (text != null) {
            this.mEditText.setSelection(text.length(), text.length());
        }
        if ((oldParent = this.mEditText.getParent()) != view) {
            if (oldParent != null) {
                ((ViewGroup)oldParent).removeView((View)this.mEditText);
            }
            this.onAddEditTextToDialogView(view, this.mEditText);
        }
    }

    private EditTextPreferenceFix getEditTextPreference() {
        return (EditTextPreferenceFix)this.getPreference();
    }

    protected boolean needInputMethod() {
        return true;
    }

    protected void onAddEditTextToDialogView(View dialogView, EditText editText) {
        ViewGroup container;
        View oldEditText = dialogView.findViewById(16908291);
        if (oldEditText != null && (container = (ViewGroup)oldEditText.getParent()) != null) {
            container.removeView(oldEditText);
            container.addView((View)editText, -1, -2);
        }
    }

    public void onDialogClosed(boolean positiveResult) {
        if (positiveResult) {
            String value = this.mEditText.getText().toString();
            if (this.getEditTextPreference().callChangeListener(value)) {
                this.getEditTextPreference().setText(value);
            }
        }
    }
}

