/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.fix.support.v7.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v7.preference.ListPreference;
import android.support.v7.preference.PreferenceViewHolder;
import android.util.AttributeSet;
import android.view.View;
import com.takisoft.fix.support.v7.preference.simplemenu.R;
import com.takisoft.fix.support.v7.preference.widget.SimpleMenuPopupWindow;

@RequiresApi(api=21)
public class SimpleMenuPreference
extends ListPreference {
    private View mAnchor;
    private View mItemView;
    private SimpleMenuPopupWindow mPopupWindow;

    public SimpleMenuPreference(Context context) {
        this(context, null);
    }

    public SimpleMenuPreference(Context context, AttributeSet attrs) {
        this(context, attrs, Build.VERSION.SDK_INT < 21 ? R.attr.dialogPreferenceStyle : R.attr.simpleMenuPreferenceStyle);
    }

    public SimpleMenuPreference(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, R.style.Preference_SimpleMenuPreference);
    }

    public SimpleMenuPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SimpleMenuPreference, defStyleAttr, defStyleRes);
        int popupStyle = a.getResourceId(R.styleable.SimpleMenuPreference_pref_popupStyle, R.style.Preference_SimpleMenuPreference_Popup);
        this.mPopupWindow = new SimpleMenuPopupWindow(context, attrs, R.styleable.SimpleMenuPreference_pref_popupStyle, popupStyle);
        this.mPopupWindow.setOnItemClickListener(new SimpleMenuPopupWindow.OnItemClickListener(){

            @Override
            public void onClick(int i) {
                String value = SimpleMenuPreference.this.getEntryValues()[i].toString();
                if (SimpleMenuPreference.this.callChangeListener(value)) {
                    SimpleMenuPreference.this.setValue(value);
                }
            }
        });
        a.recycle();
    }

    protected void onClick() {
        if (Build.VERSION.SDK_INT < 21) {
            super.onClick();
            return;
        }
        if (this.getEntries() == null || this.getEntries().length == 0) {
            return;
        }
        if (this.mPopupWindow == null) {
            return;
        }
        this.mPopupWindow.setEntries(this.getEntries());
        this.mPopupWindow.setSelectedIndex(this.findIndexOfValue(this.getValue()));
        View container = (View)this.mItemView.getParent();
        this.mPopupWindow.show(this.mItemView, container, (int)this.mAnchor.getX());
    }

    public void setEntries(@NonNull CharSequence[] entries) {
        super.setEntries(entries);
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        this.mPopupWindow.requestMeasure();
    }

    public void setValue(String value) {
        super.setValue(value);
    }

    public void onBindViewHolder(PreferenceViewHolder view) {
        super.onBindViewHolder(view);
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        this.mItemView = view.itemView;
        this.mAnchor = view.itemView.findViewById(16908292);
        if (this.mAnchor == null) {
            throw new IllegalStateException("SimpleMenuPreference item layout must containa view id is android.R.id.empty to support iconSpaceReserved");
        }
    }
}

