/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.fix.support.v7.preference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.res.TypedArrayUtils;
import android.support.v7.preference.DialogPreference;
import android.support.v7.preference.Preference;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import com.takisoft.fix.support.v7.preference.DatePickerPreferenceDialogFragmentCompat;
import com.takisoft.fix.support.v7.preference.PreferenceFragmentCompat;
import com.takisoft.fix.support.v7.preference.datetimepicker.R;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DatePickerPreference
extends DialogPreference {
    public static final String PATTERN = "MM/dd/yyyy";
    public static final SimpleDateFormat FORMAT = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
    private String summaryPattern;
    private CharSequence summaryHasDate;
    private CharSequence summary;
    private Date date;
    private Date pickerDate;
    private Date minDate;
    private Date maxDate;

    public DatePickerPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DatePickerPreference, defStyleAttr, 0);
        String pickerDate = a.getString(R.styleable.DatePickerPreference_pref_pickerDate);
        String minDate = a.getString(R.styleable.DatePickerPreference_pref_minDate);
        String maxDate = a.getString(R.styleable.DatePickerPreference_pref_maxDate);
        if (!TextUtils.isEmpty((CharSequence)pickerDate)) {
            try {
                this.pickerDate = FORMAT.parse(pickerDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (!TextUtils.isEmpty((CharSequence)minDate)) {
            try {
                this.minDate = FORMAT.parse(minDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (!TextUtils.isEmpty((CharSequence)maxDate)) {
            try {
                this.maxDate = FORMAT.parse(maxDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        this.summaryPattern = a.getString(R.styleable.DatePickerPreference_pref_summaryDatePattern);
        this.summaryHasDate = a.getText(R.styleable.DatePickerPreference_pref_summaryHasDate);
        a.recycle();
        this.summary = super.getSummary();
    }

    public DatePickerPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    @SuppressLint(value={"RestrictedApi"})
    public DatePickerPreference(Context context, AttributeSet attrs) {
        this(context, attrs, TypedArrayUtils.getAttr((Context)context, (int)R.attr.dialogPreferenceStyle, (int)0x1010091));
    }

    public DatePickerPreference(Context context) {
        this(context, null);
    }

    @Nullable
    public Date getDate() {
        return this.date;
    }

    public void setDate(@Nullable Date date) {
        if (date == null) {
            this.setInternalDate(null, false);
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this.setInternalDate(FORMAT.format(cal.getTime()), false);
        }
    }

    public void setDate(int year, @IntRange(from=0L) int month, @IntRange(from=1L, to=31L) int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        this.setInternalDate(FORMAT.format(cal.getTime()), false);
    }

    @Nullable
    public Date getPickerDate() {
        return this.pickerDate;
    }

    public void setPickerDate(@Nullable Date pickerDate) {
        this.pickerDate = pickerDate;
    }

    @Nullable
    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(@Nullable Date minDate) {
        this.minDate = minDate;
    }

    @Nullable
    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(@Nullable Date maxDate) {
        this.maxDate = maxDate;
    }

    private void setInternalDate(@Nullable String date, boolean force) {
        boolean changed;
        String oldDate = this.getPersistedString(null);
        boolean bl = changed = oldDate != null && !oldDate.equals(date) || date != null && !date.equals(oldDate);
        if (changed || force) {
            if (!TextUtils.isEmpty((CharSequence)date)) {
                try {
                    this.date = FORMAT.parse(date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    this.date = null;
                    date = null;
                }
            } else {
                this.date = null;
            }
            this.persistString(date == null ? "" : date);
            this.notifyChanged();
        }
    }

    public CharSequence getSummary() {
        if (this.date == null) {
            return this.summary;
        }
        java.text.DateFormat simpleDateFormat = this.summaryPattern == null ? DateFormat.getLongDateFormat((Context)this.getContext()) : new SimpleDateFormat(this.summaryPattern, Locale.getDefault());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        String formattedDate = simpleDateFormat.format(cal.getTime());
        if (this.summaryHasDate != null && formattedDate != null) {
            return String.format(this.summaryHasDate.toString(), formattedDate);
        }
        if (formattedDate != null) {
            return formattedDate;
        }
        return this.summary;
    }

    public void setSummary(CharSequence summary) {
        super.setSummary(summary);
        if (summary == null && this.summary != null) {
            this.summary = null;
        } else if (summary != null && !summary.equals(this.summary)) {
            this.summary = summary.toString();
        }
    }

    public String getSummaryPattern() {
        return this.summaryPattern;
    }

    public void setSummaryPattern(String summaryPattern) {
        this.summaryPattern = summaryPattern;
    }

    @Nullable
    public CharSequence getSummaryHasDate() {
        return this.summaryHasDate;
    }

    public void setSummaryHasDate(@StringRes int resId) {
        this.setSummaryHasDate(this.getContext().getString(resId));
    }

    public void setSummaryHasDate(@Nullable CharSequence summaryHasDate) {
        if (summaryHasDate == null && this.summaryHasDate != null) {
            this.summaryHasDate = null;
        } else if (summaryHasDate != null && !summaryHasDate.equals(this.summaryHasDate)) {
            this.summaryHasDate = summaryHasDate.toString();
        }
        this.notifyChanged();
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getString(index);
    }

    protected void onSetInitialValue(boolean restoreValue, Object defaultValueObj) {
        String defaultValue = (String)defaultValueObj;
        this.setInternalDate(restoreValue ? this.getPersistedString(null) : (!TextUtils.isEmpty((CharSequence)defaultValue) ? defaultValue : null), true);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.date = this.getDate();
        return myState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        this.setDate(myState.date);
    }

    static {
        PreferenceFragmentCompat.registerPreferenceFragment(DatePickerPreference.class, DatePickerPreferenceDialogFragmentCompat.class);
    }

    public static class DateWrapper {
        public final int year;
        public final int month;
        public final int day;

        public DateWrapper(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        private Date date;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.date = (Date)source.readSerializable();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeSerializable((Serializable)this.date);
        }
    }
}

