/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.fix.support.v7.preference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.res.TypedArrayUtils;
import android.support.v7.preference.DialogPreference;
import android.support.v7.preference.Preference;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import com.takisoft.fix.support.v7.preference.PreferenceFragmentCompat;
import com.takisoft.fix.support.v7.preference.TimePickerPreferenceDialogFragmentCompat;
import com.takisoft.fix.support.v7.preference.datetimepicker.R;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class TimePickerPreference
extends DialogPreference {
    public static final String PATTERN = "HH:mm";
    public static final SimpleDateFormat FORMAT = new SimpleDateFormat("HH:mm", Locale.US);
    public static final int FORMAT_AUTO = 0;
    public static final int FORMAT_12H = 1;
    public static final int FORMAT_24H = 2;
    private Date time;
    private Date pickerTime;
    private int hourFormat;
    private String summaryPattern;
    private CharSequence summaryHasTime;
    private CharSequence summary;

    public TimePickerPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TimePickerPreference, defStyleAttr, 0);
        this.hourFormat = a.getInt(R.styleable.TimePickerPreference_pref_hourFormat, 0);
        this.summaryPattern = a.getString(R.styleable.TimePickerPreference_pref_summaryTimePattern);
        this.summaryHasTime = a.getText(R.styleable.TimePickerPreference_pref_summaryHasTime);
        String pickerTime = a.getString(R.styleable.TimePickerPreference_pref_pickerTime);
        if (!TextUtils.isEmpty((CharSequence)pickerTime)) {
            try {
                this.pickerTime = FORMAT.parse(pickerTime);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        a.recycle();
        this.summary = super.getSummary();
    }

    public TimePickerPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    @SuppressLint(value={"RestrictedApi"})
    public TimePickerPreference(Context context, AttributeSet attrs) {
        this(context, attrs, TypedArrayUtils.getAttr((Context)context, (int)R.attr.dialogPreferenceStyle, (int)0x1010091));
    }

    public TimePickerPreference(Context context) {
        this(context, null);
    }

    public int getHourFormat() {
        return this.hourFormat;
    }

    boolean is24HourView() {
        return this.hourFormat == 0 ? DateFormat.is24HourFormat((Context)this.getContext()) : this.hourFormat == 2;
    }

    public void setHourFormat(int hourFormat) {
        this.hourFormat = hourFormat;
    }

    @IntRange(from=-1L, to=23L)
    public int getHourOfDay() {
        if (this.time != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.time);
            return cal.get(11);
        }
        return -1;
    }

    @IntRange(from=-1L, to=59L)
    public int getMinute() {
        if (this.time != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.time);
            return cal.get(12);
        }
        return -1;
    }

    @Nullable
    public Date getTime() {
        return this.time;
    }

    public void setTime(@Nullable Date time) {
        this.time = time;
    }

    public void setTime(@IntRange(from=0L, to=23L) int hourOfDay, @IntRange(from=0L, to=59L) int minute) {
        this.setInternalTime(String.format(Locale.US, "%02d:%02d", hourOfDay, minute), false);
    }

    @Nullable
    public Date getPickerTime() {
        return this.pickerTime;
    }

    public void setPickerTime(@Nullable Date pickerTime) {
        this.pickerTime = pickerTime;
    }

    private void setInternalTime(String time, boolean force) {
        boolean changed;
        String oldTime = this.getPersistedString(null);
        boolean bl = changed = oldTime != null && !oldTime.equals(time) || time != null && !time.equals(oldTime);
        if (changed || force) {
            if (!TextUtils.isEmpty((CharSequence)time)) {
                try {
                    this.time = FORMAT.parse(time);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    this.time = null;
                }
            }
            this.persistString(time == null ? "" : time);
            this.notifyChanged();
        }
    }

    public CharSequence getSummary() {
        if (this.time == null) {
            return this.summary;
        }
        java.text.DateFormat simpleDateFormat = this.summaryPattern == null ? DateFormat.getTimeFormat((Context)this.getContext()) : new SimpleDateFormat(this.summaryPattern, Locale.getDefault());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.time);
        String formattedDate = simpleDateFormat.format(cal.getTime());
        if (this.summaryHasTime != null && formattedDate != null) {
            return String.format(this.summaryHasTime.toString(), formattedDate);
        }
        if (formattedDate != null) {
            return formattedDate;
        }
        return this.summary;
    }

    public void setSummary(CharSequence summary) {
        super.setSummary(summary);
        if (summary == null && this.summary != null) {
            this.summary = null;
        } else if (summary != null && !summary.equals(this.summary)) {
            this.summary = summary.toString();
        }
    }

    public String getSummaryPattern() {
        return this.summaryPattern;
    }

    public void setSummaryPattern(String summaryPattern) {
        this.summaryPattern = summaryPattern;
    }

    @Nullable
    public CharSequence getSummaryHasTime() {
        return this.summaryHasTime;
    }

    public void setSummaryHasTime(@StringRes int resId) {
        this.getSummaryHasTime(this.getContext().getString(resId));
    }

    public void getSummaryHasTime(@Nullable CharSequence summaryHasDate) {
        if (summaryHasDate == null && this.summaryHasTime != null) {
            this.summaryHasTime = null;
        } else if (summaryHasDate != null && !summaryHasDate.equals(this.summaryHasTime)) {
            this.summaryHasTime = summaryHasDate.toString();
        }
        this.notifyChanged();
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getString(index);
    }

    protected void onSetInitialValue(boolean restoreValue, Object defaultValueObj) {
        String defaultValue = (String)defaultValueObj;
        this.setInternalTime(restoreValue ? this.getPersistedString(null) : (!TextUtils.isEmpty((CharSequence)defaultValue) ? defaultValue : null), true);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.time = this.getTime();
        return myState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        this.setTime(myState.time);
    }

    static {
        PreferenceFragmentCompat.addDialogPreference(TimePickerPreference.class, TimePickerPreferenceDialogFragmentCompat.class);
    }

    public static class TimeWrapper {
        public final int hour;
        public final int minute;

        public TimeWrapper(int hour, int minute) {
            this.hour = hour;
            this.minute = minute;
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        private Date time;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.time = (Date)source.readSerializable();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeSerializable((Serializable)this.time);
        }
    }
}

