/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.datetimepicker.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.FrameLayout;
import com.takisoft.datetimepicker.R;
import com.takisoft.datetimepicker.util.Utils;
import com.takisoft.datetimepicker.widget.CalendarViewMaterialDelegate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class CalendarView
extends FrameLayout {
    private static final String LOG_TAG = "CalendarView";
    private static final int MODE_HOLO = 0;
    private static final int MODE_MATERIAL = 1;
    private CalendarViewDelegate mDelegate;
    private static final String DATE_FORMAT = "MM/dd/yyyy";
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("MM/dd/yyyy");

    public CalendarView(@NonNull Context context) {
        this(context, null);
    }

    public CalendarView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.calendarViewStyle);
    }

    public CalendarView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.attrHandler(context, attrs, defStyleAttr, Utils.isLightTheme(context) ? R.style.Widget_Material_Light_CalendarView : R.style.Widget_Material_CalendarView);
    }

    @TargetApi(value=21)
    public CalendarView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.attrHandler(context, attrs, defStyleAttr, defStyleRes);
    }

    private void attrHandler(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CalendarView, defStyleAttr, defStyleRes);
        a.recycle();
        this.mDelegate = new CalendarViewMaterialDelegate(this, context, attrs, defStyleAttr, defStyleRes);
    }

    @Deprecated
    public void setShownWeekCount(int count) {
        this.mDelegate.setShownWeekCount(count);
    }

    @Deprecated
    public int getShownWeekCount() {
        return this.mDelegate.getShownWeekCount();
    }

    @Deprecated
    public void setSelectedWeekBackgroundColor(@ColorInt int color) {
        this.mDelegate.setSelectedWeekBackgroundColor(color);
    }

    @Deprecated
    @ColorInt
    public int getSelectedWeekBackgroundColor() {
        return this.mDelegate.getSelectedWeekBackgroundColor();
    }

    @Deprecated
    public void setFocusedMonthDateColor(@ColorInt int color) {
        this.mDelegate.setFocusedMonthDateColor(color);
    }

    @Deprecated
    @ColorInt
    public int getFocusedMonthDateColor() {
        return this.mDelegate.getFocusedMonthDateColor();
    }

    @Deprecated
    public void setUnfocusedMonthDateColor(@ColorInt int color) {
        this.mDelegate.setUnfocusedMonthDateColor(color);
    }

    @Deprecated
    @ColorInt
    public int getUnfocusedMonthDateColor() {
        return this.mDelegate.getUnfocusedMonthDateColor();
    }

    @Deprecated
    public void setWeekNumberColor(@ColorInt int color) {
        this.mDelegate.setWeekNumberColor(color);
    }

    @Deprecated
    @ColorInt
    public int getWeekNumberColor() {
        return this.mDelegate.getWeekNumberColor();
    }

    @Deprecated
    public void setWeekSeparatorLineColor(@ColorInt int color) {
        this.mDelegate.setWeekSeparatorLineColor(color);
    }

    @Deprecated
    @ColorInt
    public int getWeekSeparatorLineColor() {
        return this.mDelegate.getWeekSeparatorLineColor();
    }

    @Deprecated
    public void setSelectedDateVerticalBar(@DrawableRes int resourceId) {
        this.mDelegate.setSelectedDateVerticalBar(resourceId);
    }

    @Deprecated
    public void setSelectedDateVerticalBar(Drawable drawable) {
        this.mDelegate.setSelectedDateVerticalBar(drawable);
    }

    @Deprecated
    public Drawable getSelectedDateVerticalBar() {
        return this.mDelegate.getSelectedDateVerticalBar();
    }

    public void setWeekDayTextAppearance(@StyleRes int resourceId) {
        this.mDelegate.setWeekDayTextAppearance(resourceId);
    }

    @StyleRes
    public int getWeekDayTextAppearance() {
        return this.mDelegate.getWeekDayTextAppearance();
    }

    public void setDateTextAppearance(@StyleRes int resourceId) {
        this.mDelegate.setDateTextAppearance(resourceId);
    }

    @StyleRes
    public int getDateTextAppearance() {
        return this.mDelegate.getDateTextAppearance();
    }

    public long getMinDate() {
        return this.mDelegate.getMinDate();
    }

    public void setMinDate(long minDate) {
        this.mDelegate.setMinDate(minDate);
    }

    public long getMaxDate() {
        return this.mDelegate.getMaxDate();
    }

    public void setMaxDate(long maxDate) {
        this.mDelegate.setMaxDate(maxDate);
    }

    @Deprecated
    public void setShowWeekNumber(boolean showWeekNumber) {
        this.mDelegate.setShowWeekNumber(showWeekNumber);
    }

    @Deprecated
    public boolean getShowWeekNumber() {
        return this.mDelegate.getShowWeekNumber();
    }

    public int getFirstDayOfWeek() {
        return this.mDelegate.getFirstDayOfWeek();
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.mDelegate.setFirstDayOfWeek(firstDayOfWeek);
    }

    public void setOnDateChangeListener(OnDateChangeListener listener) {
        this.mDelegate.setOnDateChangeListener(listener);
    }

    public long getDate() {
        return this.mDelegate.getDate();
    }

    public void setDate(long date) {
        this.mDelegate.setDate(date);
    }

    public void setDate(long date, boolean animate, boolean center) {
        this.mDelegate.setDate(date, animate, center);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mDelegate.onConfigurationChanged(newConfig);
    }

    public CharSequence getAccessibilityClassName() {
        return CalendarView.class.getName();
    }

    public static boolean parseDate(String date, Calendar outDate) {
        if (date == null || date.isEmpty()) {
            return false;
        }
        try {
            Date parsedDate = DATE_FORMATTER.parse(date);
            outDate.setTime(parsedDate);
            return true;
        }
        catch (ParseException e) {
            Log.w((String)LOG_TAG, (String)("Date: " + date + " not in format: " + DATE_FORMAT));
            return false;
        }
    }

    static abstract class AbstractCalendarViewDelegate
    implements CalendarViewDelegate {
        protected static final String DEFAULT_MIN_DATE = "01/01/1900";
        protected static final String DEFAULT_MAX_DATE = "01/01/2100";
        protected CalendarView mDelegator;
        protected Context mContext;
        protected Locale mCurrentLocale;

        AbstractCalendarViewDelegate(CalendarView delegator, Context context) {
            this.mDelegator = delegator;
            this.mContext = context;
            this.setCurrentLocale(Locale.getDefault());
        }

        protected void setCurrentLocale(Locale locale) {
            if (locale.equals(this.mCurrentLocale)) {
                return;
            }
            this.mCurrentLocale = locale;
        }

        @Override
        public void setShownWeekCount(int count) {
        }

        @Override
        public int getShownWeekCount() {
            return 0;
        }

        @Override
        public void setSelectedWeekBackgroundColor(@ColorInt int color) {
        }

        @Override
        @ColorInt
        public int getSelectedWeekBackgroundColor() {
            return 0;
        }

        @Override
        public void setFocusedMonthDateColor(@ColorInt int color) {
        }

        @Override
        @ColorInt
        public int getFocusedMonthDateColor() {
            return 0;
        }

        @Override
        public void setUnfocusedMonthDateColor(@ColorInt int color) {
        }

        @Override
        @ColorInt
        public int getUnfocusedMonthDateColor() {
            return 0;
        }

        @Override
        public void setWeekNumberColor(@ColorInt int color) {
        }

        @Override
        @ColorInt
        public int getWeekNumberColor() {
            return 0;
        }

        @Override
        public void setWeekSeparatorLineColor(@ColorInt int color) {
        }

        @Override
        @ColorInt
        public int getWeekSeparatorLineColor() {
            return 0;
        }

        @Override
        public void setSelectedDateVerticalBar(@DrawableRes int resId) {
        }

        @Override
        public void setSelectedDateVerticalBar(Drawable drawable) {
        }

        @Override
        public Drawable getSelectedDateVerticalBar() {
            return null;
        }

        @Override
        public void setShowWeekNumber(boolean showWeekNumber) {
        }

        @Override
        public boolean getShowWeekNumber() {
            return false;
        }

        @Override
        public void onConfigurationChanged(Configuration newConfig) {
        }
    }

    private static interface CalendarViewDelegate {
        public void setShownWeekCount(int var1);

        public int getShownWeekCount();

        public void setSelectedWeekBackgroundColor(@ColorInt int var1);

        @ColorInt
        public int getSelectedWeekBackgroundColor();

        public void setFocusedMonthDateColor(@ColorInt int var1);

        @ColorInt
        public int getFocusedMonthDateColor();

        public void setUnfocusedMonthDateColor(@ColorInt int var1);

        @ColorInt
        public int getUnfocusedMonthDateColor();

        public void setWeekNumberColor(@ColorInt int var1);

        @ColorInt
        public int getWeekNumberColor();

        public void setWeekSeparatorLineColor(@ColorInt int var1);

        @ColorInt
        public int getWeekSeparatorLineColor();

        public void setSelectedDateVerticalBar(@DrawableRes int var1);

        public void setSelectedDateVerticalBar(Drawable var1);

        public Drawable getSelectedDateVerticalBar();

        public void setWeekDayTextAppearance(@StyleRes int var1);

        @StyleRes
        public int getWeekDayTextAppearance();

        public void setDateTextAppearance(@StyleRes int var1);

        @StyleRes
        public int getDateTextAppearance();

        public void setMinDate(long var1);

        public long getMinDate();

        public void setMaxDate(long var1);

        public long getMaxDate();

        public void setShowWeekNumber(boolean var1);

        public boolean getShowWeekNumber();

        public void setFirstDayOfWeek(int var1);

        public int getFirstDayOfWeek();

        public void setDate(long var1);

        public void setDate(long var1, boolean var3, boolean var4);

        public long getDate();

        public void setOnDateChangeListener(OnDateChangeListener var1);

        public void onConfigurationChanged(Configuration var1);
    }

    public static interface OnDateChangeListener {
        public void onSelectedDayChange(@NonNull CalendarView var1, int var2, int var3, int var4);
    }
}

