/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.datetimepicker.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.takisoft.datetimepicker.R;
import java.util.Calendar;
import java.util.Locale;

class YearPickerView
extends ListView {
    private YearAdapter mAdapter;
    private int mViewSize;
    private int mChildSize;
    private OnYearSelectedListener mOnYearSelectedListener;

    public YearPickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842868);
    }

    public YearPickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.handleAttr(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public YearPickerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.handleAttr(context, attrs, defStyleAttr, defStyleRes);
    }

    private void handleAttr(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        AbsListView.LayoutParams frame = new AbsListView.LayoutParams(-1, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)frame);
        Resources res = context.getResources();
        this.mViewSize = res.getDimensionPixelOffset(R.dimen.datepicker_view_animator_height);
        this.mChildSize = res.getDimensionPixelOffset(R.dimen.datepicker_year_label_height);
        this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                int year = YearPickerView.this.mAdapter.getYearForPosition(position);
                YearPickerView.this.mAdapter.setSelection(year);
                if (YearPickerView.this.mOnYearSelectedListener != null) {
                    YearPickerView.this.mOnYearSelectedListener.onYearChanged(YearPickerView.this, year);
                }
            }
        });
        this.mAdapter = new YearAdapter(this.getContext());
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public void setOnYearSelectedListener(OnYearSelectedListener listener) {
        this.mOnYearSelectedListener = listener;
    }

    public void setYear(final int year) {
        this.mAdapter.setSelection(year);
        this.post(new Runnable(){

            @Override
            public void run() {
                int position = YearPickerView.this.mAdapter.getPositionForYear(year);
                if (position >= 0 && position < YearPickerView.this.getCount()) {
                    YearPickerView.this.setSelectionCentered(position);
                }
            }
        });
    }

    public void setSelectionCentered(int position) {
        int offset = this.mViewSize / 2 - this.mChildSize / 2;
        this.setSelectionFromTop(position, offset);
    }

    public void setRange(Calendar min, Calendar max) {
        this.mAdapter.setRange(min, max);
    }

    public int getFirstPositionOffset() {
        View firstChild = this.getChildAt(0);
        if (firstChild == null) {
            return 0;
        }
        return firstChild.getTop();
    }

    public static interface OnYearSelectedListener {
        public void onYearChanged(YearPickerView var1, int var2);
    }

    private static class YearAdapter
    extends BaseAdapter {
        private static final int ITEM_LAYOUT = R.layout.year_label_text_view;
        private static final int ITEM_TEXT_APPEARANCE = R.style.TextAppearance_Material_DatePicker_List_YearLabel;
        private static final int ITEM_TEXT_ACTIVATED_APPEARANCE = R.style.TextAppearance_Material_DatePicker_List_YearLabel_Activated;
        private final LayoutInflater mInflater;
        private int mActivatedYear;
        private int mMinYear;
        private int mCount;

        public YearAdapter(Context context) {
            this.mInflater = LayoutInflater.from((Context)context);
        }

        public void setRange(Calendar minDate, Calendar maxDate) {
            int minYear = minDate.get(1);
            int count = maxDate.get(1) - minYear + 1;
            if (this.mMinYear != minYear || this.mCount != count) {
                this.mMinYear = minYear;
                this.mCount = count;
                this.notifyDataSetInvalidated();
            }
        }

        public boolean setSelection(int year) {
            if (this.mActivatedYear != year) {
                this.mActivatedYear = year;
                this.notifyDataSetChanged();
                return true;
            }
            return false;
        }

        public int getCount() {
            return this.mCount;
        }

        public Integer getItem(int position) {
            return this.getYearForPosition(position);
        }

        public long getItemId(int position) {
            return this.getYearForPosition(position);
        }

        public int getPositionForYear(int year) {
            return year - this.mMinYear;
        }

        public int getYearForPosition(int position) {
            return this.mMinYear + position;
        }

        public boolean hasStableIds() {
            return true;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            boolean activated;
            boolean hasNewView = convertView == null;
            TextView v = hasNewView ? (TextView)this.mInflater.inflate(ITEM_LAYOUT, parent, false) : (TextView)convertView;
            int year = this.getYearForPosition(position);
            boolean bl = activated = this.mActivatedYear == year;
            if (hasNewView || v.isActivated() != activated) {
                int textAppearanceResId = activated && ITEM_TEXT_ACTIVATED_APPEARANCE != 0 ? ITEM_TEXT_ACTIVATED_APPEARANCE : ITEM_TEXT_APPEARANCE;
                if (Build.VERSION.SDK_INT >= 23) {
                    v.setTextAppearance(textAppearanceResId);
                } else {
                    v.setTextAppearance(v.getContext(), textAppearanceResId);
                }
                v.setActivated(activated);
            }
            v.setText((CharSequence)String.format(Locale.getDefault(), "%d", year));
            return v;
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public int getViewTypeCount() {
            return 1;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean areAllItemsEnabled() {
            return true;
        }

        public boolean isEnabled(int position) {
            return true;
        }
    }
}

