/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.datetimepicker;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import com.takisoft.datetimepicker.R;
import com.takisoft.datetimepicker.widget.TimePicker;

public class TimePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
TimePicker.OnTimeChangedListener {
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String IS_24_HOUR = "is24hour";
    private final TimePicker mTimePicker;
    private final OnTimeSetListener mTimeSetListener;
    private final int mInitialHourOfDay;
    private final int mInitialMinute;
    private final boolean mIs24HourView;

    public TimePickerDialog(Context context, OnTimeSetListener listener, int hourOfDay, int minute, boolean is24HourView) {
        this(context, 0, listener, hourOfDay, minute, is24HourView);
    }

    static int resolveDialogTheme(Context context, int resId) {
        if (resId == 0) {
            TypedValue outValue = new TypedValue();
            if (context.getTheme().resolveAttribute(R.attr.timePickerDialogTheme, outValue, true)) {
                return outValue.resourceId;
            }
            return R.style.ThemeOverlay_Material_Dialog_TimePicker;
        }
        return resId;
    }

    public TimePickerDialog(Context context, int themeResId, OnTimeSetListener listener, int hourOfDay, int minute, boolean is24HourView) {
        super(context, TimePickerDialog.resolveDialogTheme(context, themeResId));
        this.mTimeSetListener = listener;
        this.mInitialHourOfDay = hourOfDay;
        this.mInitialMinute = minute;
        this.mIs24HourView = is24HourView;
        Context themeContext = this.getContext();
        LayoutInflater inflater = LayoutInflater.from((Context)themeContext);
        View view = inflater.inflate(R.layout.time_picker_dialog, null);
        this.setView(view);
        this.setButton(-1, themeContext.getString(17039370), this);
        this.setButton(-2, themeContext.getString(0x1040000), this);
        this.mTimePicker = (TimePicker)view.findViewById(R.id.timePicker);
        this.mTimePicker.setIs24HourView(this.mIs24HourView);
        this.mTimePicker.setCurrentHour(this.mInitialHourOfDay);
        this.mTimePicker.setCurrentMinute(this.mInitialMinute);
        this.mTimePicker.setOnTimeChangedListener(this);
    }

    public TimePicker getTimePicker() {
        return this.mTimePicker;
    }

    @Override
    public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
    }

    public void show() {
        super.show();
        this.getButton(-1).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TimePickerDialog.this.mTimePicker.validateInput()) {
                    TimePickerDialog.this.onClick((DialogInterface)TimePickerDialog.this, -1);
                    TimePickerDialog.this.dismiss();
                }
            }
        });
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                if (this.mTimeSetListener == null) break;
                this.mTimeSetListener.onTimeSet(this.mTimePicker, this.mTimePicker.getCurrentHour(), this.mTimePicker.getCurrentMinute());
                break;
            }
            case -2: {
                this.cancel();
            }
        }
    }

    public void updateTime(int hourOfDay, int minuteOfHour) {
        this.mTimePicker.setCurrentHour(hourOfDay);
        this.mTimePicker.setCurrentMinute(minuteOfHour);
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(HOUR, this.mTimePicker.getCurrentHour().intValue());
        state.putInt(MINUTE, this.mTimePicker.getCurrentMinute().intValue());
        state.putBoolean(IS_24_HOUR, this.mTimePicker.is24HourView());
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int hour = savedInstanceState.getInt(HOUR);
        int minute = savedInstanceState.getInt(MINUTE);
        this.mTimePicker.setIs24HourView(savedInstanceState.getBoolean(IS_24_HOUR));
        this.mTimePicker.setCurrentHour(hour);
        this.mTimePicker.setCurrentMinute(minute);
    }

    public static interface OnTimeSetListener {
        public void onTimeSet(TimePicker var1, int var2, int var3);
    }
}

