/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.datetimepicker.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v4.math.MathUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityEvent;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.widget.FrameLayout;
import com.takisoft.datetimepicker.R;
import com.takisoft.datetimepicker.util.Utils;
import com.takisoft.datetimepicker.widget.TimePickerClockDelegate;
import com.takisoft.datetimepicker.widget.TimePickerSpinnerDelegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;

public class TimePicker
extends FrameLayout {
    private static final String LOG_TAG = TimePicker.class.getSimpleName();
    public static final int MODE_SPINNER = 1;
    public static final int MODE_CLOCK = 2;
    private TimePickerDelegate mDelegate;
    private int mMode;

    public TimePicker(Context context) {
        this(context, null);
    }

    public TimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.timePickerStyle);
    }

    public TimePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.attrHandler(context, attrs, defStyleAttr, Utils.isLightTheme(context) ? R.style.Widget_Material_Light_TimePicker : R.style.Widget_Material_TimePicker);
    }

    @TargetApi(value=21)
    public TimePicker(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.attrHandler(context, attrs, defStyleAttr, defStyleRes);
    }

    private void attrHandler(final Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (Build.VERSION.SDK_INT > 26 && this.getImportantForAutofill() == 0) {
            this.setImportantForAutofill(1);
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        boolean isDialogMode = a.getBoolean(R.styleable.TimePicker_dialogMode, false);
        int requestedMode = a.getInt(R.styleable.TimePicker_timePickerMode, 1);
        a.recycle();
        this.mMode = requestedMode == 2 && isDialogMode ? context.getResources().getInteger(R.integer.time_picker_mode) : requestedMode;
        switch (this.mMode) {
            case 2: {
                this.mDelegate = new TimePickerClockDelegate(this, context, attrs, defStyleAttr, defStyleRes);
                break;
            }
            default: {
                this.mDelegate = new TimePickerSpinnerDelegate(this, context, attrs, defStyleAttr, defStyleRes);
            }
        }
        this.mDelegate.setAutoFillChangeListener(new OnTimeChangedListener(){

            @Override
            public void onTimeChanged(TimePicker v, int h, int m) {
                AutofillManager afm;
                if (Build.VERSION.SDK_INT >= 26 && (afm = (AutofillManager)context.getSystemService(AutofillManager.class)) != null) {
                    afm.notifyValueChanged((View)TimePicker.this);
                }
            }
        });
    }

    public int getMode() {
        return this.mMode;
    }

    public void setHour(@IntRange(from=0L, to=23L) int hour) {
        this.mDelegate.setHour(MathUtils.clamp((int)hour, (int)0, (int)23));
    }

    public int getHour() {
        return this.mDelegate.getHour();
    }

    public void setMinute(@IntRange(from=0L, to=59L) int minute) {
        this.mDelegate.setMinute(MathUtils.clamp((int)minute, (int)0, (int)59));
    }

    public int getMinute() {
        return this.mDelegate.getMinute();
    }

    @Deprecated
    public void setCurrentHour(@NonNull Integer currentHour) {
        this.setHour(currentHour);
    }

    @Deprecated
    @NonNull
    public Integer getCurrentHour() {
        return this.getHour();
    }

    @Deprecated
    public void setCurrentMinute(@NonNull Integer currentMinute) {
        this.setMinute(currentMinute);
    }

    @Deprecated
    @NonNull
    public Integer getCurrentMinute() {
        return this.getMinute();
    }

    public void setIs24HourView(@NonNull Boolean is24HourView) {
        if (is24HourView == null) {
            return;
        }
        this.mDelegate.setIs24Hour(is24HourView);
    }

    public boolean is24HourView() {
        return this.mDelegate.is24Hour();
    }

    public void setOnTimeChangedListener(OnTimeChangedListener onTimeChangedListener) {
        this.mDelegate.setOnTimeChangedListener(onTimeChangedListener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mDelegate.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.mDelegate.isEnabled();
    }

    public int getBaseline() {
        return this.mDelegate.getBaseline();
    }

    public boolean validateInput() {
        return this.mDelegate.validateInput();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return this.mDelegate.onSaveInstanceState(superState);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        View.BaseSavedState ss = (View.BaseSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mDelegate.onRestoreInstanceState((Parcelable)ss);
    }

    public CharSequence getAccessibilityClassName() {
        return TimePicker.class.getName();
    }

    private View getHourView() {
        return this.mDelegate.getHourView();
    }

    private View getMinuteView() {
        return this.mDelegate.getMinuteView();
    }

    private View getAmView() {
        return this.mDelegate.getAmView();
    }

    private View getPmView() {
        return this.mDelegate.getPmView();
    }

    static String[] getAmPmStrings(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        String[] result = new String[2];
        String[] amPm = Build.VERSION.SDK_INT >= 24 ? android.icu.text.DateFormatSymbols.getInstance((Locale)locale).getAmPmStrings() : DateFormatSymbols.getInstance(locale).getAmPmStrings();
        result[0] = amPm[0].length() > 4 ? amPm[0].substring(0, 1) : amPm[0];
        result[1] = amPm[1].length() > 4 ? amPm[1].substring(0, 1) : amPm[1];
        return result;
    }

    @TargetApi(value=26)
    public void dispatchProvideAutofillStructure(ViewStructure structure, int flags) {
        structure.setAutofillId(this.getAutofillId());
        this.onProvideAutofillStructure(structure, flags);
    }

    @TargetApi(value=26)
    public void autofill(AutofillValue value) {
        if (!this.isEnabled()) {
            return;
        }
        if (!value.isDate()) {
            Log.w((String)LOG_TAG, (String)(value + " could not be autofilled into " + (Object)((Object)this)));
            return;
        }
        this.mDelegate.setDate(value.getDateValue());
    }

    @TargetApi(value=26)
    public int getAutofillType() {
        return this.isEnabled() ? 4 : 0;
    }

    @TargetApi(value=26)
    public AutofillValue getAutofillValue() {
        return this.isEnabled() ? AutofillValue.forDate((long)this.mDelegate.getDate()) : null;
    }

    static abstract class AbstractTimePickerDelegate
    implements TimePickerDelegate {
        protected final TimePicker mDelegator;
        protected final Context mContext;
        protected final Locale mLocale;
        protected OnTimeChangedListener mOnTimeChangedListener;
        protected OnTimeChangedListener mAutoFillChangeListener;

        public AbstractTimePickerDelegate(@NonNull TimePicker delegator, @NonNull Context context) {
            this.mDelegator = delegator;
            this.mContext = context;
            this.mLocale = context.getResources().getConfiguration().locale;
        }

        @Override
        public void setOnTimeChangedListener(OnTimeChangedListener callback) {
            this.mOnTimeChangedListener = callback;
        }

        @Override
        public void setAutoFillChangeListener(OnTimeChangedListener callback) {
            this.mAutoFillChangeListener = callback;
        }

        @Override
        public void setDate(long date) {
            Calendar cal = Calendar.getInstance(this.mLocale);
            cal.setTimeInMillis(date);
            this.setHour(cal.get(11));
            this.setMinute(cal.get(12));
        }

        @Override
        public long getDate() {
            Calendar cal = Calendar.getInstance(this.mLocale);
            cal.set(11, this.getHour());
            cal.set(12, this.getMinute());
            return cal.getTimeInMillis();
        }

        protected static class SavedState
        extends View.BaseSavedState {
            private final int mHour;
            private final int mMinute;
            private final boolean mIs24HourMode;
            private final int mCurrentItemShowing;
            public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

                public SavedState createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };

            public SavedState(Parcelable superState, int hour, int minute, boolean is24HourMode) {
                this(superState, hour, minute, is24HourMode, 0);
            }

            public SavedState(Parcelable superState, int hour, int minute, boolean is24HourMode, int currentItemShowing) {
                super(superState);
                this.mHour = hour;
                this.mMinute = minute;
                this.mIs24HourMode = is24HourMode;
                this.mCurrentItemShowing = currentItemShowing;
            }

            private SavedState(Parcel in) {
                super(in);
                this.mHour = in.readInt();
                this.mMinute = in.readInt();
                this.mIs24HourMode = in.readInt() == 1;
                this.mCurrentItemShowing = in.readInt();
            }

            public int getHour() {
                return this.mHour;
            }

            public int getMinute() {
                return this.mMinute;
            }

            public boolean is24HourMode() {
                return this.mIs24HourMode;
            }

            public int getCurrentItemShowing() {
                return this.mCurrentItemShowing;
            }

            public void writeToParcel(Parcel dest, int flags) {
                super.writeToParcel(dest, flags);
                dest.writeInt(this.mHour);
                dest.writeInt(this.mMinute);
                dest.writeInt(this.mIs24HourMode ? 1 : 0);
                dest.writeInt(this.mCurrentItemShowing);
            }
        }
    }

    static interface TimePickerDelegate {
        public void setHour(@IntRange(from=0L, to=23L) int var1);

        public int getHour();

        public void setMinute(@IntRange(from=0L, to=59L) int var1);

        public int getMinute();

        public void setDate(long var1);

        public long getDate();

        public void setIs24Hour(boolean var1);

        public boolean is24Hour();

        public boolean validateInput();

        public void setOnTimeChangedListener(OnTimeChangedListener var1);

        public void setAutoFillChangeListener(OnTimeChangedListener var1);

        public void setEnabled(boolean var1);

        public boolean isEnabled();

        public int getBaseline();

        public Parcelable onSaveInstanceState(Parcelable var1);

        public void onRestoreInstanceState(Parcelable var1);

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent var1);

        public void onPopulateAccessibilityEvent(AccessibilityEvent var1);

        public View getHourView();

        public View getMinuteView();

        public View getAmView();

        public View getPmView();
    }

    public static interface OnTimeChangedListener {
        public void onTimeChanged(TimePicker var1, int var2, int var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimePickerMode {
    }
}

