/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared.network.handlers;

import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.shared.network.ConfigApiService;
import com.taboola.lightnetwork.dynamic_url.DynamicRequest;
import com.taboola.lightnetwork.dynamic_url.NetworkExecutable;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import java.util.Map;

public class ConfigApiServiceMonitorImp
implements ConfigApiService {
    private final ConfigApiService.ApiService mDefaultApiService;
    private ConfigApiService.ApiService mConfigApiService;
    private ConfigApiService.ApiService mLanguagesConfigApiService;

    ConfigApiServiceMonitorImp(@NonNull HttpManager httpManager, @NonNull ConfigApiService.ApiService defaultApiService) {
        this.mDefaultApiService = defaultApiService;
        Pair<String, String> pair = BridgeInternal.getConfigUrlsFromMonitor();
        String configUrl = (String)pair.first;
        this.mConfigApiService = TextUtils.isEmpty((CharSequence)configUrl) ? defaultApiService : (ConfigApiService.ApiService)new NetworkExecutable(httpManager, configUrl).create(ConfigApiService.ApiService.class);
        String langUrl = (String)pair.second;
        this.mLanguagesConfigApiService = TextUtils.isEmpty((CharSequence)langUrl) ? null : (ConfigApiService.ApiService)new NetworkExecutable(httpManager, langUrl).create(ConfigApiService.ApiService.class);
    }

    @Override
    public DynamicRequest getLanguagesConfigRequest(@NonNull String publisherName, @NonNull Map<String, String> queryMap) {
        if (this.mLanguagesConfigApiService == null) {
            return this.mDefaultApiService.getLanguagesConfig();
        }
        return this.mLanguagesConfigApiService.getLanguagesConfig();
    }

    @Override
    public DynamicRequest getConfigRequest(@NonNull String publisherName, @NonNull String configId, @NonNull Map<String, String> queryMap) {
        return this.mConfigApiService.getConfig();
    }

    @Override
    public ConfigApiService.ApiService getApiService() {
        return this.mDefaultApiService;
    }
}

