/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.push_notifications;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.widget.RemoteViews;
import com.squareup.picasso.Picasso;
import com.taboola.android.plus.R;
import com.taboola.android.plus.push_notifications.PushNotificationsConfig;
import com.taboola.android.plus.push_notifications.PushNotificationsStateReceiver;
import com.taboola.android.plus.push_notifications.TBPushNotificationsManager;
import com.taboola.android.plus.push_notifications.models.BreakingNotificationContent;
import com.taboola.android.plus.shared.ConditionCheckUtil;
import com.taboola.android.plus.shared.LocalizationStrings;
import com.taboola.android.plus.shared.SharedNotificationUtil;
import com.taboola.android.utils.UrlUtils;

@RequiresApi(api=21)
public class TBPushNotificationRenderer {
    private static final String TAG = TBPushNotificationRenderer.class.getSimpleName();
    public static final String NOTIFICATION_INTENT_EXTRA_KEY_PUSH_CONTENT = "com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PUSH_CONTENT";
    public static final int PUSH_BREAKING_REQUEST_CODE_DISMISSED = 4100;
    public static final int PUSH_BREAKING_REQUEST_CODE_DEFAULT_NOTIFICATION_CLICK = 5300;
    static final String BREAKING_NEWS_CHANNEL_ID = "Breaking news";
    private static final String INTENT_KEY_REQUEST_CODE = "intent_key_request_code";
    private static final int NOTIFICATION_ID = 3335996;
    private final TBPushNotificationsManager TBPushNotificationsManager;
    private final Context appContext;
    private final int collapsedThumbnailWidth;
    private final int collapsedThumbnailHeight;
    private final int expandedThumbnailWidth;
    private final int expandedThumbnailHeight;
    private NotificationManager notificationManager;
    private int iconId;

    TBPushNotificationRenderer(@NonNull Context appContext, @NonNull TBPushNotificationsManager TBPushNotificationsManager2, int iconId) {
        this.appContext = appContext;
        this.TBPushNotificationsManager = TBPushNotificationsManager2;
        this.notificationManager = (NotificationManager)appContext.getSystemService("notification");
        this.createNotificationChannelIfNeeded();
        this.iconId = iconId;
        Resources resources = appContext.getResources();
        this.collapsedThumbnailHeight = (int)resources.getDimension(R.dimen.tbn_collapsed_stream_image_height);
        this.collapsedThumbnailWidth = (int)resources.getDimension(R.dimen.tbn_collapsed_stream_image_width);
        this.expandedThumbnailHeight = (int)resources.getDimension(R.dimen.tbn_expanded_img_height);
        this.expandedThumbnailWidth = Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    RenderResult renderNotification(BreakingNotificationContent pushNotificationContent, PushNotificationsConfig config) {
        if (this.TBPushNotificationsManager.handleNotificationBlockByUser()) {
            return new RenderResult(false, "User has blocked notifications for app or channel");
        }
        try {
            if (!this.doAllResourcesExist(this.appContext, this.iconId)) {
                throw new IllegalStateException("Not all resource files exist (is the app being updated?)");
            }
            Notification notification = this.buildNotification(pushNotificationContent, config);
            if (notification == null) {
                return new RenderResult(false, "Failed to build Notification with error: missing data for creating notification");
            }
            this.notificationManager.notify(3335996, notification);
            return new RenderResult(true, null);
        }
        catch (Exception e) {
            return new RenderResult(false, "Failed to build Notification with error: " + e.getLocalizedMessage());
        }
    }

    private Notification buildNotification(BreakingNotificationContent pushNotificationContent, PushNotificationsConfig config) {
        String appName = SharedNotificationUtil.getCurrentApplicationName(this.appContext);
        RemoteViews collapsedView = this.buildCollapsedView(pushNotificationContent, appName, this.TBPushNotificationsManager.getLocalizationStrings(), config.getLayoutConfig().getCollapsedBreaking().getBreakingLabelStringId());
        RemoteViews expandedView = this.buildExpandedView(pushNotificationContent, appName, this.TBPushNotificationsManager.getLocalizationStrings(), config.getLayoutConfig().getExpandedBreaking().getBreakingLabelStringId());
        PendingIntent dismissIntent = this.getPendingIntentForAction(this.appContext, 4100, pushNotificationContent);
        PendingIntent defaultClickIntent = this.getPendingIntentForClick(this.appContext, 5300, 0, pushNotificationContent);
        Notification notification = new NotificationCompat.Builder(this.appContext, BREAKING_NEWS_CHANNEL_ID).setSmallIcon(this.iconId).setAutoCancel(false).setContentTitle((CharSequence)pushNotificationContent.getTitle()).setContentText((CharSequence)pushNotificationContent.getDescription()).setCustomContentView(collapsedView).setCustomBigContentView(expandedView).setVisibility(1).setOnlyAlertOnce(true).setDeleteIntent(dismissIntent).setContentIntent(defaultClickIntent).setPriority(1).build();
        this.loadNotificationThumbnails(notification, expandedView, collapsedView, pushNotificationContent.getImage());
        return notification;
    }

    private RemoteViews buildCollapsedView(BreakingNotificationContent pushNotificationContent, String appName, LocalizationStrings localizationStrings, String breakingLabelStringId) {
        RemoteViews collapsedView = new RemoteViews(this.appContext.getPackageName(), R.layout.layout_breaking_news_collapsed);
        collapsedView.setTextViewText(R.id.title, (CharSequence)pushNotificationContent.getTitle());
        collapsedView.setTextViewText(R.id.application_name, (CharSequence)appName);
        collapsedView.setTextViewText(R.id.description, (CharSequence)pushNotificationContent.getDescription());
        collapsedView.setImageViewResource(R.id.application_icon, this.iconId);
        collapsedView.setTextViewText(R.id.brand, (CharSequence)pushNotificationContent.getBrand());
        String breakingCollapsedText = localizationStrings.getLocalizationStringsMap().get(breakingLabelStringId);
        if (breakingCollapsedText == null) {
            breakingCollapsedText = localizationStrings.getDefaultPushNotificationBreakingText();
        }
        collapsedView.setTextViewText(R.id.breaking_title, (CharSequence)breakingCollapsedText);
        return collapsedView;
    }

    private RemoteViews buildExpandedView(BreakingNotificationContent pushNotificationContent, String appName, LocalizationStrings localizationStrings, String breakingLabelStringId) {
        RemoteViews expandedView = new RemoteViews(this.appContext.getPackageName(), R.layout.layout_breaking_news_expanded);
        expandedView.setTextViewText(R.id.title, (CharSequence)pushNotificationContent.getTitle());
        expandedView.setTextViewText(R.id.application_name, (CharSequence)appName);
        expandedView.setTextViewText(R.id.description, (CharSequence)pushNotificationContent.getDescription());
        expandedView.setImageViewResource(R.id.application_icon, this.iconId);
        expandedView.setTextViewText(R.id.brand, (CharSequence)pushNotificationContent.getBrand());
        String breakingExpandedText = localizationStrings.getLocalizationStringsMap().get(breakingLabelStringId);
        if (breakingExpandedText == null) {
            breakingExpandedText = localizationStrings.getDefaultPushNotificationBreakingText();
        }
        expandedView.setTextViewText(R.id.breaking_title, (CharSequence)breakingExpandedText);
        return expandedView;
    }

    private void loadNotificationThumbnails(@NonNull Notification notification, @NonNull RemoteViews expandedView, @NonNull RemoteViews collapsedView, @NonNull String thumbnailUrl) {
        String collapsedThumbnailUrl = UrlUtils.replaceImageSizeInUrl((String)thumbnailUrl, (int)this.collapsedThumbnailHeight, (int)this.collapsedThumbnailWidth);
        String expandedThumbnailUrl = UrlUtils.replaceImageSizeInUrl((String)thumbnailUrl, (int)this.expandedThumbnailHeight, (int)this.expandedThumbnailWidth);
        Picasso.with((Context)this.appContext).load(collapsedThumbnailUrl).error(R.drawable.placeholder).into(collapsedView, R.id.content_img, 3335996, notification);
        Picasso.with((Context)this.appContext).load(expandedThumbnailUrl).error(R.drawable.placeholder).into(expandedView, R.id.content_img, 3335996, notification);
    }

    private void createNotificationChannelIfNeeded() {
        if (ConditionCheckUtil.areNotificationChannelsSupported()) {
            NotificationChannel channel = new NotificationChannel(BREAKING_NEWS_CHANNEL_ID, (CharSequence)BREAKING_NEWS_CHANNEL_ID, 4);
            channel.setLockscreenVisibility(1);
            this.notificationManager.createNotificationChannel(channel);
        }
    }

    private PendingIntent getPendingIntentForAction(@NonNull Context context, int requestCode, BreakingNotificationContent pushNotificationContent) {
        Intent intent = new Intent(context, PushNotificationsStateReceiver.class);
        Bundle extras = new Bundle();
        extras.putInt(INTENT_KEY_REQUEST_CODE, requestCode);
        extras.putParcelable(NOTIFICATION_INTENT_EXTRA_KEY_PUSH_CONTENT, (Parcelable)pushNotificationContent);
        intent.putExtras(extras);
        return PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)intent, (int)0x8000000);
    }

    private PendingIntent getPendingIntentForClick(@NonNull Context context, int requestCode, int itemIndex, BreakingNotificationContent breakingNotificationContent) {
        int requestCodeWithCounter = requestCode + itemIndex;
        Intent intent = new Intent(context, PushNotificationsStateReceiver.class);
        Bundle extras = new Bundle();
        extras.putInt(INTENT_KEY_REQUEST_CODE, requestCodeWithCounter);
        extras.putParcelable(NOTIFICATION_INTENT_EXTRA_KEY_PUSH_CONTENT, (Parcelable)breakingNotificationContent);
        intent.putExtras(extras);
        return PendingIntent.getBroadcast((Context)context, (int)requestCodeWithCounter, (Intent)intent, (int)0x8000000);
    }

    void dismissNotification() {
        this.notificationManager.cancel(3335996);
    }

    void setNotificationIcon(int iconId) {
        this.iconId = iconId;
    }

    private boolean doAllResourcesExist(@NonNull Context context, int iconId) {
        int[] layoutIds = new int[]{R.layout.layout_breaking_news_collapsed, R.layout.layout_breaking_news_expanded};
        try {
            for (int layoutId : layoutIds) {
                context.getResources().getLayout(layoutId);
            }
            context.getResources().getDrawable(iconId, null);
            return true;
        }
        catch (Resources.NotFoundException e) {
            Log.d((String)TAG, (String)("doAllResourcesExist: " + e.getMessage()));
            return false;
        }
    }

    static final class RenderResult {
        private final boolean isSuccessful;
        private final String errorMessage;

        RenderResult(boolean isSuccessful, String errorMessage) {
            this.isSuccessful = isSuccessful;
            this.errorMessage = errorMessage;
        }

        public RenderResult(boolean isSuccessful) {
            this.isSuccessful = isSuccessful;
            this.errorMessage = "";
        }

        boolean isSuccessful() {
            return this.isSuccessful;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

