/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.push_notifications;

import android.content.Context;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.google.firebase.messaging.RemoteMessage;
import com.google.gson.Gson;
import com.ocamba.hoood.notifications.OcambaNotificationObject;
import com.ocamba.hoood.notifications.OcambaNotificationReceiver;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.TaboolaPlus;
import com.taboola.android.plus.notification.TBNotificationManager;
import com.taboola.android.plus.push_notifications.BridgeInternalPushNotification;
import com.taboola.android.plus.push_notifications.PushNotificationsAnalyticsManager;
import com.taboola.android.plus.push_notifications.PushNotificationsUtil;
import com.taboola.android.plus.push_notifications.PushValidationUtil;
import com.taboola.android.plus.push_notifications.TBPushNotificationsManager;
import com.taboola.android.plus.push_notifications.models.BreakingNotificationContent;
import com.taboola.android.plus.push_notifications.models.CustomDataContent;
import com.taboola.android.plus.push_notifications.models.WakeUpContent;

@RequiresApi(api=21)
public class OcambaPushReceiver
extends OcambaNotificationReceiver {
    private static final String TAG = OcambaPushReceiver.class.getSimpleName();

    public void ocambaNewToken(String token, Context context) {
        Log.d((String)TAG, (String)"ocambaNewToken() called");
    }

    public void ocambaNotificationUser(RemoteMessage remoteMessage, Context context) {
        Log.d((String)TAG, (String)"ocambaNotificationUser() called");
    }

    public void ocambaNotificationReceived(final OcambaNotificationObject ocambaNotificationObject, Context context) {
        Log.d((String)TAG, (String)"ocambaNotificationReceived() called");
        BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

            @Override
            @RequiresApi(api=21)
            public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                OcambaPushReceiver.this.onTaboolaPlusRetrieved(taboolaPlus.getNotificationManager(), taboolaPlus.getPushNotificationsManager(), ocambaNotificationObject);
            }
        }, new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

            @Override
            public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("handleTaboolaPush: Taboola Plus restore failed : " + throwable.getMessage()), (Throwable)throwable);
            }
        });
    }

    private void onTaboolaPlusRetrieved(TBNotificationManager tbNotificationManager, TBPushNotificationsManager tbPushNotificationsManager, OcambaNotificationObject ocambaNotificationObject) {
        PushNotificationsAnalyticsManager analyticsManager;
        CustomDataContent customDataContent = (CustomDataContent)new Gson().fromJson(ocambaNotificationObject.getCustomData(), CustomDataContent.class);
        if (PushValidationUtil.isOcambaPushActionValid(customDataContent, analyticsManager = BridgeInternalPushNotification.getAnalyticsManager(tbPushNotificationsManager))) {
            String actions = customDataContent.getAction();
            analyticsManager.sendPushReceivedEvent(ocambaNotificationObject.getTitle(), customDataContent.getMessageId(), actions);
            switch (actions) {
                case "breaking": {
                    BreakingNotificationContent breakingNotificationContent = PushNotificationsUtil.parseOcambaObjectIntoBreaking(ocambaNotificationObject);
                    if (PushValidationUtil.isBreakingPushValid(breakingNotificationContent, analyticsManager)) {
                        tbPushNotificationsManager.renderBreakingNotification(breakingNotificationContent);
                        break;
                    }
                    Log.e((String)TAG, (String)"onTaboolaPlusRetrieved: Breaking push validation failed, push notification won't be shown");
                    break;
                }
                case "wake": {
                    WakeUpContent wakeUpContent = PushNotificationsUtil.parseOcambaObjectIntoWake(ocambaNotificationObject);
                    if (PushValidationUtil.isWakePushValid(wakeUpContent, analyticsManager)) {
                        PushNotificationsUtil.onWakePushReceived(tbNotificationManager);
                        break;
                    }
                    Log.e((String)TAG, (String)"onTaboolaPlusRetrieved: Wake push validation failed, wake push will be ignored");
                    break;
                }
                default: {
                    Log.d((String)TAG, (String)"Unknown type of push notification");
                    break;
                }
            }
        } else {
            Log.e((String)TAG, (String)"onTaboolaPlusRetrieved: Invalid action, push notification will be ignored");
        }
    }

    public void ocambaNotificationClick(OcambaNotificationObject ocambaNotificationObject, Context context) {
        Log.d((String)TAG, (String)"ocambaNotificationClick() called");
    }

    public void ocambaNotificationActionButtons(String s, Context context) {
        Log.d((String)TAG, (String)("ocambaNotificationActionButtons() called with: s = [" + s + "]"));
    }

    public void ocambaNotificationDismissed(Context context) {
        Log.d((String)TAG, (String)"ocambaNotificationDismissed() called");
    }

    public void ocambaNotificationMultiMessageReceived() {
        Log.d((String)TAG, (String)"ocambaNotificationMultiMessageReceived() called");
    }

    public void ocambaNotificationCustomAction(String s, Context context) {
        Log.d((String)TAG, (String)"ocambaNotificationCustomAction() called");
    }
}

