/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.google.gson.annotations.SerializedName;
import com.taboola.android.plus.notification.killSwitch.KillSwitchConfig;
import com.taboola.android.plus.shared.AllowedTimeWindows;
import java.util.ArrayList;
import java.util.List;

public class NotificationConfig
implements Parcelable {
    private static final String TAG = NotificationConfig.class.getSimpleName();
    public static final String NOTIFICATIONS_CONFIG = "notificationsConfig";
    private static final String ITEMS_BATCH_SIZE = "itemsBatchSize";
    private static final String TRENDING_ITEMS_COUNT = "trendingItemsCount";
    private static final String REFRESH_INTERVAL_MS = "refreshIntervalMs";
    private static final String SWITCH_CONTENT_INTERVAL_MS = "switchContentIntervalMs";
    private static final String IS_ONLY_WIFI_MODE = "isOnlyWifiMode";
    private static final String NOTIFICATION_PLACEMENT_NAME = "placementName";
    private static final String NOTIFICATION_APPLICATION_NAME = "applicationName";
    private static final String CONFIG_VARIANT = "configVariant";
    private static final String NON_CLICKABLE_URL_MARKER = "nonClickableUrlMarker";
    private static final String LAYOUT_CONFIG = "layoutConfig";
    private static final String NOTIFICATION_CATEGORIES = "notificationCategories";
    private static final String KILL_SWITCH_CONFIG = "killSwitchConfig";
    private static final String NOTIFICATION_INTERVAL = "allowedTimeWindows";
    private static final String SHOULD_THROTTLE_DISMISS_EVENT = "shouldThrottleDismissEvent";
    private static final String READ_MORE_CONFIG = "readMoreConfig";
    private static final String NOTIFICATION_TRIGGERS_PER_DAY = "maxTriggerCountPerDay";
    private static final String MIN_NOTIFICATION_TRIGGER_INTERVAL_MS = "minTriggerIntervalMs";
    private static final String SMART_NOTIFICATION_FREQUENCY = "smartNotificationFrequency";
    public static final String DISMISS_NOTIFICATION_ON_JOB_RUN = "dismissNotificationOnJobRun";
    @SerializedName(value="itemsBatchSize")
    private int itemsBatchSize = 1;
    @SerializedName(value="trendingItemsCount")
    private int trendingItemsCount = 0;
    @SerializedName(value="refreshIntervalMs")
    private int refreshIntervalMs = 900000;
    @SerializedName(value="switchContentIntervalMs")
    private int switchContentIntervalMs = 60000;
    @SerializedName(value="maxTriggerCountPerDay")
    private int maxTriggerCountPerDay = -1;
    @SerializedName(value="minTriggerIntervalMs")
    private int minTriggerIntervalMs = 0;
    @SerializedName(value="isOnlyWifiMode")
    @Nullable
    private Boolean isWifiOnlyMode = null;
    @SerializedName(value="shouldThrottleDismissEvent")
    private boolean shouldThrottleDismissEvent;
    @SerializedName(value="placementName")
    @NonNull
    private String placementName = "";
    @SerializedName(value="applicationName")
    @NonNull
    private String applicationName = "";
    @SerializedName(value="configVariant")
    @NonNull
    private String configVariant = "";
    @SerializedName(value="nonClickableUrlMarker")
    @NonNull
    private String nonClickableUrlMarker = "";
    @SerializedName(value="readMoreConfig")
    @NonNull
    private ReadMoreConfig readMoreConfig = new ReadMoreConfig();
    @SerializedName(value="layoutConfig")
    @NonNull
    private LayoutConfig layoutConfig = new LayoutConfig();
    @SerializedName(value="notificationCategories")
    @NonNull
    @Size(min=0L)
    private List<String> notificationCategories = new ArrayList<String>();
    @SerializedName(value="killSwitchConfig")
    @NonNull
    private KillSwitchConfig killSwitchConfig = new KillSwitchConfig();
    @SerializedName(value="smartNotificationFrequency")
    @NonNull
    private SmartNotificationFrequency smartNotificationFrequency = new SmartNotificationFrequency();
    @SerializedName(value="allowedTimeWindows")
    @NonNull
    @Size(min=0L)
    private List<AllowedTimeWindows> allowedIntervals = new ArrayList<AllowedTimeWindows>();
    @SerializedName(value="dismissNotificationOnJobRun")
    private boolean dismissNotificationOnJobRun = true;
    public static final Parcelable.Creator<NotificationConfig> CREATOR = new Parcelable.Creator<NotificationConfig>(){

        public NotificationConfig createFromParcel(Parcel source) {
            return new NotificationConfig(source);
        }

        public NotificationConfig[] newArray(int size) {
            return new NotificationConfig[size];
        }
    };

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.itemsBatchSize);
        dest.writeInt(this.trendingItemsCount);
        dest.writeInt(this.refreshIntervalMs);
        dest.writeInt(this.switchContentIntervalMs);
        dest.writeInt(this.maxTriggerCountPerDay);
        dest.writeInt(this.minTriggerIntervalMs);
        dest.writeValue((Object)this.isWifiOnlyMode);
        dest.writeByte(this.shouldThrottleDismissEvent ? (byte)1 : 0);
        dest.writeString(this.placementName);
        dest.writeString(this.applicationName);
        dest.writeString(this.configVariant);
        dest.writeString(this.nonClickableUrlMarker);
        dest.writeParcelable((Parcelable)this.readMoreConfig, flags);
        dest.writeParcelable((Parcelable)this.layoutConfig, flags);
        dest.writeStringList(this.notificationCategories);
        dest.writeParcelable((Parcelable)this.killSwitchConfig, flags);
        dest.writeParcelable((Parcelable)this.smartNotificationFrequency, flags);
        dest.writeTypedList(this.allowedIntervals);
        dest.writeByte(this.dismissNotificationOnJobRun ? (byte)1 : 0);
    }

    public NotificationConfig() {
    }

    protected NotificationConfig(Parcel in) {
        this.itemsBatchSize = in.readInt();
        this.trendingItemsCount = in.readInt();
        this.refreshIntervalMs = in.readInt();
        this.switchContentIntervalMs = in.readInt();
        this.maxTriggerCountPerDay = in.readInt();
        this.minTriggerIntervalMs = in.readInt();
        this.isWifiOnlyMode = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.shouldThrottleDismissEvent = in.readByte() != 0;
        this.placementName = in.readString();
        this.applicationName = in.readString();
        this.configVariant = in.readString();
        this.nonClickableUrlMarker = in.readString();
        this.readMoreConfig = (ReadMoreConfig)in.readParcelable(ReadMoreConfig.class.getClassLoader());
        this.layoutConfig = (LayoutConfig)in.readParcelable(LayoutConfig.class.getClassLoader());
        this.notificationCategories = in.createStringArrayList();
        this.killSwitchConfig = (KillSwitchConfig)in.readParcelable(KillSwitchConfig.class.getClassLoader());
        this.smartNotificationFrequency = (SmartNotificationFrequency)in.readParcelable(SmartNotificationFrequency.class.getClassLoader());
        this.allowedIntervals = in.createTypedArrayList(AllowedTimeWindows.CREATOR);
        this.dismissNotificationOnJobRun = in.readByte() != 0;
    }

    @NonNull
    String getPlacementName() {
        return this.placementName;
    }

    @NonNull
    public String getApplicationName() {
        return this.applicationName;
    }

    int getItemsBatchSize() {
        return this.itemsBatchSize;
    }

    int getTrendingItemsCount() {
        return this.trendingItemsCount;
    }

    int getRefreshIntervalMs() {
        return this.refreshIntervalMs;
    }

    int getSwitchContentIntervalMs() {
        return this.switchContentIntervalMs;
    }

    public int getMaxNotificationTriggerCountPerDay() {
        return this.maxTriggerCountPerDay;
    }

    public int getMinTriggerIntervalMs() {
        return this.minTriggerIntervalMs;
    }

    public boolean shouldThrottleDismissEvent() {
        return this.shouldThrottleDismissEvent;
    }

    @Nullable
    public Boolean isWifiOnlyMode() {
        return this.isWifiOnlyMode;
    }

    @NonNull
    public String getConfigVariant() {
        return this.configVariant;
    }

    @NonNull
    public String getNonClickableUrlMarker() {
        return this.nonClickableUrlMarker;
    }

    @NonNull
    public LayoutConfig getLayoutConfig() {
        return this.layoutConfig;
    }

    @NonNull
    public ReadMoreConfig getReadMoreConfig() {
        return this.readMoreConfig;
    }

    @NonNull
    @Size(min=0L)
    public List<String> getAllowedCategories() {
        return this.notificationCategories;
    }

    @NonNull
    public KillSwitchConfig getKillSwitchConfig() {
        return this.killSwitchConfig;
    }

    @NonNull
    @Size(min=0L)
    public List<AllowedTimeWindows> getAllowedIntervals() {
        return this.allowedIntervals;
    }

    @NonNull
    public NotificationConfig setMaxTriggerCountPerDay(@IntRange(from=0L) int maxTriggerCountPerDay) {
        this.maxTriggerCountPerDay = maxTriggerCountPerDay;
        return this;
    }

    @NonNull
    public NotificationConfig setMinTriggerIntervalMs(int minTriggerIntervalMs) {
        this.minTriggerIntervalMs = minTriggerIntervalMs;
        return this;
    }

    @NonNull
    public SmartNotificationFrequency getSmartNotificationFrequency() {
        return this.smartNotificationFrequency;
    }

    public void setSmartNotificationFrequency(@NonNull SmartNotificationFrequency smartNotificationFrequency) {
        this.smartNotificationFrequency = smartNotificationFrequency;
    }

    public boolean shouldDismissNotificationOnJobRun() {
        return this.dismissNotificationOnJobRun;
    }

    public int describeContents() {
        return 0;
    }

    static class SmartNotificationFrequency
    implements Parcelable {
        private static final String ENGAGEMENT_GROUPS = "engagementGroups";
        @SerializedName(value="engagementGroups")
        @NonNull
        @Size(min=0L)
        private List<EngagementGroup> engagementGroups = new ArrayList<EngagementGroup>();
        public static final Parcelable.Creator<SmartNotificationFrequency> CREATOR = new Parcelable.Creator<SmartNotificationFrequency>(){

            public SmartNotificationFrequency createFromParcel(Parcel source) {
                return new SmartNotificationFrequency(source);
            }

            public SmartNotificationFrequency[] newArray(int size) {
                return new SmartNotificationFrequency[size];
            }
        };

        @NonNull
        @Size(min=0L)
        List<EngagementGroup> getEngagementGroups() {
            return this.engagementGroups;
        }

        public SmartNotificationFrequency setEngagementGroups(@NonNull List<EngagementGroup> engagementGroups) {
            this.engagementGroups = engagementGroups;
            return this;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeTypedList(this.engagementGroups);
        }

        public SmartNotificationFrequency() {
        }

        protected SmartNotificationFrequency(Parcel in) {
            ArrayList engagementGroupsFromCreator = in.createTypedArrayList(EngagementGroup.CREATOR);
            this.engagementGroups = engagementGroupsFromCreator != null ? engagementGroupsFromCreator : new ArrayList();
        }

        public static class EngagementGroup
        implements Parcelable {
            private static final String ALLOWED_TIME_WINDOWS = "allowedTimeWindows";
            private static final String MAX_TRIGGER_COUNT_PER_DAY = "maxTriggerCountPerDay";
            private static final String MIN_TRIGGER_INTERVAL_MS = "minTriggerIntervalMs";
            private static final String GROUP_NAME = "groupName";
            private static final String DISMISSED_NOTIFICATION_LIMIT = "dismissedNotificationLimit";
            private static final String ENGAGED_NOTIFICATION_LIMIT = "engagedNotificationLimit";
            private static final String UPGRADE_TO = "upgradeTo";
            private static final String DOWNGRADE_TO = "downgradeTo";
            @SerializedName(value="groupName")
            @NonNull
            private String groupName = "";
            @SerializedName(value="minTriggerIntervalMs")
            private long minTriggerIntervalMs = 0L;
            @SerializedName(value="maxTriggerCountPerDay")
            private int maxTriggerCountPerDay = -1;
            @SerializedName(value="allowedTimeWindows")
            @NonNull
            @Size(min=0L)
            private List<AllowedTimeWindows> allowedIntervals = new ArrayList<AllowedTimeWindows>();
            @SerializedName(value="engagedNotificationLimit")
            private int engagedNotificationLimit = -1;
            @SerializedName(value="dismissedNotificationLimit")
            private int dismissedNotificationLimit = -1;
            @SerializedName(value="upgradeTo")
            private String upgradeTo = "";
            @SerializedName(value="downgradeTo")
            private String downgradeTo = "";
            public static final Parcelable.Creator<EngagementGroup> CREATOR = new Parcelable.Creator<EngagementGroup>(){

                public EngagementGroup createFromParcel(Parcel source) {
                    return new EngagementGroup(source);
                }

                public EngagementGroup[] newArray(int size) {
                    return new EngagementGroup[size];
                }
            };

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.groupName);
                dest.writeLong(this.minTriggerIntervalMs);
                dest.writeInt(this.maxTriggerCountPerDay);
                dest.writeTypedList(this.allowedIntervals);
                dest.writeInt(this.engagedNotificationLimit);
                dest.writeInt(this.dismissedNotificationLimit);
                dest.writeString(this.upgradeTo);
                dest.writeString(this.downgradeTo);
            }

            public EngagementGroup() {
            }

            protected EngagementGroup(Parcel in) {
                this.groupName = in.readString();
                this.minTriggerIntervalMs = in.readLong();
                this.maxTriggerCountPerDay = in.readInt();
                ArrayList allowedIntervalsFromCreator = in.createTypedArrayList(AllowedTimeWindows.CREATOR);
                this.allowedIntervals = allowedIntervalsFromCreator != null ? allowedIntervalsFromCreator : new ArrayList();
                this.engagedNotificationLimit = in.readInt();
                this.dismissedNotificationLimit = in.readInt();
                this.upgradeTo = in.readString();
                this.downgradeTo = in.readString();
            }

            @NonNull
            String getGroupName() {
                return this.groupName;
            }

            public int getEngagedNotificationLimit() {
                return this.engagedNotificationLimit;
            }

            public int getDismissedNotificationLimit() {
                return this.dismissedNotificationLimit;
            }

            long getMinTriggerIntervalMs() {
                return this.minTriggerIntervalMs;
            }

            int getMaxNotificationTriggerCountPerDay() {
                return this.maxTriggerCountPerDay;
            }

            public String getUpgradeTo() {
                return this.upgradeTo;
            }

            public String getDowngradeTo() {
                return this.downgradeTo;
            }

            @NonNull
            @Size(min=0L)
            List<AllowedTimeWindows> getAllowedIntervals() {
                return this.allowedIntervals;
            }

            public EngagementGroup setGroupName(@NonNull String groupName) {
                this.groupName = groupName;
                return this;
            }

            public EngagementGroup setMinTriggerIntervalMs(long minTriggerIntervalMs) {
                this.minTriggerIntervalMs = minTriggerIntervalMs;
                return this;
            }

            public EngagementGroup setMaxTriggerCountPerDay(int maxTriggerCountPerDay) {
                this.maxTriggerCountPerDay = maxTriggerCountPerDay;
                return this;
            }

            public EngagementGroup setAllowedIntervals(@NonNull List<AllowedTimeWindows> allowedIntervals) {
                this.allowedIntervals = allowedIntervals;
                return this;
            }

            public EngagementGroup setEngagedNotificationLimit(int engagedNotificationLimit) {
                this.engagedNotificationLimit = engagedNotificationLimit;
                return this;
            }

            public EngagementGroup setDismissedNotificationLimit(int dismissedNotificationLimit) {
                this.dismissedNotificationLimit = dismissedNotificationLimit;
                return this;
            }

            public EngagementGroup setUpgradeTo(String upgradeTo) {
                this.upgradeTo = upgradeTo;
                return this;
            }

            public EngagementGroup setDowngradeTo(String downgradeTo) {
                this.downgradeTo = downgradeTo;
                return this;
            }
        }
    }

    static class LayoutSpecificConfigs
    implements Parcelable {
        static final String LAYOUT_COLLAPSED_SINGLE_DEFAULT = "layout_collapsed_single_default";
        static final String LAYOUT_COLLAPSED_SINGLE_ITEM_V_1 = "layout_collapsed_single_item_v1";
        static final String LAYOUT_COLLAPSED_SINGLE_ITEM_V_2 = "layout_collapsed_single_item_v2";
        static final String LAYOUT_COLLAPSED_READ_MORE = "layout_collapsed_read_more";
        static final String LAYOUT_EXPANDED_READ_MORE = "layout_expanded_read_more";
        @SerializedName(value="layout_collapsed_single_default")
        private CollapsedSingleItemDefault collapsedSingleItemDefault = new CollapsedSingleItemDefault();
        @SerializedName(value="layout_collapsed_single_item_v1")
        private CollapsedSingleItemV1 collapsedSingleItemV1 = new CollapsedSingleItemV1();
        @SerializedName(value="layout_collapsed_single_item_v2")
        private CollapsedSingleItemV2 collapsedSingleItemV2 = new CollapsedSingleItemV2();
        @SerializedName(value="layout_collapsed_read_more")
        private CollapsedReadMore collapsedReadMore = new CollapsedReadMore();
        @SerializedName(value="layout_expanded_read_more")
        private ExpandedReadMore expandedReadMore = new ExpandedReadMore();
        public static final Parcelable.Creator<LayoutSpecificConfigs> CREATOR = new Parcelable.Creator<LayoutSpecificConfigs>(){

            public LayoutSpecificConfigs createFromParcel(Parcel source) {
                return new LayoutSpecificConfigs(source);
            }

            public LayoutSpecificConfigs[] newArray(int size) {
                return new LayoutSpecificConfigs[size];
            }
        };

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.collapsedSingleItemDefault, flags);
            dest.writeParcelable((Parcelable)this.collapsedSingleItemV1, flags);
            dest.writeParcelable((Parcelable)this.collapsedSingleItemV2, flags);
            dest.writeParcelable((Parcelable)this.collapsedReadMore, flags);
            dest.writeParcelable((Parcelable)this.expandedReadMore, flags);
        }

        public LayoutSpecificConfigs() {
        }

        protected LayoutSpecificConfigs(Parcel in) {
            this.collapsedSingleItemDefault = (CollapsedSingleItemDefault)in.readParcelable(CollapsedSingleItemDefault.class.getClassLoader());
            this.collapsedSingleItemV1 = (CollapsedSingleItemV1)in.readParcelable(CollapsedSingleItemV1.class.getClassLoader());
            this.collapsedSingleItemV2 = (CollapsedSingleItemV2)in.readParcelable(CollapsedSingleItemV2.class.getClassLoader());
            this.collapsedReadMore = (CollapsedReadMore)in.readParcelable(CollapsedReadMore.class.getClassLoader());
            this.expandedReadMore = (ExpandedReadMore)in.readParcelable(ExpandedReadMore.class.getClassLoader());
        }

        public CollapsedSingleItemDefault getCollapsedSingleItemDefault() {
            return this.collapsedSingleItemDefault;
        }

        public CollapsedSingleItemV1 getCollapsedSingleItemV1() {
            return this.collapsedSingleItemV1;
        }

        public CollapsedSingleItemV2 getCollapsedSingleItemV2() {
            return this.collapsedSingleItemV2;
        }

        public CollapsedReadMore getCollapsedReadMore() {
            return this.collapsedReadMore;
        }

        public ExpandedReadMore getExpandedReadMore() {
            return this.expandedReadMore;
        }

        static class ExpandedReadMore
        implements Parcelable {
            static final String ACTION_READ_MORE_TEXT_STRING_ID = "actionReadMoreTextStringId";
            @SerializedName(value="actionReadMoreTextStringId")
            private String actionReadMoreTextStringId;
            public static final Parcelable.Creator<ExpandedReadMore> CREATOR = new Parcelable.Creator<ExpandedReadMore>(){

                public ExpandedReadMore createFromParcel(Parcel source) {
                    return new ExpandedReadMore(source);
                }

                public ExpandedReadMore[] newArray(int size) {
                    return new ExpandedReadMore[size];
                }
            };

            public String getActionReadMoreTextStringId() {
                return this.actionReadMoreTextStringId;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.actionReadMoreTextStringId);
            }

            public ExpandedReadMore() {
            }

            protected ExpandedReadMore(Parcel in) {
                this.actionReadMoreTextStringId = in.readString();
            }
        }

        static class CollapsedReadMore
        implements Parcelable {
            static final String ACTION_READ_MORE_TEXT_STRING_ID = "actionReadMoreTextStringId";
            @SerializedName(value="actionReadMoreTextStringId")
            private String actionReadMoreTextStringId;
            public static final Parcelable.Creator<CollapsedReadMore> CREATOR = new Parcelable.Creator<CollapsedReadMore>(){

                public CollapsedReadMore createFromParcel(Parcel source) {
                    return new CollapsedReadMore(source);
                }

                public CollapsedReadMore[] newArray(int size) {
                    return new CollapsedReadMore[size];
                }
            };

            public String getActionReadMoreTextStringId() {
                return this.actionReadMoreTextStringId;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.actionReadMoreTextStringId);
            }

            public CollapsedReadMore() {
            }

            protected CollapsedReadMore(Parcel in) {
                this.actionReadMoreTextStringId = in.readString();
            }
        }

        static class CollapsedSingleItemV2
        implements Parcelable {
            private static final String SHOULD_ACTION_BUTTON_BE_TRANSPARENT = "shouldActionButtonBeTransparent";
            private static final String OPEN_BUTTON_TEXT_STRING_ID = "openButtonTextStringId";
            @SerializedName(value="shouldActionButtonBeTransparent")
            private boolean shouldActionButtonBeTransparent = false;
            @SerializedName(value="openButtonTextStringId")
            private String openButtonTextStringId;
            public static final Parcelable.Creator<CollapsedSingleItemV2> CREATOR = new Parcelable.Creator<CollapsedSingleItemV2>(){

                public CollapsedSingleItemV2 createFromParcel(Parcel source) {
                    return new CollapsedSingleItemV2(source);
                }

                public CollapsedSingleItemV2[] newArray(int size) {
                    return new CollapsedSingleItemV2[size];
                }
            };

            public boolean shouldActionButtonBeTransparent() {
                return this.shouldActionButtonBeTransparent;
            }

            public String getOpenButtonTextStringId() {
                return this.openButtonTextStringId;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeByte(this.shouldActionButtonBeTransparent ? (byte)1 : 0);
                dest.writeString(this.openButtonTextStringId);
            }

            public CollapsedSingleItemV2() {
            }

            protected CollapsedSingleItemV2(Parcel in) {
                this.shouldActionButtonBeTransparent = in.readByte() != 0;
                this.openButtonTextStringId = in.readString();
            }
        }

        static class CollapsedSingleItemV1
        implements Parcelable {
            private static final String ACTION_NEXT_ICON_URL = "actionNextIconUrl";
            private static final String ACTION_NEXT_TEXT_STRING_ID = "actionNextTextStringId";
            @SerializedName(value="actionNextTextStringId")
            private String actionNextTextStringId;
            @SerializedName(value="actionNextIconUrl")
            private String actionNextIconUrl = "https://s3-us-west-2.amazonaws.com/taboola-mobile-sdk/plus/res/change_icon.png";
            public static final Parcelable.Creator<CollapsedSingleItemV1> CREATOR = new Parcelable.Creator<CollapsedSingleItemV1>(){

                public CollapsedSingleItemV1 createFromParcel(Parcel source) {
                    return new CollapsedSingleItemV1(source);
                }

                public CollapsedSingleItemV1[] newArray(int size) {
                    return new CollapsedSingleItemV1[size];
                }
            };

            public String getActionNextTextStringId() {
                return this.actionNextTextStringId;
            }

            public String getActionNextIconUrl() {
                return this.actionNextIconUrl;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.actionNextTextStringId);
                dest.writeString(this.actionNextIconUrl);
            }

            public CollapsedSingleItemV1() {
            }

            protected CollapsedSingleItemV1(Parcel in) {
                this.actionNextTextStringId = in.readString();
                this.actionNextIconUrl = in.readString();
            }
        }

        static class CollapsedSingleItemDefault
        implements Parcelable {
            static final String SHOULD_IMAGE_PLACED_RIGHT = "shouldImagePlacedRight";
            @SerializedName(value="shouldImagePlacedRight")
            private boolean shouldImagePlacedRight = false;
            public static final Parcelable.Creator<CollapsedSingleItemDefault> CREATOR = new Parcelable.Creator<CollapsedSingleItemDefault>(){

                public CollapsedSingleItemDefault createFromParcel(Parcel source) {
                    return new CollapsedSingleItemDefault(source);
                }

                public CollapsedSingleItemDefault[] newArray(int size) {
                    return new CollapsedSingleItemDefault[size];
                }
            };

            public boolean shouldImagePlacedRight() {
                return this.shouldImagePlacedRight;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeByte(this.shouldImagePlacedRight ? (byte)1 : 0);
            }

            public CollapsedSingleItemDefault() {
            }

            protected CollapsedSingleItemDefault(Parcel in) {
                this.shouldImagePlacedRight = in.readByte() != 0;
            }
        }
    }

    static class ReadMoreConfig
    implements Parcelable {
        static final String SHOULD_SHOW_READ_MORE = "shouldShowReadMore";
        static final String PLACEMENT_NAME = "placementName";
        static final String PREFERRED_COLLAPSED_LAYOUT = "preferredReadMoreCollapsedLayout";
        static final String PREFERRED_EXPANDED_LAYOUT = "preferredReadMoreExpandedLayout";
        static final String LAYOUT_SPECIFIC_CONFIGS = "layoutSpecificConfigs";
        @SerializedName(value="shouldShowReadMore")
        private boolean shouldShowReadMore = false;
        @SerializedName(value="placementName")
        @NonNull
        private String placementName = "AC-notification-read-more-default";
        @SerializedName(value="preferredReadMoreCollapsedLayout")
        @NonNull
        private String preferredReadMoreCollapsedLayout = "layout_collapsed_read_more";
        @SerializedName(value="preferredReadMoreExpandedLayout")
        @NonNull
        private String preferredReadMoreExpandedLayout = "layout_expanded_read_more";
        @SerializedName(value="layoutSpecificConfigs")
        @NonNull
        public LayoutSpecificConfigs layoutSpecificConfigs = new LayoutSpecificConfigs();
        public static final Parcelable.Creator<ReadMoreConfig> CREATOR = new Parcelable.Creator<ReadMoreConfig>(){

            public ReadMoreConfig createFromParcel(Parcel source) {
                return new ReadMoreConfig(source);
            }

            public ReadMoreConfig[] newArray(int size) {
                return new ReadMoreConfig[size];
            }
        };

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeByte(this.shouldShowReadMore ? (byte)1 : 0);
            dest.writeString(this.placementName);
            dest.writeString(this.preferredReadMoreCollapsedLayout);
            dest.writeString(this.preferredReadMoreExpandedLayout);
            dest.writeParcelable((Parcelable)this.layoutSpecificConfigs, flags);
        }

        public ReadMoreConfig() {
        }

        protected ReadMoreConfig(Parcel in) {
            this.shouldShowReadMore = in.readByte() != 0;
            this.placementName = in.readString();
            this.preferredReadMoreCollapsedLayout = in.readString();
            this.preferredReadMoreExpandedLayout = in.readString();
            this.layoutSpecificConfigs = (LayoutSpecificConfigs)in.readParcelable(LayoutSpecificConfigs.class.getClassLoader());
        }

        public boolean shouldShowReadMore() {
            return this.shouldShowReadMore;
        }

        @NonNull
        public String getPlacementName() {
            return this.placementName;
        }

        @NonNull
        public String getPreferredCollapsedLayout() {
            return this.preferredReadMoreCollapsedLayout;
        }

        @NonNull
        public String getPreferredExpandedLayout() {
            return this.preferredReadMoreExpandedLayout;
        }

        @NonNull
        public LayoutSpecificConfigs getLayoutSpecificConfigs() {
            return this.layoutSpecificConfigs;
        }
    }

    static class LayoutConfig
    implements Parcelable {
        static final String PREFERRED_COLLAPSED_LAYOUT = "preferredCollapsedLayout";
        static final String PREFERRED_EXPANDED_LAYOUT = "preferredExpandedLayout";
        static final String SHOULD_HIDE_TIME = "shouldHideTime";
        static final String SHOULD_HIDE_DESCRIPTION = "shouldHideDescription";
        static final String LAYOUT_SPECIFIC_CONFIGS = "layoutSpecificConfigs";
        @SerializedName(value="preferredCollapsedLayout")
        private String preferredCollapsedLayout = "layout_collapsed_single_default";
        @SerializedName(value="preferredExpandedLayout")
        private String preferredExpandedLayout = "layout_expanded_single_default";
        @SerializedName(value="shouldHideTime")
        private boolean shouldHideTime = false;
        @SerializedName(value="shouldHideDescription")
        private boolean shouldHideDescription = false;
        @SerializedName(value="layoutSpecificConfigs")
        private LayoutSpecificConfigs layoutSpecificConfigs = new LayoutSpecificConfigs();
        public static final Parcelable.Creator<LayoutConfig> CREATOR = new Parcelable.Creator<LayoutConfig>(){

            public LayoutConfig createFromParcel(Parcel source) {
                return new LayoutConfig(source);
            }

            public LayoutConfig[] newArray(int size) {
                return new LayoutConfig[size];
            }
        };

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.preferredCollapsedLayout);
            dest.writeString(this.preferredExpandedLayout);
            dest.writeByte(this.shouldHideTime ? (byte)1 : 0);
            dest.writeByte(this.shouldHideDescription ? (byte)1 : 0);
            dest.writeParcelable((Parcelable)this.layoutSpecificConfigs, flags);
        }

        public LayoutConfig() {
        }

        protected LayoutConfig(Parcel in) {
            this.preferredCollapsedLayout = in.readString();
            this.preferredExpandedLayout = in.readString();
            this.shouldHideTime = in.readByte() != 0;
            this.shouldHideDescription = in.readByte() != 0;
            this.layoutSpecificConfigs = (LayoutSpecificConfigs)in.readParcelable(LayoutSpecificConfigs.class.getClassLoader());
        }

        @NonNull
        public String getPreferredCollapsedLayout() {
            return this.preferredCollapsedLayout;
        }

        @NonNull
        public String getPreferredExpandedLayout() {
            return this.preferredExpandedLayout;
        }

        public boolean shouldHideTime() {
            return this.shouldHideTime;
        }

        public boolean shouldHideDescription() {
            return this.shouldHideDescription;
        }

        public LayoutSpecificConfigs getLayoutSpecificConfigs() {
            return this.layoutSpecificConfigs;
        }
    }
}

