/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.taboola.android.SdkCore;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.monitor.TBPlusFeaturesParams;
import com.taboola.android.monitor.TBSdkFeature;
import com.taboola.android.plus.ConfigManager;
import com.taboola.android.plus.PublicApi;
import com.taboola.android.plus.SdkPlusConfig;
import com.taboola.android.plus.content.ContentConfig;
import com.taboola.android.plus.content.LanguagesConfig;
import com.taboola.android.plus.notification.BridgeInternalNotification;
import com.taboola.android.plus.notification.NotificationConfig;
import com.taboola.android.plus.notification.NotificationRemoteRepository;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.notification.TBNotificationManager;
import com.taboola.android.plus.notification.killSwitch.FrequentCrashBlockConfig;
import com.taboola.android.plus.notification.killSwitch.KillSwitchConfig;
import com.taboola.android.plus.notification.killSwitch.SdkPlusExceptionHandler;
import com.taboola.android.plus.push_notifications.BridgeInternalPushNotification;
import com.taboola.android.plus.push_notifications.OcambaInitCallback;
import com.taboola.android.plus.push_notifications.PushNotificationsAnalyticsManager;
import com.taboola.android.plus.push_notifications.PushNotificationsConfig;
import com.taboola.android.plus.push_notifications.PushNotificationsUtil;
import com.taboola.android.plus.push_notifications.TBPushNotificationsManager;
import com.taboola.android.plus.shared.ConditionCheckUtil;
import com.taboola.android.plus.shared.LocalizationStrings;
import com.taboola.android.plus.shared.MigrationManager;
import com.taboola.android.plus.shared.ResourcesUtil;
import com.taboola.android.plus.shared.SharedAnalyticsManager;
import com.taboola.android.plus.shared.SharedLocalStorage;
import com.taboola.android.plus.shared.TBNotificationExecutors;
import com.taboola.android.plus.shared.network.SdkPlusNetworkManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

@Keep
@RequiresApi(api=21)
public class TaboolaPlus
implements PublicApi.PublicTaboolaPlus {
    private static final String TAG = TaboolaPlus.class.getSimpleName();
    private static TaboolaPlus singleton = null;
    private static Context applicationContext;
    private static SdkCore sdkCore;
    private static SdkPlusNetworkManager sdkPlusNetworkManager;
    private static SparseArray<TBSdkFeature> sSdkFeatures;
    private SdkPlusExceptionHandler sdkPlusExceptionHandler;
    private boolean isInitialized = false;
    private TBNotificationManager notificationManager;
    private TBPushNotificationsManager pushNotificationsManager;
    private TBNotificationLocalStore notificationLocalStorage;
    private SharedLocalStorage sharedLocalStorage;
    private final Executor mainThreadExecutor = new TBNotificationExecutors.MainThreadExecutor();

    private TaboolaPlus() {
        this.notificationLocalStorage = new TBNotificationLocalStore(applicationContext);
        this.sharedLocalStorage = new SharedLocalStorage(applicationContext);
        this.verifySharedLocalStorage(applicationContext, this.sharedLocalStorage);
        SharedAnalyticsManager sharedAnalyticsManager = new SharedAnalyticsManager(applicationContext);
        TBNotificationAnalyticsManager analyticsManager = new TBNotificationAnalyticsManager(applicationContext, this.notificationLocalStorage, this.sharedLocalStorage, sharedAnalyticsManager);
        PushNotificationsAnalyticsManager pushNotificationsAnalyticsManager = new PushNotificationsAnalyticsManager(applicationContext, sharedAnalyticsManager);
        this.notificationManager = BridgeInternalNotification.newTBNotificationManager(applicationContext, new NotificationRemoteRepository(applicationContext), analyticsManager, this.notificationLocalStorage, this.sharedLocalStorage);
        this.pushNotificationsManager = BridgeInternalPushNotification.createPushNotificationsManager(applicationContext, pushNotificationsAnalyticsManager, this.sharedLocalStorage);
        Executors.newCachedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TaboolaPlus.this.initSdkPlusUncaughtExceptionHandler();
                }
                catch (Exception e) {
                    Logger.e((String)TAG, (String)"error while initSdkPlusUncaughtExceptionHandler", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TaboolaPlus getInstanceInternal() {
        if (singleton != null) return singleton;
        Class<TaboolaPlus> clazz = TaboolaPlus.class;
        synchronized (TaboolaPlus.class) {
            if (singleton != null) return singleton;
            singleton = new TaboolaPlus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    static void setApplicationContext(@NonNull Context applicationContext) {
        TaboolaPlus.applicationContext = applicationContext;
        if (applicationContext == null) {
            Log.e((String)TAG, (String)"setApplicationContext: context is null");
        } else {
            Log.d((String)TAG, (String)"setApplicationContext: context is not null");
        }
    }

    static void setSdkCore(SdkCore sdkCore) {
        TaboolaPlus.sdkCore = sdkCore;
    }

    static void setNetworkManager(SdkPlusNetworkManager networkManager) {
        sdkPlusNetworkManager = networkManager;
    }

    static SdkPlusNetworkManager getNetworkManager() {
        return sdkPlusNetworkManager;
    }

    static AdvertisingIdInfo getAdvertisingIdInfo() {
        return sdkCore.getAdvertisingIdInfo();
    }

    @Nullable
    static Context getApplicationContext() {
        return applicationContext;
    }

    @UiThread
    public static void init(@NonNull String publisherName, @NonNull String configId, @NonNull TaboolaPlusRetrievedCallback onSuccessfulCallback) {
        TaboolaPlus.init(publisherName, configId, onSuccessfulCallback, null);
    }

    @UiThread
    public static void init(@NonNull String publisherName, @NonNull String configId, @NonNull TaboolaPlusRetrievedCallback onSuccessfulCallback, @Nullable TaboolaPlusRetrieveFailedCallback onFailedCallback) {
        TaboolaPlus.init(publisherName, configId, null, onSuccessfulCallback, onFailedCallback);
    }

    @UiThread
    public static void init(@NonNull String publisherName, @NonNull String configId, @Nullable Map<String, String> taboolaPlusExtraProperties, @NonNull TaboolaPlusRetrievedCallback onSuccessfulCallback, @Nullable TaboolaPlusRetrieveFailedCallback onFailedCallback) {
        if (applicationContext != null) {
            TaboolaPlus taboolaPlus = TaboolaPlus.getInstanceInternal();
            SharedLocalStorage sharedLocalStorage = taboolaPlus.sharedLocalStorage;
            if (MigrationManager.isMigrationRequired(applicationContext)) {
                MigrationManager.migrate(applicationContext);
            }
            if (Build.VERSION.SDK_INT < 21) {
                Log.i((String)TAG, (String)"isInitialized: Android version is less than LOLLIPOP. Ignoring call.");
                onSuccessfulCallback.onTaboolaPlusRetrieved(taboolaPlus);
                return;
            }
            if (TaboolaPlus.shouldInitFromMonitor()) {
                Pair<String, String> pair = TaboolaPlus.getInitParamsFromMonitor(publisherName, configId);
                publisherName = (String)pair.first;
                configId = (String)pair.second;
                Pair<String, String> urls = TaboolaPlus.getConfigUrlsFromMonitor();
                if (urls == null || TextUtils.isEmpty((CharSequence)((CharSequence)urls.first)) || TextUtils.isEmpty((CharSequence)((CharSequence)urls.second))) {
                    Logger.d((String)TAG, (String)"no urls to override from monitor");
                } else {
                    TaboolaPlus.getNetworkManager().getConfigHandler().enableMonitorMode();
                }
            }
            TaboolaPlus.setDefaultSettings(sharedLocalStorage);
            sharedLocalStorage.setPublisher(publisherName);
            sharedLocalStorage.setConfigId(configId);
            sharedLocalStorage.setTaboolaPlusExtraProperties(taboolaPlusExtraProperties);
            TaboolaPlus.applyNewConfigs(publisherName, configId, taboolaPlusExtraProperties, onSuccessfulCallback, onFailedCallback, taboolaPlus);
            ConfigManager.triggerAsyncConfigsUpdate(applicationContext, publisherName, configId);
        } else {
            Logger.e((String)TAG, (String)"init TaboolaPlus failed, application context is null");
        }
    }

    private static void setDefaultSettings(@NonNull SharedLocalStorage sharedLocalStorage) {
        sharedLocalStorage.setWifiOnlyModeRuntimeFlag(false);
        sharedLocalStorage.setEnabled(false);
        sharedLocalStorage.setApplicationName("");
        sharedLocalStorage.setTaboolaPlusExtraProperties(null);
    }

    @WorkerThread
    private void initSdkPlusUncaughtExceptionHandler() {
        FrequentCrashBlockConfig frequentCrashBlockConfig;
        if (Build.VERSION.SDK_INT < 21) {
            Log.v((String)TAG, (String)"initSdkPlusUncaughtExceptionHandler: Android version is less than LOLLIPOP. Ignoring call.");
            return;
        }
        ConfigManager.CachedSdkConfigContainer cachedSdkConfig = ConfigManager.getCurrentSdkConfig(applicationContext);
        NotificationConfig notificationConfig = ConfigManager.CachedSdkConfigContainer.getNotificationConfig(cachedSdkConfig);
        if (notificationConfig == null) {
            Log.v((String)TAG, (String)"initSdkPlusUncaughtExceptionHandler: current sdkPlus config is empty, open crash report by default");
            frequentCrashBlockConfig = new FrequentCrashBlockConfig();
        } else {
            KillSwitchConfig killSwitchConfig = notificationConfig.getKillSwitchConfig();
            frequentCrashBlockConfig = killSwitchConfig.getFrequentCrashBlockConfig();
        }
        if (frequentCrashBlockConfig.isFrequentCrashBlockEnabled() && this.sdkPlusExceptionHandler == null) {
            this.sdkPlusExceptionHandler = new SdkPlusExceptionHandler(applicationContext, frequentCrashBlockConfig);
            this.mainThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    sdkCore.registerTaboolaExceptionHandler(TaboolaPlus.this.sdkPlusExceptionHandler);
                }
            });
        }
    }

    @Override
    public TBNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public TBPushNotificationsManager getPushNotificationsManager() {
        return this.pushNotificationsManager;
    }

    @UiThread
    static void reInit(final @NonNull TaboolaPlusRetrievedCallback onSuccessfulCallback, final @Nullable TaboolaPlusRetrieveFailedCallback onFailedCallback) {
        if (applicationContext != null) {
            final TaboolaPlus taboolaPlus = TaboolaPlus.getInstanceInternal();
            final String publisherName = taboolaPlus.sharedLocalStorage.getPublisher();
            final String configId = taboolaPlus.sharedLocalStorage.getConfigId();
            final HashMap<String, String> extraProperties = taboolaPlus.sharedLocalStorage.getTaboolaPlusExtraProperties();
            if (!TextUtils.isEmpty((CharSequence)publisherName) && !TextUtils.isEmpty((CharSequence)configId)) {
                new TBNotificationExecutors.MainThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        TaboolaPlus.applyNewConfigs(publisherName, configId, extraProperties, onSuccessfulCallback, onFailedCallback, taboolaPlus);
                    }
                });
            }
            ConfigManager.triggerAsyncConfigsUpdate(applicationContext, publisherName, configId);
        } else {
            Logger.e((String)TAG, (String)"reInit TaboolaPlus failed, application context is null");
        }
    }

    @UiThread
    private static void applyNewConfigs(final @NonNull String publisherName, @NonNull String configId, final @Nullable Map<String, String> taboolaPlusExtraProperties, final @NonNull TaboolaPlusRetrievedCallback onSuccessfulCallback, final @Nullable TaboolaPlusRetrieveFailedCallback onFailedCallback, final @NonNull TaboolaPlus taboolaPlus) {
        ConfigManager.getNewConfigs(applicationContext, publisherName, configId, true, new ConfigManager.OnGetAllConfigsCallback(){

            @Override
            public void onConfigsFetched(final SdkPlusConfig config, final LanguagesConfig languagesConfig) {
                SharedAnalyticsManager sharedAnalyticsManager = new SharedAnalyticsManager(applicationContext);
                sharedAnalyticsManager.sendNotificationConfigRefreshedEvent();
                new TBNotificationExecutors.MainThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        taboolaPlus.applyConfigs(config, languagesConfig, taboolaPlusExtraProperties, publisherName, onSuccessfulCallback);
                    }
                });
            }

            @Override
            public void onConfigsFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("applyNewConfigs: failed to get configs: " + throwable.getMessage()));
                if (onFailedCallback != null) {
                    onFailedCallback.onTaboolaPlusRetrieveFailed(throwable);
                }
            }
        });
    }

    @UiThread
    static void restore(final @NonNull TaboolaPlusRetrievedCallback successfulCallback, final @Nullable TaboolaPlusRetrieveFailedCallback failedCallback) {
        if (applicationContext != null) {
            final TaboolaPlus taboolaPlus = TaboolaPlus.getInstanceInternal();
            if (taboolaPlus.isInitialized() && TaboolaApi.getInstance().isInitialized()) {
                Log.i((String)TAG, (String)"restore: successful (already initialized)");
                successfulCallback.onTaboolaPlusRetrieved(taboolaPlus);
            } else {
                final String publisherName = taboolaPlus.sharedLocalStorage.getPublisher();
                String configId = taboolaPlus.sharedLocalStorage.getConfigId();
                final HashMap<String, String> extraProperties = taboolaPlus.sharedLocalStorage.getTaboolaPlusExtraProperties();
                ConfigManager.getCurrentConfigs(applicationContext, publisherName, configId, new ConfigManager.OnGetAllConfigsCallback(){

                    @Override
                    public void onConfigsFetched(final SdkPlusConfig config, final LanguagesConfig languagesConfig) {
                        new TBNotificationExecutors.MainThreadExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                taboolaPlus.applyConfigs(config, languagesConfig, extraProperties, publisherName, successfulCallback);
                            }
                        });
                    }

                    @Override
                    public void onConfigsFailed(Throwable throwable) {
                        Log.e((String)TAG, (String)("restore: failed to get configs: " + throwable.getMessage()));
                        if (failedCallback != null) {
                            failedCallback.onTaboolaPlusRetrieveFailed(throwable);
                        }
                    }
                });
            }
        } else {
            Logger.e((String)TAG, (String)"restore TaboolaPlus failed, application context is null");
        }
    }

    @UiThread
    private void applyConfigs(@NonNull SdkPlusConfig sdkPlusConfig, @NonNull LanguagesConfig languagesConfig, @Nullable Map<String, String> taboolaPlusExtraProperties, @NonNull String nonLocalizedPublisherName, final @NonNull TaboolaPlusRetrievedCallback successfulCallback) {
        NotificationConfig notificationConfig = sdkPlusConfig.getNotificationConfig();
        ContentConfig contentConfig = sdkPlusConfig.getContentConfig();
        PushNotificationsConfig pushNotificationsConfig = sdkPlusConfig.getPushNotificationsConfig();
        this.sharedLocalStorage.setNonClickableUrlMarker(notificationConfig.getNonClickableUrlMarker());
        String configVariant = notificationConfig.getConfigVariant();
        if (!TextUtils.isEmpty((CharSequence)configVariant)) {
            this.sharedLocalStorage.setConfigVariant(configVariant);
        }
        TaboolaPlus.initTaboolaApi(applicationContext, contentConfig, languagesConfig, taboolaPlusExtraProperties);
        String isoLanguage = Locale.getDefault().getLanguage().toUpperCase();
        String isoCountry = TBDeviceInfoUtil.getSimCountry(applicationContext);
        LocalizationStrings localizationStrings = ConditionCheckUtil.getLocalizeStrings(sdkPlusConfig.getLocalizationStrings(), isoCountry, isoLanguage);
        BridgeInternalNotification.applyConfig(this.notificationManager, notificationConfig, contentConfig, localizationStrings);
        BridgeInternalPushNotification.applyConfig(this.pushNotificationsManager, pushNotificationsConfig, localizationStrings);
        if (PushNotificationsUtil.shouldUsePushNotificationsFeature(pushNotificationsConfig)) {
            String localizedPublisherName = ConfigManager.getLocalizedPublisherName(applicationContext, languagesConfig);
            BridgeInternalPushNotification.initPushNotifications(this.pushNotificationsManager, nonLocalizedPublisherName, localizedPublisherName, configVariant, new OcambaInitCallback(){

                @Override
                public void onFailure() {
                    Logger.e((String)TAG, (String)"Fail to init push flow");
                    TaboolaPlus.this.isInitialized = true;
                    successfulCallback.onTaboolaPlusRetrieved(TaboolaPlus.this);
                }

                @Override
                public void onSuccess() {
                    TaboolaPlus.this.isInitialized = true;
                    successfulCallback.onTaboolaPlusRetrieved(TaboolaPlus.this);
                }
            });
        } else {
            this.isInitialized = true;
            successfulCallback.onTaboolaPlusRetrieved(this);
        }
    }

    @UiThread
    static void initTaboolaApi(Context appContext, @NonNull ContentConfig contentConfig, @NonNull LanguagesConfig languagesConfig, @Nullable Map<String, String> taboolaPlusExtraProperties) {
        HashMap<String, String> taboolaApiExtraProperties;
        String localizedPublisherName = ConfigManager.getLocalizedPublisherName(appContext, languagesConfig);
        String apiKey = contentConfig.getTaboolaApiConfig().getApiKey();
        HashMap<String, String> mergedExtraProperties = new HashMap<String, String>();
        if (taboolaPlusExtraProperties != null) {
            mergedExtraProperties.putAll(taboolaPlusExtraProperties);
        }
        if ((taboolaApiExtraProperties = contentConfig.getTaboolaApiConfig().getTaboolaApiExtraProperties()) != null) {
            mergedExtraProperties.putAll(taboolaApiExtraProperties);
        }
        mergedExtraProperties.put("enableFullRawDataResponse", "true");
        TaboolaApi.getInstance().init(appContext, localizedPublisherName, apiKey, mergedExtraProperties);
    }

    private static boolean shouldInitFromMonitor() {
        return applicationContext != null && MonitorUtils.isSdkMonitorInstalled((Context)applicationContext) && !TaboolaPlus.isMissingSdkFeatures();
    }

    static void setSdkFeatures(SparseArray<TBSdkFeature> sdkFeatures) {
        sSdkFeatures = sdkFeatures;
    }

    static SparseArray<TBSdkFeature> getSdkFeatures() {
        return sSdkFeatures;
    }

    private static boolean isMissingSdkFeatures() {
        return sSdkFeatures == null || sSdkFeatures.size() == 0;
    }

    @Nullable
    private static <T extends TBSdkFeature> T getFeature(Integer key) {
        if (TaboolaPlus.isMissingSdkFeatures()) {
            return null;
        }
        TBSdkFeature sdkFeature = (TBSdkFeature)sSdkFeatures.get(key.intValue());
        return (T)sdkFeature;
    }

    private static Pair<String, String> getInitParamsFromMonitor(@NonNull String publisherName, @NonNull String configId) {
        TBPlusFeaturesParams paramsChange = (TBPlusFeaturesParams)((Object)TaboolaPlus.getFeature(8));
        if (paramsChange != null && paramsChange.getInitParams() != null) {
            TBPlusFeaturesParams.InitParams params = paramsChange.getInitParams();
            String newPubId = params.getPublisherName();
            String newConfigId = params.getConfigID();
            if (!TextUtils.isEmpty((CharSequence)newPubId)) {
                publisherName = newPubId;
            }
            if (!TextUtils.isEmpty((CharSequence)newConfigId)) {
                configId = newConfigId;
            }
        }
        return new Pair((Object)publisherName, (Object)configId);
    }

    @Nullable
    static Pair<String, String> getConfigUrlsFromMonitor() {
        TBPlusFeaturesParams paramsChange = (TBPlusFeaturesParams)((Object)TaboolaPlus.getFeature(8));
        if (paramsChange != null) {
            return new Pair((Object)paramsChange.getConfigUrl(), (Object)paramsChange.getLangUrl());
        }
        return null;
    }

    private void verifySharedLocalStorage(@NonNull Context appContext, @NonNull SharedLocalStorage sharedLocalStorage) {
        if (!ResourcesUtil.isResourceValid(appContext, sharedLocalStorage.getNotificationIcon())) {
            sharedLocalStorage.removeNotificationIcon();
        }
    }

    private boolean isInitialized() {
        return this.isInitialized;
    }

    public static interface TaboolaPlusRetrieveFailedCallback {
        public void onTaboolaPlusRetrieveFailed(Throwable var1);
    }

    public static interface TaboolaPlusRetrievedCallback {
        public void onTaboolaPlusRetrieved(TaboolaPlus var1);
    }
}

