/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.util;

import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.ocamba.hoood.util.OcambaLogUtils;
import com.ocamba.hoood.util.OcambaUtils;

public class OcambaBadger {
    public static final String TAG = OcambaBadger.class.getSimpleName();
    private static final String ADW = "org.adw.launcher";
    private static final String ADW_FREAK = "org.adwfreak.launcher";
    private static final String APEX = "com.anddoes.launcher";
    private static final String ASUS = "com.asus.launcher";
    private static final String EVERYTHING_ME = "me.everything.launcher";
    private static final String HUAWEI = "com.huawei.android.launcher";
    private static final String LG = "com.lge.launcher";
    private static final String LG2 = "com.lge.launcher2";
    private static final String HTC = "com.htc.launcher";
    private static final String NOVA = "com.teslacoilsw.launcher";
    private static final String OPPO = "com.oppo.launcher";
    private static final String SAMSUNG_LAUNCHER = "com.sec.android.app.launcher";
    private static final String SAMSUNG_TWLAUNCHER = "com.sec.android.app.twlauncher";
    private static final String SONY_ERICSSON = "com.sonyericsson.home";
    private static final String SONY_MOBILE = "com.sonymobile.home";
    private static final String VIVO = "com.vivo.launcher";
    private static final String XIAOMI1 = "com.miui.miuilite";
    private static final String XIAOMI2 = "com.miui.home";
    private static final String XIAOMI3 = "com.miui.miuihome";
    private static final String XIAOMI4 = "com.miui.miuihome2";
    private static final String XIAOMI5 = "com.miui.mihome";
    private static final String XIAOMI6 = "com.miui.mihome2";
    private static final String XIAOMI7 = "com.i.miui.launcher";
    private static final String ZUK = "com.zui.launcher";

    public static void setBadge(Context context, int count) {
        OcambaLogUtils.d(TAG, "OcambaBadger setBadge()");
        if (context == null) {
            return;
        }
        String resolverInfo = OcambaUtils.getResolverInfo(context);
        if (resolverInfo == null) {
            return;
        }
        try {
            switch (resolverInfo) {
                case "org.adw.launcher": 
                case "org.adwfreak.launcher": {
                    OcambaBadger.setBadgeAdw(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "com.anddoes.launcher": {
                    OcambaBadger.setBadgeApex(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "com.asus.launcher": {
                    OcambaBadger.setBadgeAsus(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "me.everything.launcher": {
                    OcambaBadger.setBadgeEverything(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "com.huawei.android.launcher": {
                    OcambaBadger.setBadgeHuawei(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "com.lge.launcher": {
                    OcambaBadger.setBadgeLg(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "com.lge.launcher2": {
                    OcambaBadger.setBadgeLg(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "com.htc.launcher": {
                    OcambaBadger.setBadgeHtc(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "com.teslacoilsw.launcher": {
                    OcambaBadger.setBadgeNova(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "com.oppo.launcher": {
                    OcambaBadger.setBadgeOppo(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "com.sec.android.app.launcher": 
                case "com.sec.android.app.twlauncher": {
                    OcambaBadger.setBadgeSamsung(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "com.sonyericsson.home": 
                case "com.sonymobile.home": {
                    OcambaBadger.setBadgeSony(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "com.vivo.launcher": {
                    OcambaBadger.setBadgeVivo(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "com.zui.launcher": {
                    OcambaBadger.setBadgeZuk(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                case "com.miui.miuilite": 
                case "com.miui.home": 
                case "com.miui.miuihome": 
                case "com.miui.miuihome2": 
                case "com.miui.mihome": 
                case "com.miui.mihome2": 
                case "com.i.miui.launcher": {
                    OcambaBadger.setBadgeXiaomi(context, OcambaUtils.getComponent(context), count);
                    break;
                }
                default: {
                    OcambaBadger.setBadgeDefault(context, OcambaUtils.getComponent(context), count);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setBadgeDefault(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        Intent intent = new Intent("android.intent.action.BADGE_COUNT_UPDATE");
        intent.putExtra("badge_count", count);
        intent.putExtra("badge_count_package_name", componentName.getPackageName());
        intent.putExtra("badge_count_class_name", componentName.getClassName());
        context.sendBroadcast(intent);
    }

    private static void setBadgeXiaomi(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        Intent localIntent = new Intent("android.intent.action.APPLICATION_MESSAGE_UPDATE");
        localIntent.putExtra("android.intent.extra.update_application_component_name", componentName.getPackageName() + "/" + componentName.getClassName());
        localIntent.putExtra("android.intent.extra.update_application_message_text", String.valueOf(count == 0 ? "" : Integer.valueOf(count)));
        context.sendBroadcast(localIntent);
    }

    private static void setBadgeAdw(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        Intent intent = new Intent("org.adw.launcher.counter.SEND");
        intent.putExtra("PNAME", componentName.getPackageName());
        intent.putExtra("CNAME", componentName.getClassName());
        intent.putExtra("COUNT", count);
        context.sendBroadcast(intent);
    }

    private static void setBadgeApex(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        Intent intent = new Intent("com.anddoes.launcher.COUNTER_CHANGED");
        intent.putExtra("package", componentName.getPackageName());
        intent.putExtra("count", count);
        intent.putExtra("class", componentName.getClassName());
        context.sendBroadcast(intent);
    }

    private static void setBadgeAsus(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        Intent intent = new Intent("android.intent.action.BADGE_COUNT_UPDATE");
        intent.putExtra("badge_count", count);
        intent.putExtra("badge_count_package_name", componentName.getPackageName());
        intent.putExtra("badge_count_class_name", componentName.getClassName());
        intent.putExtra("badge_vip_count", 0);
        context.sendBroadcast(intent);
    }

    private static void setBadgeEverything(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("package_name", componentName.getPackageName());
        contentValues.put("activity_name", componentName.getClassName());
        contentValues.put("count", Integer.valueOf(count));
        context.getContentResolver().insert(Uri.parse((String)"content://me.everything.badger/apps"), contentValues);
    }

    private static void setBadgeHuawei(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        Bundle localBundle = new Bundle();
        localBundle.putString("package", context.getPackageName());
        localBundle.putString("class", componentName.getClassName());
        localBundle.putInt("badgenumber", count);
        context.getContentResolver().call(Uri.parse((String)"content://com.huawei.android.launcher.settings/badge/"), "change_badge", null, localBundle);
    }

    private static void setBadgeLg(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        Intent intent = new Intent("android.intent.action.BADGE_COUNT_UPDATE");
        intent.putExtra("badge_count", count);
        intent.putExtra("badge_count_package_name", componentName.getPackageName());
        intent.putExtra("badge_count_class_name", componentName.getClassName());
        context.sendBroadcast(intent);
    }

    private static void setBadgeHtc(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        Intent intent1 = new Intent("com.htc.launcher.action.SET_NOTIFICATION");
        intent1.putExtra("com.htc.launcher.extra.COMPONENT", componentName.flattenToShortString());
        intent1.putExtra("com.htc.launcher.extra.COUNT", count);
        Intent intent = new Intent("com.htc.launcher.action.UPDATE_SHORTCUT");
        intent.putExtra("packagename", componentName.getPackageName());
        intent.putExtra("count", count);
        context.sendBroadcast(intent1);
        context.sendBroadcast(intent);
    }

    private static void setBadgeNova(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("tag", componentName.getPackageName() + "/" + componentName.getClassName());
        contentValues.put("count", Integer.valueOf(count));
        context.getContentResolver().insert(Uri.parse((String)"content://com.teslacoilsw.notifier/unread_count"), contentValues);
    }

    private static void setBadgeOppo(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        Intent intent = new Intent("com.oppo.unsettledevent");
        intent.putExtra("pakeageName", componentName.getPackageName());
        intent.putExtra("number", count);
        intent.putExtra("upgradeNumber", count);
        context.sendBroadcast(intent);
    }

    private static void setBadgeSamsung(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        Intent intent = new Intent("android.intent.action.BADGE_COUNT_UPDATE");
        intent.putExtra("badge_count", count);
        intent.putExtra("badge_count_package_name", componentName.getPackageName());
        intent.putExtra("badge_count_class_name", componentName.getClassName());
        context.sendBroadcast(intent);
    }

    private static void setBadgeSony(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        Intent intent = new Intent();
        intent.setAction("com.sonyericsson.home.action.UPDATE_BADGE");
        intent.putExtra("com.sonyericsson.home.intent.extra.badge.ACTIVITY_NAME", componentName.getClassName());
        intent.putExtra("com.sonyericsson.home.intent.extra.badge.SHOW_MESSAGE", true);
        intent.putExtra("com.sonyericsson.home.intent.extra.badge.MESSAGE", String.valueOf(count));
        intent.putExtra("com.sonyericsson.home.intent.extra.badge.PACKAGE_NAME", componentName.getPackageName());
        context.sendBroadcast(intent);
    }

    private static void setBadgeVivo(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        Intent intent = new Intent("launcher.action.CHANGE_APPLICATION_NOTIFICATION_NUM");
        intent.putExtra("packageName", context.getPackageName());
        intent.putExtra("className", componentName.getClassName());
        intent.putExtra("notificationNum", count);
        context.sendBroadcast(intent);
    }

    private static void setBadgeZuk(Context context, ComponentName componentName, int count) {
        if (componentName == null) {
            return;
        }
        Bundle extra = new Bundle();
        extra.putInt("app_badge_count", count);
        context.getContentResolver().call(Uri.parse((String)"content://com.android.badge/badge"), "setAppBadgeCount", null, extra);
    }
}

