/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.beacon;

import android.content.SharedPreferences;
import com.ocamba.hoood.OcambaPrefManager;
import com.ocamba.hoood.beacon.OcambaBeacon;
import java.util.Set;

class OcambaBeaconPrefManager
extends OcambaPrefManager {
    private static final String KEY_PREFIX_BEACON = "ocamba_beacon";
    private static final String KEY_BEACON_ID = "unique_id";
    private static final String KEY_NAMESPACE = "namespace_id";
    private static final String KEY_INSTANCE_ID = "instance_id";
    private static final String KEY_DISTANCE = "distance";
    private static final String KEY_TIME = "time";
    private static final String ACTIVE_BEACONS = "active";

    OcambaBeaconPrefManager() {
    }

    static void setBeaconsIds(Set<String> set) {
        OcambaBeaconPrefManager.setGeofenceOrBeaconIds(KEY_BEACON_ID, set);
    }

    private static void removeBeaconId(String value) {
        OcambaBeaconPrefManager.removeGeofenceOrBeaconId(KEY_BEACON_ID, value);
    }

    static Set<String> getBeaconId() {
        return OcambaBeaconPrefManager.getGeofenceOrBeaconId(KEY_BEACON_ID);
    }

    static void setBeacon(OcambaBeacon beacon) {
        SharedPreferences shared = OcambaBeaconPrefManager.getSharedPreferences();
        if (shared != null) {
            try {
                SharedPreferences.Editor prefsEditor = shared.edit();
                String id2 = beacon.getUniqueId();
                prefsEditor.putString(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_NAMESPACE), beacon.getNamespaceId());
                prefsEditor.putString(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_INSTANCE_ID), beacon.getInstanceId());
                prefsEditor.putLong(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_DISTANCE), beacon.getDistance());
                prefsEditor.apply();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static OcambaBeacon getBeacon(String id2) {
        SharedPreferences shared = OcambaBeaconPrefManager.getSharedPreferences();
        if (shared != null) {
            try {
                return new OcambaBeacon(id2, shared.getString(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_NAMESPACE), ""), shared.getString(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_INSTANCE_ID), ""), shared.getLong(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_DISTANCE), 0L));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    static void clearBeacon(String id2) {
        SharedPreferences shared = OcambaBeaconPrefManager.getSharedPreferences();
        if (shared != null) {
            try {
                SharedPreferences.Editor prefsEditor = shared.edit();
                prefsEditor.remove(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_NAMESPACE));
                prefsEditor.remove(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_INSTANCE_ID));
                prefsEditor.remove(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_DISTANCE));
                prefsEditor.apply();
                OcambaBeaconPrefManager.removeBeaconId(id2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static void setBeaconSentTime(String beaconId, long time) {
        SharedPreferences shared = OcambaBeaconPrefManager.getSharedPreferences();
        if (shared != null) {
            try {
                SharedPreferences.Editor editor = shared.edit();
                editor.putLong(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, beaconId, KEY_TIME), time);
                editor.apply();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static long getBeaconSentTime(String beaconId) {
        SharedPreferences shared = OcambaBeaconPrefManager.getSharedPreferences();
        if (shared != null) {
            try {
                return shared.getLong(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, beaconId, KEY_TIME), 0L);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0L;
            }
        }
        return 0L;
    }

    static void setActive(boolean active) {
        SharedPreferences shared = OcambaBeaconPrefManager.getSharedPreferences();
        if (shared != null) {
            try {
                SharedPreferences.Editor editor = shared.edit();
                editor.putBoolean(ACTIVE_BEACONS, active);
                editor.apply();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static boolean getActive() {
        SharedPreferences shared = OcambaBeaconPrefManager.getSharedPreferences();
        if (shared != null) {
            try {
                return shared.getBoolean(ACTIVE_BEACONS, false);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }
}

