/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Messenger;
import android.support.annotation.Keep;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import com.squareup.picasso.Picasso;
import com.taboola.android.MonitorManager;
import com.taboola.android.Taboola;
import com.taboola.android.TaboolaInterfaceComponent;
import com.taboola.android.api.PublicApi;
import com.taboola.android.api.SdkApiMonitorHandler;
import com.taboola.android.api.TBImageErrorListener;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBPublisherApi;
import com.taboola.android.api.TBRecommendationRequestCallback;
import com.taboola.android.api.TBRecommendationsRequest;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.api.TestHelperInternal;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.monitor.TBNetworkMonitoring;
import com.taboola.android.monitor.TBSdkFeature;
import com.taboola.android.monitor.TBSimCodeChange;
import com.taboola.android.monitor.TBSuspendMonitor;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import com.taboola.android.utils.SdkDetailsHelper;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Keep
public class TaboolaApi
implements PublicApi.PublicTaboolaApi,
TaboolaInterfaceComponent {
    public static final String TAG = "TaboolaApi";
    private Map<String, TBPublisherApi> mTBPublisherApiMap = new HashMap<String, TBPublisherApi>();
    private TBPublisherApi mDefaultTBPublisherApi;
    private TBImageErrorListener mTBImageErrorListener;
    private Picasso mPicasso;
    private Boolean mIsSdkMonitorInstalled;
    private MonitorManager mSdkMonitorManager = null;
    private Context mApplicationContext;
    private Handler mHandler;
    private SparseArray<TBSdkFeature> mSdkFeatures;
    private Messenger mMonitorMessenger;
    private NetworkManager mNetworkManager = Taboola.getTaboolaImpl().getNetworkManager();
    private ConfigManager mConfigManager = Taboola.getTaboolaImpl().loadAndGetConfigManager();
    private AdvertisingIdInfo mAdvertisingIdInfo = Taboola.getTaboolaImpl().getAdvertisingIdInfo();
    private TaboolaEventsListener mEventsListener;

    private TaboolaApi() {
        this.mDefaultTBPublisherApi = new TBPublisherApi(this.mNetworkManager, this.mConfigManager, this.mAdvertisingIdInfo);
    }

    public static TaboolaApi getInstance() {
        return LazyHolder.INSTANCE;
    }

    public static TBPublisherApi getInstance(String publisherId) {
        TaboolaApi taboolaApi = TaboolaApi.getInstance();
        TBPublisherApi tbPublisherApi = taboolaApi.mTBPublisherApiMap.get(publisherId);
        if (tbPublisherApi == null) {
            tbPublisherApi = new TBPublisherApi(taboolaApi.mNetworkManager, taboolaApi.mConfigManager, publisherId, taboolaApi.mAdvertisingIdInfo);
            taboolaApi.addTBPublisherApiToMap(publisherId, tbPublisherApi);
        }
        return tbPublisherApi;
    }

    private void addTBPublisherApiToMap(String publisherId, TBPublisherApi tbPublisherApi) {
        Map<String, TBPublisherApi> publisherApiMapping = TaboolaApi.getInstance().mTBPublisherApiMap;
        publisherApiMapping.put(publisherId, tbPublisherApi);
    }

    @MainThread
    public TaboolaApi createTBPublisherApiAndInit(@NonNull Context applicationContext, @NonNull String publisherId, @NonNull String apiKey, @Nullable Map<String, String> extraProperties) {
        this.mDefaultTBPublisherApi = new TBPublisherApi(this.mNetworkManager, this.mConfigManager, publisherId, this.mAdvertisingIdInfo);
        this.mDefaultTBPublisherApi.init(applicationContext, apiKey, extraProperties);
        this.mTBPublisherApiMap.put(publisherId, this.mDefaultTBPublisherApi);
        return this;
    }

    @MainThread
    public TaboolaApi init(@NonNull Context applicationContext, @NonNull String publisherId, @NonNull String apiKey, @Nullable Map<String, String> extraProperties) {
        this.mConfigManager.setConfigDataFromRemoteWithPublisher(publisherId);
        this.updateApplicationContext(applicationContext);
        TBPublisherApi tbPublisherApi = this.mTBPublisherApiMap.get(publisherId);
        if (tbPublisherApi != null && tbPublisherApi.isInitialized()) {
            tbPublisherApi.updateCurrentPublisher(extraProperties);
        } else {
            this.createTBPublisherApiAndInit(applicationContext, publisherId, apiKey, extraProperties);
        }
        return this;
    }

    @Override
    @MainThread
    public TaboolaApi init(@NonNull Context applicationContext, @NonNull String publisherId, @NonNull String apiKey) {
        return this.init(applicationContext, publisherId, apiKey, null);
    }

    public boolean isInitialized() {
        return this.mApplicationContext != null && this.mDefaultTBPublisherApi != null && this.mDefaultTBPublisherApi.isInitialized();
    }

    void initSdkMonitor(Context applicationContext) {
        if (this.mIsSdkMonitorInstalled == null) {
            this.mIsSdkMonitorInstalled = MonitorUtils.isSdkMonitorInstalled(applicationContext);
            if (this.mIsSdkMonitorInstalled.booleanValue()) {
                this.mSdkMonitorManager = MonitorManager.getInstance(SdkDetailsHelper.getApplicationName(applicationContext));
                this.mSdkMonitorManager.bindService(applicationContext);
                Logger.setSdkMonitorManager(this.mSdkMonitorManager);
                if (this.mHandler == null) {
                    this.mHandler = new Handler(Looper.getMainLooper());
                }
                if (this.mMonitorMessenger == null) {
                    this.mMonitorMessenger = new Messenger((Handler)new SdkApiMonitorHandler());
                }
            }
        }
        if (this.mIsSdkMonitorInstalled.booleanValue()) {
            String sdkDetailsJSON = SdkDetailsHelper.createSdkJsonString(applicationContext, null, "Taboola Android SDK - API");
            this.mSdkMonitorManager.sendGetFeatureSet(this.mMonitorMessenger, sdkDetailsJSON);
        }
    }

    @Override
    public void fetchRecommendations(TBRecommendationsRequest request, TBRecommendationRequestCallback callback) {
        this.mDefaultTBPublisherApi.fetchRecommendations(request, callback);
    }

    @Override
    public void getNextBatchForPlacement(TBPlacement placement, TBRecommendationRequestCallback callback) {
        this.mDefaultTBPublisherApi.getNextBatchForPlacement(placement, callback);
    }

    @Override
    public void getNextBatchForPlacement(TBPlacement placement, int count, TBRecommendationRequestCallback callback) {
        this.mDefaultTBPublisherApi.getNextBatchForPlacement(placement, count, callback);
    }

    @Override
    public void handleAttributionClick(@Nullable Context context) {
        this.mDefaultTBPublisherApi.handleAttributionClick(context);
    }

    @Override
    public TaboolaApi setOnClickListener(TaboolaOnClickListener onClickListener) {
        this.mDefaultTBPublisherApi.setOnClickListener(onClickListener);
        return this;
    }

    @Override
    public TaboolaApi setOnClickIgnoreTimeMs(int onClickIgnoreTimeMs) {
        this.mDefaultTBPublisherApi.setOnClickIgnoreTimeMs(onClickIgnoreTimeMs);
        return this;
    }

    @Override
    public TaboolaApi setLogLevel(int logLevel) {
        this.mDefaultTBPublisherApi.setLogLevel(logLevel);
        return this;
    }

    @Override
    public TaboolaApi setImagePlaceholder(Drawable placeholderDrawable) {
        this.mDefaultTBPublisherApi.setImagePlaceholder(placeholderDrawable);
        return this;
    }

    void setSdkEventsTestListener(TestHelperInternal.SdkEventsTestListener sdkEventsTestListener) {
        this.mDefaultTBPublisherApi.setSdkEventsTestListener(sdkEventsTestListener);
    }

    public TBPublisherApi setExtraProperties(Map<String, String> extraProperties) {
        return this.mDefaultTBPublisherApi.setExtraProperties(extraProperties);
    }

    public void clear() {
        Logger.d(TAG, "clear() called");
        if (IntegrationVerifier.isEnabled()) {
            IntegrationVerifier integrationVerifier = Taboola.getTaboolaImpl().getIntegrationVerifier();
            integrationVerifier.getTestsManager().getMethodCallOrderTracker().clearTrackedMethods(3);
            integrationVerifier.clearStatusReport();
        }
        this.mTBImageErrorListener = null;
        this.mEventsListener = null;
        for (TBPublisherApi tbPublisherApi : this.mTBPublisherApiMap.values()) {
            if (tbPublisherApi == null) continue;
            tbPublisherApi.clear();
        }
        this.mTBPublisherApiMap.clear();
        this.mDefaultTBPublisherApi = null;
        if (this.mIsSdkMonitorInstalled != null && this.mIsSdkMonitorInstalled.booleanValue() && this.mSdkMonitorManager != null) {
            this.mIsSdkMonitorInstalled = null;
            this.mSdkMonitorManager.unbindService(this.mApplicationContext);
            Logger.setSdkMonitorManager(null);
            this.mSdkMonitorManager = null;
            this.mMonitorMessenger = null;
            if (this.mSdkFeatures != null) {
                this.mSdkFeatures.clear();
            }
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        this.mApplicationContext = null;
    }

    public void setImageErrorListener(TBImageErrorListener tbImageErrorListener) {
        this.mTBImageErrorListener = tbImageErrorListener;
    }

    @Nullable
    TBImageErrorListener getImageErrorListener() {
        return this.mTBImageErrorListener;
    }

    Picasso getPicasso() {
        return this.mPicasso;
    }

    void createPicasso(Context appCtx) {
        if (this.mPicasso == null) {
            try {
                Picasso.Builder builder = new Picasso.Builder(appCtx);
                builder.listener(new Picasso.Listener(){

                    public void onImageLoadFailed(Picasso picasso, Uri uri, Exception e) {
                        Logger.e(TaboolaApi.TAG, "Fail to load image url: " + uri.toString(), e);
                        if (TaboolaApi.this.mTBImageErrorListener != null) {
                            TaboolaApi.this.mTBImageErrorListener.onImageLoadFailed(uri, e);
                        }
                    }
                });
                this.mPicasso = builder.build();
            }
            catch (Exception e) {
                Logger.e(TAG, e.getMessage(), e);
            }
        }
    }

    Context getApplicationContext() {
        return this.mApplicationContext;
    }

    void updateApplicationContext(Context applicationContext) {
        if (this.mApplicationContext == null) {
            this.mApplicationContext = applicationContext.getApplicationContext();
        }
    }

    Boolean isSdkMonitorEnabled() {
        return this.mIsSdkMonitorInstalled != null && this.mIsSdkMonitorInstalled != false && !this.isSdkMonitorSuspended();
    }

    MonitorManager getSdkMonitorManager() {
        return this.mSdkMonitorManager;
    }

    void setSdkFeatures(SparseArray<TBSdkFeature> sdkFeatures) {
        this.mSdkFeatures = sdkFeatures;
        SdkDetailsHelper.verifyIfNeededToChangeSimCode((TBSimCodeChange)this.getFeature(5));
        if (this.isSdkMonitorEnabled().booleanValue()) {
            Logger.setSdkMonitorLevelActive();
        }
    }

    boolean isSdkMonitorSuspended() {
        TBSuspendMonitor suspendMonitor = (TBSuspendMonitor)this.getFeature(2);
        return suspendMonitor != null && suspendMonitor.isShouldSuspend();
    }

    boolean isShouldMonitorNetwork() {
        TBNetworkMonitoring networkMonitoring = (TBNetworkMonitoring)this.getFeature(4);
        return networkMonitoring == null || networkMonitoring.isShouldMonitor();
    }

    private boolean isMissingSdkFeatures() {
        return this.mSdkFeatures == null || this.mSdkFeatures.size() == 0;
    }

    @Nullable
    <T extends TBSdkFeature> T getFeature(Integer key) {
        if (this.isMissingSdkFeatures()) {
            return null;
        }
        TBSdkFeature sdkFeature = (TBSdkFeature)this.mSdkFeatures.get(key.intValue());
        return (T)sdkFeature;
    }

    void sendUrlToMonitor(long timestamp, String url) {
        this.mSdkMonitorManager.sendNetworkCall(timestamp, url);
    }

    void sendUrlToMonitor(String url) {
        try {
            String urlAfterDecode = URLDecoder.decode(url, "UTF-8");
            this.sendUrlToMonitor(new Date().getTime(), urlAfterDecode);
        }
        catch (Exception e) {
            Logger.e(TAG, e.getMessage());
        }
    }

    public void setTaboolaEventsListener(TaboolaEventsListener eventsListener) {
        this.mEventsListener = eventsListener;
    }

    @Nullable
    TaboolaEventsListener getTaboolaEventsListener() {
        return this.mEventsListener;
    }

    public void reportEventToListener(int actionType, String data) {
        TaboolaEventsListener taboolaEventsListener = TaboolaApi.getInstance().getTaboolaEventsListener();
        if (taboolaEventsListener != null) {
            taboolaEventsListener.onEvent(actionType, data);
        }
    }

    public static abstract class TaboolaEventsListener {
        public abstract void onEvent(int var1, String var2);
    }

    private static class LazyHolder {
        static final TaboolaApi INSTANCE = new TaboolaApi();

        private LazyHolder() {
        }
    }
}

