/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.lightnetwork.url_components;

import android.net.Uri;
import android.util.Log;
import com.taboola.lightnetwork.url_components.UrlParameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UrlParameters {
    private static final String TAG = UrlParameters.class.getSimpleName();
    private static final String KEY_VALUE_PAIR = "%s=%s";
    protected Set<UrlParameter> mParameters = new HashSet<UrlParameter>();

    public UrlParameters addParameters(UrlParameter ... parameters) {
        for (UrlParameter urlParameter : parameters) {
            this.validateAndAddParameter(urlParameter);
        }
        return this;
    }

    @Deprecated
    public UrlParameters addParameters(HashMap<String, String> parameters) {
        Iterator<Map.Entry<String, String>> iterator = parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> pair = iterator.next();
            this.validateAndAddParameter(new UrlParameter(pair.getKey(), pair.getValue()));
            iterator.remove();
        }
        return this;
    }

    private void validateAndAddParameter(UrlParameter urlParameter) {
        if (urlParameter.isValid()) {
            this.mParameters.add(urlParameter);
        } else {
            Log.e((String)TAG, (String)"UrlParameters | addParameters() | Tried to add invalid parameter.");
        }
    }

    public String toString() {
        return this.getString(true);
    }

    public String getString(boolean utf8Encoded) {
        StringBuilder urlStringBuilder = new StringBuilder();
        boolean first = true;
        for (UrlParameter parameter : this.mParameters) {
            if (first) {
                first = false;
            } else {
                urlStringBuilder.append("&");
            }
            String key = utf8Encoded ? Uri.encode((String)parameter.mKey) : parameter.mKey;
            String value = utf8Encoded ? Uri.encode((String)parameter.mValue) : parameter.mValue;
            urlStringBuilder.append(String.format(KEY_VALUE_PAIR, key, value));
        }
        return urlStringBuilder.toString();
    }

    public boolean isEmpty() {
        return this.mParameters == null || this.mParameters.isEmpty();
    }
}

