/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.lightnetwork.protocols.http;

import android.text.TextUtils;
import com.taboola.lightnetwork.protocols.http.CookiesTracker;
import com.taboola.lightnetwork.protocols.http.HeadersManager;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpRequest;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

class HttpPost
extends HttpRequest {
    private String mBodyAsString;

    public HttpPost(HeadersManager headersManager, CookiesTracker cookiesTracker, int configuredTimeout) {
        super(configuredTimeout, headersManager, cookiesTracker);
    }

    void post(String url, JSONArray jsonArray, Map<String, String> requestHeaders, String trackHeadersKey, String trackHeadersByGroup, HttpManager.NetworkResponse networkResponse) {
        if (jsonArray != null && jsonArray.length() > 0) {
            this.mBodyAsString = jsonArray.toString();
        }
        this.post(url, this.mBodyAsString, requestHeaders, trackHeadersKey, trackHeadersByGroup, networkResponse);
    }

    void post(String url, JSONObject jsonBody, Map<String, String> requestHeaders, String trackHeadersKey, String trackHeadersByGroup, HttpManager.NetworkResponse networkResponse) {
        if (jsonBody != null && jsonBody.length() > 0) {
            this.mBodyAsString = jsonBody.toString();
        }
        this.post(url, this.mBodyAsString, requestHeaders, trackHeadersKey, trackHeadersByGroup, networkResponse);
    }

    void post(String url, String body, Map<String, String> requestHeaders, String trackHeadersKey, String trackHeadersByGroup, HttpManager.NetworkResponse networkResponse) {
        this.mUrl = url;
        if (!TextUtils.isEmpty((CharSequence)body)) {
            this.mBodyAsString = body;
        }
        this.mRequestHeaders = requestHeaders;
        this.mTrackHeadersByGroup = trackHeadersByGroup;
        this.mTrackHeadersKey = trackHeadersKey;
        this.performRequsetOnBackgroundThread(networkResponse);
    }

    @Override
    void protocolSpecificConnectionSetup(HttpURLConnection httpUrlConnection) throws IOException {
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setDoInput(true);
        httpUrlConnection.setDoOutput(true);
        this.addPostBody(httpUrlConnection);
    }

    private void addPostBody(HttpURLConnection httpUrlConnection) throws IOException {
        if (!TextUtils.isEmpty((CharSequence)this.mBodyAsString)) {
            DataOutputStream writer = new DataOutputStream(httpUrlConnection.getOutputStream());
            writer.writeBytes(this.mBodyAsString);
            writer.flush();
            writer.close();
        }
    }
}

