/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.utility.IntegrationTypeNameParser;

public class SensiblePlacementNumberVerificationTest
extends VerificationTest {
    private static final String WARNING_MESSAGE = "SensiblePlacementNumberVerificationTest | Please use at least %s placement requests and no more than %s.";
    private static final String TEST_NAME = "SensiblePlacementNumberVerification";
    public static final String KEY_NUMBER_OF_SET_PLACEMENTS = "sensiblePlacementNumber_numberOfSetPlacements";
    private static final int MIN_PLACEMENT_SIZE = 1;
    private static final int MAX_PLACEMENT_SIZE = 12;

    public SensiblePlacementNumberVerificationTest(int id, boolean isMandatory) {
        super(id, isMandatory);
    }

    @Override
    public void execute(@Nullable Context context, @Nullable Bundle bundle, @NonNull VerificationTest.TestResults testResults) {
        int numOfPlacementsSet = bundle.getInt(KEY_NUMBER_OF_SET_PLACEMENTS);
        if (numOfPlacementsSet >= 1 && numOfPlacementsSet <= 12) {
            testResults.onSuccess();
        } else {
            testResults.onFail(this.isMandatory());
        }
    }

    @Override
    public VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle bundle) {
        VerificationOutputTargets verificationOutputTargets = new VerificationOutputTargets(new VerificationOutputTarget[0]);
        Bundle consoleBundle = new Bundle();
        consoleBundle.putString("consoleOutput_key_log_error_string", String.format(WARNING_MESSAGE, 1, 12));
        verificationOutputTargets.add(new VerificationOutputTarget(2, consoleBundle));
        verificationOutputTargets.add(new VerificationOutputTarget(3, this.getKibanaBundle(IntegrationTypeNameParser.getNameFor(bundle.getInt("integration_verifier_key_integrationType")), TEST_NAME, WARNING_MESSAGE)));
        return verificationOutputTargets;
    }
}

