/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.handlers;

import android.os.AsyncTask;
import android.support.annotation.Keep;
import com.taboola.android.PublisherInfo;
import com.taboola.android.global_components.eventsmanager.events.TaboolaMobileEvent;
import com.taboola.android.utils.Logger;
import com.taboola.lightnetwork.dynamic_url.DynamicRequest;
import com.taboola.lightnetwork.dynamic_url.NetworkExecutable;
import com.taboola.lightnetwork.dynamic_url.annotations.GET;
import com.taboola.lightnetwork.dynamic_url.annotations.Path;
import com.taboola.lightnetwork.dynamic_url.annotations.Query;
import com.taboola.lightnetwork.dynamic_url.annotations.QueryMap;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import java.util.HashMap;
import java.util.concurrent.RejectedExecutionException;

@Keep
public class EventsManagerHandler {
    private static final String TAG = EventsManagerHandler.class.getSimpleName();
    private static final String BASE_URL = "https://api.taboola.com/1.2/json";
    private static final String MOBILE_EVENT_GET_SESSION_URL = "/{publisherId}/session.get";
    private static final String MOBILE_EVENT_REPORT_MOBILE_EVENT_URL = "/{publisherId}/recommendations.notify-clientMobile";
    private HttpManager mHttpManager;
    private MobileEventReportAPI mMobileEventReportAPI;

    public void setHttpManager(HttpManager httpManager) {
        this.mHttpManager = httpManager;
        this.mMobileEventReportAPI = new NetworkExecutable(this.mHttpManager, BASE_URL).create(MobileEventReportAPI.class);
    }

    public void getSessionInfo(PublisherInfo publisherInfo, HttpManager.NetworkResponse networkResponse) {
        this.mMobileEventReportAPI.getMobileEventSession(publisherInfo.getPublisherId(), publisherInfo.getApiKey()).execute(networkResponse);
    }

    public void reportMobileEvent(final HttpManager.NetworkResponse networkResponse, final TaboolaMobileEvent event) {
        try {
            AsyncTask.SERIAL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    HashMap<String, String> queryParams = new HashMap<String, String>();
                    queryParams.put("response.session", event.getSessionId());
                    queryParams.put("response.id", event.getResponseId());
                    queryParams.put("app.type", event.getAppType());
                    queryParams.put("app.apikey", event.getApiKey());
                    queryParams.put("event.data", event.getDataAsString());
                    Logger.d(TAG, "SERIAL_EXECUTOR | mMobileEventReportAPI.reportMobileEvent called");
                    DynamicRequest reportMobileEvent = EventsManagerHandler.this.mMobileEventReportAPI.reportMobileEvent(event.getPublisherId(), queryParams);
                    String requestUrl = reportMobileEvent.getFinalUrl();
                    Logger.d(TAG, "reportMobileEvent | " + requestUrl);
                    reportMobileEvent.execute(networkResponse);
                }
            });
        }
        catch (RejectedExecutionException ree) {
            Logger.e(TAG, ree.getLocalizedMessage());
        }
        catch (NullPointerException npe) {
            Logger.e(TAG, npe.getLocalizedMessage());
        }
    }

    static interface MobileEventReportAPI {
        @GET(value="/{publisherId}/session.get")
        public DynamicRequest getMobileEventSession(@Path(value="publisherId") String var1, @Query(value="app.apikey") String var2);

        @GET(value="/{publisherId}/recommendations.notify-clientMobile")
        public DynamicRequest reportMobileEvent(@Path(value="publisherId") String var1, @QueryMap HashMap<String, String> var2);
    }
}

