/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils.advertising_id;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.utils.advertising_id.AdvertisingIdClient;

public class AdvertisingIdManager {
    @Nullable
    public static String sAdvertisingId = null;

    @Nullable
    public static String getAdvertisingIdFromMemory() {
        return sAdvertisingId;
    }

    public static void getAdvertisingId(final AdvertisingIdRetrievedCallback callback, @NonNull Context applicationContext) {
        if (sAdvertisingId == null) {
            String cachedId = AdvertisingIdClient.getCachedAdvertisingId(applicationContext);
            if (cachedId != null) {
                sAdvertisingId = cachedId;
                callback.onAdIdRetrieved(sAdvertisingId);
            } else {
                AdvertisingIdClient.updateAdvertisingIdAsync(applicationContext, new AdvertisingIdClient.AdvertisingIdCallback(){

                    @Override
                    public void onIdRetrieved(String advertisingId) {
                        sAdvertisingId = advertisingId;
                        callback.onAdIdRetrieved(sAdvertisingId);
                    }

                    @Override
                    public void onIdUnavailable() {
                        sAdvertisingId = "";
                        callback.onAdIdRetrieved(sAdvertisingId);
                    }
                });
            }
        } else if (sAdvertisingId.isEmpty()) {
            callback.onAdIdRetrieved(sAdvertisingId);
        } else {
            callback.onAdIdRetrieved(sAdvertisingId);
        }
    }

    public static interface AdvertisingIdRetrievedCallback {
        public void onAdIdRetrieved(String var1);
    }
}

