/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.Pair;
import com.taboola.android.utils.Logger;

public class SharedPrefUtil {
    private static final String TAG = SharedPrefUtil.class.getSimpleName();
    private static final String SHARED_PREFS_KEY = "com.taboola.android.SHARED_PREFERENCES_KEY";
    private static final String ADVERTISING_ID_SHARED_PREFS_KEY = "com.taboola.android.ADVERTISING_ID_SHARED_PREFERENCES_KEY";
    private static final String LIMITED_AD_TRACKING_SHARED_PREFS_KEY = "com.taboola.android.LIMITED_TRACKING_SHARED_PREFERENCES_KEY";
    private static final String MAX_WIDGET_SIZE_SHARED_PREFS_KEY = "com.taboola.android.MAX_WIDGET_SIZE_SHARED_PREFS_KEY";
    private static final String API_SESSION_SHARED_PREFS_KEY = "com.taboola.android.API_SESSION_SHARED_PREFS_KEY";
    private static final String API_SESSION_TIMESTAMP_SHARED_PREFS_KEY = "com.taboola.android.API_SESSION_TIMESTAMP_SHARED_PREFS_KEY";
    private static final String ISO_CODE = "com.taboola.android.ISO_CODE";
    private static final String SDK_CONFIG = "com.taboola.android.CONFIGURATION_SHARED_PREFS_KEY";
    private static final String SDK_CONFIG_PUBLISHER_ID = "com.taboola.android.CONFIGURATION_PUBLISHER_SHARED_PREFS_KEY";
    private static final String SPREFS_KEY_EVENT_QUEUE_PERSISTANCE = "com.taboola.android.event_queue_persistance";
    private static final String SDK_CONFIG_UNIQUE_ID = "com.taboola.android.CONFIGURATION_UNIQUE_ID";
    private static final String LAST_CRASH_MSG = TAG + ".last_crash_detected_msg";
    private static final String LAST_CRASH_TRACE = TAG + ".last_crash_detected_trace";
    private static final long SESSION_EXPIRATION_PERIOD_MS = 3600000L;

    public static void saveEventsQueue(Context context, String eventQueueString) {
        SharedPrefUtil.putString(context, SPREFS_KEY_EVENT_QUEUE_PERSISTANCE, eventQueueString);
    }

    public static String loadEventsQueue(Context context) {
        return SharedPrefUtil.getString(context, SPREFS_KEY_EVENT_QUEUE_PERSISTANCE, null);
    }

    public static String getCachedAdvertisingId(Context context) {
        String id2 = SharedPrefUtil.getString(context, ADVERTISING_ID_SHARED_PREFS_KEY, null);
        Logger.d(TAG, "getCachedAdvertisingId :: id = " + id2);
        return id2;
    }

    public static void setCachedAdvertisingId(Context context, String idValue) {
        SharedPrefUtil.putString(context, ADVERTISING_ID_SHARED_PREFS_KEY, idValue);
    }

    public static int getCachedMaxWidgetSize(Context context) {
        int size = SharedPrefUtil.getInt(context, MAX_WIDGET_SIZE_SHARED_PREFS_KEY, 0);
        Logger.d(TAG, "getCachedMaxWidgetSize :: Size = " + size);
        return size;
    }

    public static void setCachedMaxWidgetSize(Context context, int size) {
        SharedPrefUtil.putInt(context, MAX_WIDGET_SIZE_SHARED_PREFS_KEY, size);
    }

    @Nullable
    public static String getUserSession(Context context, String publisherId) {
        boolean isExpired;
        String session = SharedPrefUtil.getString(context, API_SESSION_SHARED_PREFS_KEY + SharedPrefUtil.getPublisherSuffixKey(publisherId), "init");
        long sessionAcquisitionTimestamp = SharedPrefUtil.getUserSessionTimestamp(context, publisherId);
        boolean bl = isExpired = System.currentTimeMillis() > sessionAcquisitionTimestamp + 3600000L;
        if (isExpired) {
            return "init";
        }
        return session;
    }

    public static void setUserSession(Context context, String session, String publisherId) {
        SharedPrefUtil.putString(context, API_SESSION_SHARED_PREFS_KEY + SharedPrefUtil.getPublisherSuffixKey(publisherId), session);
    }

    @Nullable
    public static long getUserSessionTimestamp(Context context, String publisherId) {
        return SharedPrefUtil.getLong(context, API_SESSION_TIMESTAMP_SHARED_PREFS_KEY + SharedPrefUtil.getPublisherSuffixKey(publisherId), 0L);
    }

    public static void setUserSessionTimestamp(Context context, long timestamp, String publisherId) {
        SharedPrefUtil.putLong(context, API_SESSION_TIMESTAMP_SHARED_PREFS_KEY + SharedPrefUtil.getPublisherSuffixKey(publisherId), timestamp);
    }

    static String getPublisherSuffixKey(String publisherId) {
        return "_" + publisherId;
    }

    static void saveSimCodeToSharedPreferences(@NonNull Context context, String isoCode) {
        SharedPrefUtil.putString(context, ISO_CODE, isoCode);
    }

    static String getCachedSimCode(@NonNull Context context) {
        return SharedPrefUtil.getString(context, ISO_CODE, "undefined");
    }

    public static void saveConfig(Context context, String config) {
        SharedPrefUtil.putString(context, SDK_CONFIG, config);
    }

    public static String getConfig(Context context) {
        return SharedPrefUtil.getString(context, SDK_CONFIG, null);
    }

    public static void setConfigPublisherId(Context context, String publisherId) {
        SharedPrefUtil.putString(context, SDK_CONFIG_PUBLISHER_ID, publisherId);
    }

    public static String getConfigPublisherId(Context context) {
        return SharedPrefUtil.getString(context, SDK_CONFIG_PUBLISHER_ID, null);
    }

    public static void setLastCrashDetected(@NonNull Context context, String exceptionMessage, String exceptionStackTrace) {
        SharedPreferences sharedPreferences = SharedPrefUtil.getPreferences(context);
        sharedPreferences.edit().putString(LAST_CRASH_MSG, exceptionMessage).commit();
        sharedPreferences.edit().putString(LAST_CRASH_TRACE, exceptionStackTrace).commit();
    }

    public static Pair<String, String> getLastCrashDetected(@NonNull Context context) {
        SharedPreferences sharedPreferences = SharedPrefUtil.getPreferences(context);
        String exceptionMessage = sharedPreferences.getString(LAST_CRASH_MSG, "");
        String exceptionStackTrace = sharedPreferences.getString(LAST_CRASH_TRACE, "");
        return new Pair((Object)exceptionMessage, (Object)exceptionStackTrace);
    }

    public static String getConfigUniqueId(@NonNull Context context) {
        return SharedPrefUtil.getString(context, SDK_CONFIG_UNIQUE_ID, null);
    }

    public static void setConfigUniqueId(@NonNull Context context, String uniqueId) {
        SharedPrefUtil.putString(context, SDK_CONFIG_UNIQUE_ID, uniqueId);
    }

    private static SharedPreferences getPreferences(@NonNull Context context) {
        return context.getApplicationContext().getSharedPreferences(SHARED_PREFS_KEY, 0);
    }

    private static String getString(Context context, String key, String defValue) {
        if (context == null) {
            return defValue;
        }
        SharedPreferences preferences = SharedPrefUtil.getPreferences(context);
        return preferences.getString(key, defValue);
    }

    private static void putString(Context context, String key, String value) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = SharedPrefUtil.getPreferences(context);
        preferences.edit().putString(key, value).apply();
    }

    private static int getInt(Context context, String key, int defValue) {
        if (context == null) {
            return defValue;
        }
        SharedPreferences preferences = SharedPrefUtil.getPreferences(context);
        return preferences.getInt(key, defValue);
    }

    private static void putInt(Context context, String key, int value) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = SharedPrefUtil.getPreferences(context);
        preferences.edit().putInt(key, value).apply();
    }

    private static long getLong(Context context, String key, long defValue) {
        if (context == null) {
            return defValue;
        }
        SharedPreferences preferences = SharedPrefUtil.getPreferences(context);
        return preferences.getLong(key, defValue);
    }

    private static void putLong(Context context, String key, long value) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = SharedPrefUtil.getPreferences(context);
        preferences.edit().putLong(key, value).apply();
    }
}

