/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.taboola.android.utils.Logger;

public class MonitorUtils {
    private static final String TAG = MonitorUtils.class.getSimpleName();
    private static final String SDK_MONITOR_PACKAGE = "com.taboola.taboolasdkmonitor";
    private static final String MEASURE_SPEC_EXACTLY = "MeasureSpec.EXACTLY";
    private static final String MEASURE_SPEC_AT_MOST = "MeasureSpec.AT_MOST";
    private static final String MEASURE_SPEC_UNSPECIFIED = "MEASURE_SPEC_UNSPECIFIED";

    public static boolean isSdkMonitorInstalled(Context context) {
        if (context == null) {
            Logger.e(TAG, "Monitor cannot work with null context");
            return false;
        }
        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo(SDK_MONITOR_PACKAGE, 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return true;
    }

    public static String sizeToString(int size) {
        if (size == -2) {
            return "wrap_content";
        }
        if (size == -1) {
            return "match_parent";
        }
        return String.valueOf(size);
    }

    public static String measureSpecToString(int mode) {
        if (mode == 0x40000000) {
            return MEASURE_SPEC_EXACTLY;
        }
        if (mode == Integer.MIN_VALUE) {
            return MEASURE_SPEC_AT_MOST;
        }
        if (mode == 0) {
            return MEASURE_SPEC_UNSPECIFIED;
        }
        return String.valueOf(mode);
    }

    public static int stringToSize(@NonNull String size) {
        int retVal = 0;
        if (!TextUtils.isEmpty((CharSequence)size)) {
            String lower = size.toLowerCase();
            retVal = TextUtils.equals((CharSequence)"wrap_content", (CharSequence)lower) ? -2 : (TextUtils.equals((CharSequence)"match_parent", (CharSequence)lower) ? -1 : Integer.valueOf(size));
        }
        return retVal;
    }
}

