/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.js;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.WebView;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.monitor.MonitorHelper;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.js.TaboolaWeb;
import com.taboola.android.listeners.TaboolaWebListener;
import com.taboola.android.utils.Logger;
import java.util.Map;

@Keep
public class TaboolaWebBuilder {
    private static final String TAG = TaboolaWebBuilder.class.getSimpleName();
    private IntegrationVerifier mIntegrationVerifier;
    private NetworkManager mNetworkManager;
    private ConfigManager mConfigManager;
    private MonitorHelper mMonitorHelper;
    private AdvertisingIdInfo mAdvertisingIdInfo;
    private boolean mIsCalledFromStdInit = false;
    private String mUserId;
    private String mTag;
    private Map<String, String> mPerWidgetExtraProperties;
    private Map<String, String> mPerPlacementExtraProperties;
    private String mPlacement;

    public TaboolaWebBuilder(IntegrationVerifier integrationVerifier, NetworkManager networkManager, ConfigManager configManager, AdvertisingIdInfo advertisingIdInfo, MonitorHelper monitorHelper, boolean isCalledFromStdInit) {
        this.mIntegrationVerifier = integrationVerifier;
        this.mNetworkManager = networkManager;
        this.mConfigManager = configManager;
        this.mMonitorHelper = monitorHelper;
        this.mAdvertisingIdInfo = advertisingIdInfo;
        this.mIsCalledFromStdInit = isCalledFromStdInit;
    }

    public TaboolaWebBuilder setUserId(String userId) {
        this.mUserId = userId;
        return this;
    }

    public TaboolaWebBuilder setExtraProperties(@NonNull Map<String, String> extraProperties) {
        this.mPerWidgetExtraProperties = extraProperties;
        return this;
    }

    public TaboolaWebBuilder setExtraProperties(@NonNull Map<String, String> extraProperties, String placement) {
        this.mPerPlacementExtraProperties = extraProperties;
        this.mPlacement = placement;
        return this;
    }

    public TaboolaWebBuilder setTag(String tag) {
        this.mTag = tag;
        return this;
    }

    public TaboolaWeb build(WebView webView, TaboolaWebListener taboolaWebListener) {
        if (taboolaWebListener == null) {
            Logger.e(TAG, "taboolaWebListener is null, did you forget");
        }
        TaboolaWeb taboolaWeb = new TaboolaWeb(webView, this.mIntegrationVerifier, this.mNetworkManager, this.mConfigManager, this.mAdvertisingIdInfo, this.mMonitorHelper, taboolaWebListener, this.mIsCalledFromStdInit);
        if (!TextUtils.isEmpty((CharSequence)this.mUserId)) {
            taboolaWeb.setUserId(this.mUserId);
        }
        if (this.mPerWidgetExtraProperties != null) {
            taboolaWeb.setExtraProperties((Map)this.mPerWidgetExtraProperties);
        }
        if (this.mPerPlacementExtraProperties != null) {
            taboolaWeb.setExtraProperties(this.mPerPlacementExtraProperties, this.mPlacement);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mTag)) {
            taboolaWeb.setTag(this.mTag);
        }
        return taboolaWeb;
    }
}

