/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.js;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.taboola.android.Taboola;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.monitor.MonitorHelper;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.js.MonitorWebViewClient;
import com.taboola.android.js.TaboolaWebParent;
import com.taboola.android.js.WebViewManager;
import com.taboola.android.js.WebViewManager3x;
import com.taboola.android.listeners.TaboolaUpdateContentListener;
import com.taboola.android.listeners.TaboolaWebListener;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import java.util.Map;

@Keep
public class TaboolaWeb
extends TaboolaWebParent {
    public static final String TAG = TaboolaWeb.class.getSimpleName();
    private WebViewManager mWebViewManager;
    private WebView mWebView;
    private Context mContext;
    private TaboolaWebListener mTaboolaWebListener;

    TaboolaWeb(WebView webView, IntegrationVerifier integrationVerifier, NetworkManager networkManager, ConfigManager configManager, AdvertisingIdInfo advertisingIdInfo, MonitorHelper monitorHelper, TaboolaWebListener taboolaWebListener, boolean isCalledFromStdInit) {
        this.mTaboolaWebListener = taboolaWebListener;
        if (webView == null || webView.getContext() == null) {
            Logger.e(TAG, "webView is either null or not attached. Cannot instantiate TaboolaWeb");
            return;
        }
        this.mContext = webView.getContext();
        this.mIntegrationVerifier = integrationVerifier;
        this.mNetworkManager = networkManager;
        this.mConfigManager = configManager;
        this.mAdvertisingIdInfo = advertisingIdInfo;
        this.mMonitorHelper = monitorHelper;
        this.mIsCalledFromStdInit = isCalledFromStdInit;
        if (MonitorUtils.isSdkMonitorInstalled(this.mContext)) {
            this.mMonitorHelper.start(this.mContext, null);
        }
        if (IntegrationVerifier.isEnabled()) {
            super.verifyOnConstruction(this.mContext, isCalledFromStdInit);
        }
        this.mWebView = webView;
        this.initializeFeatures();
        this.mWebViewManager = new WebViewManager3x(webView, networkManager, this.mOnClickHelper, this.mAdvertisingIdInfo, monitorHelper, taboolaWebListener);
        this.mWebViewManager.registerWebView();
        if (Taboola.getTaboolaImpl().isKillSwitchEnabled(null)) {
            if (this.mTaboolaWebListener != null && !this.mIsCalledFromStdInit) {
                this.mTaboolaWebListener.onRenderFailed("", "INTERNAL_1");
            }
            return;
        }
        this.setMonitorInWebView(webView);
        this.getPlacementFromWebView(this.mWebViewManager);
        if (IntegrationVerifier.isEnabled()) {
            this.getInitDataFromWebView();
        }
    }

    private void getInitDataFromWebView() {
        super.getInitDataFromWebView(this.mWebViewManager);
    }

    public void fetchContent() {
        super.fetchContent(this.mWebViewManager);
    }

    public void showProgressBar() {
        super.showProgressBar(this.mWebViewManager);
    }

    public void scrollToTop() {
        super.scrollToTop(this.mWebViewManager, this.mWebView);
    }

    public void notifyUpdateHeight() {
        super.notifyUpdateHeight(this.mWebViewManager, this.mWebView);
    }

    @Override
    public void clear() {
        super.clear();
        ((WebViewManager3x)this.mWebViewManager).clear();
        this.mTaboolaWebListener = null;
    }

    public TaboolaWeb setTag(String tag) {
        super.setTag(this.mWebViewManager, tag);
        return this;
    }

    public void updateContent(TaboolaUpdateContentListener onUpdateContentListener) {
        super.updateContent(this.mWebViewManager, onUpdateContentListener);
    }

    public WebViewManager getWebViewManager() {
        return this.mWebViewManager;
    }

    @Override
    public TaboolaWeb setExtraProperties(@NonNull Map<String, String> extraProperties) {
        super.setExtraProperties(extraProperties);
        return this;
    }

    public TaboolaWeb setExtraProperties(@NonNull Map<String, String> extraProperties, String placement) {
        super.setExtraProperties(this.mWebViewManager, extraProperties, placement);
        return this;
    }

    public TaboolaWeb setUserId(String userId) {
        super.setUserId(this.mWebViewManager, userId);
        return this;
    }

    public void setTaboolaWebListener(TaboolaWebListener taboolaWebListener) {
        this.mTaboolaWebListener = taboolaWebListener;
    }

    public void reportUserAction(int actionType, String dataJsonString) {
        this.mWebViewManager.reportUserAction(actionType, dataJsonString);
    }

    public void updatePassedAction(int actionType, String dataJsonString) {
        if (this.mWebViewManager != null) {
            this.mWebViewManager.updatePassedAction(actionType, dataJsonString);
        } else {
            Logger.e(TAG, "updateAction : webView not found!");
        }
    }

    private void setMonitorInWebView(WebView webView) {
        if (this.mMonitorHelper.isSdkMonitorEnabled().booleanValue()) {
            if (this.mMonitorHelper.isShouldMonitorNetwork()) {
                webView.setWebViewClient((WebViewClient)new MonitorWebViewClient(this.mMonitorHelper));
            }
            if (Build.VERSION.SDK_INT >= 19) {
                WebView.setWebContentsDebuggingEnabled((boolean)true);
                Logger.d(TAG, "WebView.setWebContentsDebuggingEnabled(true)");
            }
        }
    }
}

