/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.js;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.taboola.android.ITaboolaImpl;
import com.taboola.android.Taboola;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.js.MonitorWebViewClient;
import com.taboola.android.js.OnRenderListener;
import com.taboola.android.js.OnResizeListener;
import com.taboola.android.js.TaboolaWebParent;
import com.taboola.android.js.WebViewManager;
import com.taboola.android.js.WebViewManager2x;
import com.taboola.android.listeners.TaboolaUpdateContentListener;
import com.taboola.android.listeners.TaboolaUserActionListener;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import java.util.HashMap;
import java.util.Map;

@Keep
public class TaboolaJs
extends TaboolaWebParent {
    public static final String TAG = TaboolaJs.class.getSimpleName();
    private static final TaboolaJs ourInstance = new TaboolaJs();
    private TaboolaUserActionListener mTaboolaUserActionListener;
    private Map<WebView, WebViewManager> mWebViewManagers = new HashMap<WebView, WebViewManager>();

    private TaboolaJs() {
        ITaboolaImpl taboolaImpl = Taboola.getTaboolaImpl();
        this.mIntegrationVerifier = taboolaImpl.getIntegrationVerifier();
        this.mNetworkManager = taboolaImpl.getNetworkManager();
        this.mConfigManager = taboolaImpl.loadAndGetConfigManager();
        this.mMonitorHelper = taboolaImpl.getMonitorHelper();
        this.mAdvertisingIdInfo = taboolaImpl.getAdvertisingIdInfo();
    }

    public static TaboolaJs getInstance() {
        return ourInstance;
    }

    public TaboolaJs init(@NonNull Context ctx) {
        return this.init(ctx, false);
    }

    public TaboolaJs init(@NonNull Context ctx, boolean isCalledFromStdInit) {
        this.mIsCalledFromStdInit = isCalledFromStdInit;
        if (MonitorUtils.isSdkMonitorInstalled(ctx)) {
            this.mMonitorHelper.start(ctx, null);
        }
        if (IntegrationVerifier.isEnabled()) {
            super.verifyOnConstruction(ctx, isCalledFromStdInit);
        }
        return this;
    }

    public TaboolaJs registerWebView(@NonNull WebView webView) {
        this.registerWebView(webView, null);
        return this;
    }

    public TaboolaJs registerWebView(@NonNull WebView webView, @Nullable OnRenderListener onRenderListener) {
        if (Taboola.getTaboolaImpl().isKillSwitchEnabled(null)) {
            if (onRenderListener != null && !this.mIsCalledFromStdInit) {
                onRenderListener.onRenderFailed(webView, "", "INTERNAL_1");
            }
            return this;
        }
        if (IntegrationVerifier.isEnabled()) {
            this.mIntegrationVerifier.getTestsManager().getMethodCallOrderTracker().rememberNonInitApiMethodCall(2, "registerWebView");
        }
        if (webView == null || webView.getContext() == null) {
            Logger.e(TAG, "registerWebView, WebView is not attached ", new Exception());
            return this;
        }
        this.initializeFeatures();
        if (this.mWebViewManagers.containsKey(webView)) {
            Logger.e(TAG, "registerWebView: WebView is already registered");
        } else {
            WebViewManager2x webViewManager = new WebViewManager2x(webView, this.mNetworkManager, this.mOnClickHelper, this.mAdvertisingIdInfo, this.mMonitorHelper);
            webViewManager.setOnRenderListener(onRenderListener);
            this.mWebViewManagers.put(webView, webViewManager);
            webViewManager.registerWebView();
        }
        if (this.mMonitorHelper.isSdkMonitorEnabled().booleanValue()) {
            if (this.mMonitorHelper.isShouldMonitorNetwork()) {
                webView.setWebViewClient((WebViewClient)new MonitorWebViewClient(this.mMonitorHelper));
            }
            if (Build.VERSION.SDK_INT >= 19) {
                WebView.setWebContentsDebuggingEnabled((boolean)true);
                Logger.d(TAG, "WebView.setWebContentsDebuggingEnabled(true)");
            }
        }
        this.getPlacementFromWebView(webView);
        if (IntegrationVerifier.isEnabled()) {
            this.getInitDataFromWebView(webView);
        }
        return this;
    }

    private void getPlacementFromWebView(WebView webView) {
        super.getPlacementFromWebView(this.mWebViewManagers.get(webView));
    }

    private void getInitDataFromWebView(WebView webView) {
        super.getInitDataFromWebView(this.mWebViewManagers.get(webView));
    }

    public TaboolaJs unregisterWebView(@NonNull WebView webView) {
        if (IntegrationVerifier.isEnabled()) {
            this.mIntegrationVerifier.getTestsManager().getMethodCallOrderTracker().rememberNonInitApiMethodCall(2, "clear");
        }
        Logger.d(TAG, "clear() ");
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager == null) {
            Logger.e(TAG, "clear: WebView is not registered");
        } else {
            webViewManager.unregisterWebView();
            webViewManager.setOnRenderListener(null);
            this.mWebViewManagers.remove(webView);
        }
        return this;
    }

    public void fetchContent(@NonNull WebView webView) {
        if (webView == null || webView.getContext() == null) {
            Logger.e(TAG, "fetchContent, WebView is not attached ", new Exception());
            return;
        }
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        super.fetchContent(webViewManager);
    }

    public void showProgressBar(@NonNull WebView webView) {
        if (webView == null || webView.getContext() == null) {
            Logger.e(TAG, "showProgressBar, WebView is not attached ", new Exception());
            return;
        }
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        super.showProgressBar(webViewManager);
    }

    public void scrollToTop(@NonNull WebView webView) {
        if (webView == null || webView.getContext() == null) {
            Logger.e(TAG, "scrollToTop, WebView is not attached ", new Exception());
            return;
        }
        super.scrollToTop(this.mWebViewManagers.get(webView), webView);
    }

    public void notifyUpdateHeight(@NonNull WebView webView) {
        if (webView == null || webView.getContext() == null) {
            Logger.e(TAG, "notifyUpdateHeight, WebView is not attached ", new Exception());
            return;
        }
        super.notifyUpdateHeight(this.mWebViewManagers.get(webView), webView);
    }

    public TaboolaJs setLogLevel(int logLevel) {
        Taboola.setLogLevel(logLevel);
        return this;
    }

    public TaboolaJs setOnRenderListener(@NonNull WebView webView, @Nullable OnRenderListener onRenderListener) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.setOnRenderListener(onRenderListener);
        } else {
            Logger.e(TAG, "setOnRenderListener: WebView is not registered");
        }
        return this;
    }

    public TaboolaJs setTag(@NonNull WebView webView, String tag) {
        if (webView == null || webView.getContext() == null) {
            Logger.e(TAG, "notifyUpdateHeight, WebView is not attached ", new Exception());
            return this;
        }
        super.setTag(this.mWebViewManagers.get(webView), tag);
        return this;
    }

    public TaboolaJs setOnResizeListener(@NonNull WebView webView, @Nullable OnResizeListener onResizeListener) {
        super.setOnResizeListener(this.mWebViewManagers.get(webView), onResizeListener);
        return this;
    }

    public TaboolaJs setOnClickListener(@NonNull WebView webView, @Nullable TaboolaOnClickListener onClickListener) {
        Logger.d(TAG, onClickListener != null ? "setOnClickListener " : "TaboolaOnClickListener was removed");
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        super.setOnClickListener(webViewManager, onClickListener);
        return this;
    }

    @Override
    public TaboolaJs setExtraProperties(@NonNull Map<String, String> extraProperties) {
        super.setExtraProperties(extraProperties);
        return this;
    }

    public TaboolaJs setExtraProperties(@NonNull WebView webView, @NonNull Map<String, String> extraProperties) {
        return this.setExtraProperties(webView, extraProperties, null);
    }

    public TaboolaJs setExtraProperties(@NonNull WebView webView, @NonNull Map<String, String> extraProperties, String placement) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        super.setExtraProperties(webViewManager, extraProperties, placement);
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        WebViewManager2x.cleanTaboolaOnClickListener();
        this.mTaboolaUserActionListener = null;
    }

    public TaboolaJs setTaboolaUserActionListener(@Nullable TaboolaUserActionListener userActionListener) {
        String logMsg = userActionListener != null ? "setTaboolaUserActionListener " : "TaboolaUserActionListener was removed";
        Logger.d(TAG, logMsg);
        this.mTaboolaUserActionListener = userActionListener;
        return this;
    }

    public void reportUserAction(int actionType, String dataJsonString) {
        if (this.mTaboolaUserActionListener != null) {
            this.mTaboolaUserActionListener.onEvent(actionType, dataJsonString);
            Logger.d(TAG, " mTaboolaUserActionListener.onEvent()");
        } else {
            Logger.d(TAG, "mTaboolaUserActionListener == null");
        }
    }

    public void updatePassedAction(int actionType, String dataJsonString, WebView webView) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.updatePassedAction(actionType, dataJsonString);
        } else {
            Logger.e(TAG, "updateAction : webView not found!");
        }
    }

    public TaboolaJs setUserId(WebView webView, String userId) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            super.setUserId(webViewManager, userId);
        } else {
            Logger.e(TAG, "setUserId : webView not found!");
        }
        return this;
    }

    public void updateContent(WebView webView, TaboolaUpdateContentListener onUpdateContentListener) {
        super.updateContent(this.mWebViewManagers.get(webView), onUpdateContentListener);
    }

    public WebViewManager getWebViewManager(WebView webView) {
        return this.mWebViewManagers.get(webView);
    }
}

