/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.graphics.drawable.Drawable;
import android.support.annotation.Keep;
import android.text.TextUtils;
import com.taboola.android.PublisherInfo;
import com.taboola.android.api.TaboolaNative;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.monitor.MonitorHelper;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.listeners.TaboolaNativeListener;
import com.taboola.android.utils.Logger;
import java.util.Map;

@Keep
public class TaboolaNativeBuilder {
    private static final String TAG = TaboolaNativeBuilder.class.getSimpleName();
    private static final int CLICK_IGNORE_TIME_NOT_SET = -1;
    private IntegrationVerifier mIntegrationVerifier;
    private NetworkManager mNetworkManager;
    private ConfigManager mConfigManager;
    private MonitorHelper mMonitorHelper;
    private PublisherInfo mPublisherInfo;
    private AdvertisingIdInfo mAdvertisinIdInfo;
    private String mSourceType;
    private String mPageUrl;
    private Drawable mImagePlaceholderDrawable;
    private int mOnClickIgnoreTimeMs = -1;
    private Map<String, String> mExtraProperties;

    public TaboolaNativeBuilder(IntegrationVerifier integrationVerifier, NetworkManager networkManager, ConfigManager configManager, MonitorHelper monitorHelper, PublisherInfo publisherInfo, AdvertisingIdInfo advertisinIdInfo) {
        this.mIntegrationVerifier = integrationVerifier;
        this.mNetworkManager = networkManager;
        this.mConfigManager = configManager;
        this.mMonitorHelper = monitorHelper;
        this.mPublisherInfo = publisherInfo;
        this.mAdvertisinIdInfo = advertisinIdInfo;
    }

    public TaboolaNativeBuilder setImagePlaceholder(Drawable imagePlaceholder) {
        this.mImagePlaceholderDrawable = imagePlaceholder;
        return this;
    }

    public TaboolaNativeBuilder setOnClickIgnoreTimeMs(int onClickIgnoreTimeMs) {
        this.mOnClickIgnoreTimeMs = onClickIgnoreTimeMs;
        return this;
    }

    public TaboolaNativeBuilder setExtraProperties(Map<String, String> extraProperties) {
        this.mExtraProperties = extraProperties;
        return this;
    }

    public TaboolaNativeBuilder setSourceType(String sourceType) {
        this.mSourceType = sourceType;
        return this;
    }

    public TaboolaNativeBuilder setPageUrl(String pageUrl) {
        this.mPageUrl = pageUrl;
        return this;
    }

    public TaboolaNative build(String placementName, TaboolaNativeListener taboolaNativeListener) {
        if (taboolaNativeListener == null) {
            Logger.e(TAG, "taboolaNativeListener is null, did you forget");
        }
        TaboolaNative taboolaNative = new TaboolaNative(taboolaNativeListener, this.mIntegrationVerifier, this.mNetworkManager, this.mConfigManager, this.mMonitorHelper, this.mPublisherInfo, this.mAdvertisinIdInfo);
        if (!TextUtils.isEmpty((CharSequence)this.mSourceType)) {
            taboolaNative.setSourceType(this.mSourceType);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mPageUrl)) {
            taboolaNative.setPageUrl(this.mPageUrl);
        }
        if (!TextUtils.isEmpty((CharSequence)placementName)) {
            taboolaNative.setPlacementName(placementName);
        }
        if (this.mImagePlaceholderDrawable != null) {
            taboolaNative.setImagePlaceholder(this.mImagePlaceholderDrawable);
        }
        if (this.mOnClickIgnoreTimeMs != -1) {
            taboolaNative.setOnClickIgnoreTimeMs(this.mOnClickIgnoreTimeMs);
        }
        if (this.mExtraProperties != null) {
            taboolaNative.setExtraProperties(this.mExtraProperties);
        }
        return taboolaNative;
    }
}

