/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.graphics.drawable.Drawable;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.taboola.android.PublisherInfo;
import com.taboola.android.api.TBPublisherApi;
import com.taboola.android.api.TaboolaNativeParent;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.global_components.PicassoHelper;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.monitor.MonitorHelper;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.listeners.TaboolaNativeListener;

@Keep
public class TaboolaNative
extends TaboolaNativeParent {
    public static final String TAG = TaboolaNative.class.getSimpleName();
    private TaboolaNativeListener mTaboolaNativeListener;

    TaboolaNative(TaboolaNativeListener taboolaNativeListener, IntegrationVerifier integrationVerifier, NetworkManager networkManager, ConfigManager configManager, MonitorHelper monitorHelper, @NonNull PublisherInfo publisherInfo, AdvertisingIdInfo advertisingIdInfo) {
        String publisherId = publisherInfo.getPublisherId();
        this.mTaboolaNativeListener = taboolaNativeListener;
        this.mIntegrationVerifier = integrationVerifier;
        this.mPicassoHelper = PicassoHelper.getInstance();
        this.mPicassoHelper.setTaboolaNativeListener(taboolaNativeListener);
        configManager.setConfigDataFromRemoteWithPublisher(publisherId);
        this.mDefaultTBPublisherApi = new TBPublisherApi(networkManager, configManager, monitorHelper, this.mPicassoHelper, publisherId, advertisingIdInfo);
        this.mDefaultTBPublisherApi.setTaboolaNativeListener(taboolaNativeListener);
        this.mDefaultTBPublisherApi.init(publisherInfo.getApiKey());
    }

    public TaboolaNative setOnClickListener(TaboolaOnClickListener onClickListener) {
        this.mDefaultTBPublisherApi.setOnClickListener(onClickListener);
        return this;
    }

    public TaboolaNative setOnClickIgnoreTimeMs(int onClickIgnoreTimeMs) {
        this.mDefaultTBPublisherApi.setOnClickIgnoreTimeMs(onClickIgnoreTimeMs);
        return this;
    }

    public TaboolaNative setImagePlaceholder(Drawable placeholderDrawable) {
        this.mDefaultTBPublisherApi.setImagePlaceholder(placeholderDrawable);
        return this;
    }

    public void setSourceType(String sourceType) {
        this.mSourceType = sourceType;
    }

    public void setPageUrl(String pageUrl) {
        this.mPageUrl = pageUrl;
    }

    public void setPlacementName(String placementName) {
        this.mPlacementName = placementName;
    }

    public void setTaboolaNativeListener(TaboolaNativeListener taboolaNativeListener) {
        this.mTaboolaNativeListener = taboolaNativeListener;
    }

    @Override
    public void clear() {
        super.clear();
        this.mDefaultTBPublisherApi.clear();
        this.mDefaultTBPublisherApi = null;
    }

    public void reportEventToListener(int actionType, String data) {
        if (this.mTaboolaNativeListener != null) {
            this.mTaboolaNativeListener.onEvent(actionType, data);
        }
    }
}

