/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.Keep;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.ITaboolaImpl;
import com.taboola.android.Taboola;
import com.taboola.android.api.TBImageErrorListener;
import com.taboola.android.api.TBPublisherApi;
import com.taboola.android.api.TaboolaNativeParent;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.global_components.PicassoHelper;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.monitor.MonitorHelper;
import com.taboola.android.global_components.network.NetworkManager;
import java.util.HashMap;
import java.util.Map;

@Keep
public class TaboolaApi
extends TaboolaNativeParent {
    public static final String TAG = "TaboolaApi";
    private Map<String, TBPublisherApi> mTBPublisherApiMap = new HashMap<String, TBPublisherApi>();
    private NetworkManager mNetworkManager;
    private ConfigManager mConfigManager;
    private MonitorHelper mMonitorHelper;
    private AdvertisingIdInfo mAdvertisingIdInfo;
    private TaboolaEventsListener mEventsListener;

    private TaboolaApi() {
        ITaboolaImpl taboolaImpl = Taboola.getTaboolaImpl();
        this.mNetworkManager = taboolaImpl.getNetworkManager();
        this.mConfigManager = taboolaImpl.loadAndGetConfigManager();
        this.mMonitorHelper = taboolaImpl.getMonitorHelper();
        this.mPicassoHelper = PicassoHelper.getInstance();
        this.mAdvertisingIdInfo = Taboola.getTaboolaImpl().getAdvertisingIdInfo();
        this.mDefaultTBPublisherApi = new TBPublisherApi(this.mNetworkManager, this.mConfigManager, this.mMonitorHelper, this.mPicassoHelper, this.mAdvertisingIdInfo);
    }

    public static TaboolaApi getInstance() {
        return LazyHolder.INSTANCE;
    }

    public static TBPublisherApi getInstance(String publisherId) {
        TaboolaApi taboolaApi = TaboolaApi.getInstance();
        TBPublisherApi TBPublisherApi2 = taboolaApi.mTBPublisherApiMap.get(publisherId);
        if (TBPublisherApi2 == null) {
            ITaboolaImpl taboolaImpl = Taboola.getTaboolaImpl();
            TBPublisherApi2 = new TBPublisherApi(taboolaApi.mNetworkManager, taboolaApi.mConfigManager, taboolaImpl.getMonitorHelper(), PicassoHelper.getInstance(), publisherId, taboolaApi.mAdvertisingIdInfo);
            taboolaApi.addTBPublisherApiToMap(publisherId, TBPublisherApi2);
        }
        return TBPublisherApi2;
    }

    private void addTBPublisherApiToMap(String publisherId, TBPublisherApi tbPublisherApi) {
        Map<String, TBPublisherApi> publisherApiMapping = TaboolaApi.getInstance().mTBPublisherApiMap;
        publisherApiMapping.put(publisherId, tbPublisherApi);
    }

    @MainThread
    public TaboolaApi createTBPublisherApiAndInit(@Nullable Context applicationContext, @NonNull String publisherId, @NonNull String apiKey, @Nullable Map<String, String> extraProperties) {
        this.mDefaultTBPublisherApi = new TBPublisherApi(this.mNetworkManager, this.mConfigManager, this.mMonitorHelper, this.mPicassoHelper, publisherId, this.mAdvertisingIdInfo);
        this.mDefaultTBPublisherApi.init(apiKey, extraProperties);
        this.mTBPublisherApiMap.put(publisherId, this.mDefaultTBPublisherApi);
        return this;
    }

    @MainThread
    public TaboolaApi init(@NonNull Context applicationContext, @NonNull String publisherId, @NonNull String apiKey, @Nullable Map<String, String> extraProperties) {
        this.mConfigManager.setConfigDataFromRemoteWithPublisher(publisherId);
        TBPublisherApi tbPublisherApi = this.mTBPublisherApiMap.get(publisherId);
        if (tbPublisherApi != null && tbPublisherApi.isInitialized()) {
            tbPublisherApi.updateCurrentPublisher(extraProperties);
        } else {
            this.createTBPublisherApiAndInit(applicationContext, publisherId, apiKey, extraProperties);
        }
        return this;
    }

    @MainThread
    public TaboolaApi init(@NonNull Context applicationContext, @NonNull String publisherId, @NonNull String apiKey) {
        return this.init(applicationContext, publisherId, apiKey, null);
    }

    public TaboolaApi setOnClickListener(TaboolaOnClickListener onClickListener) {
        this.mDefaultTBPublisherApi.setOnClickListener(onClickListener);
        return this;
    }

    public TaboolaApi setOnClickIgnoreTimeMs(int onClickIgnoreTimeMs) {
        this.mDefaultTBPublisherApi.setOnClickIgnoreTimeMs(onClickIgnoreTimeMs);
        return this;
    }

    public TaboolaApi setLogLevel(int logLevel) {
        Taboola.setLogLevel(logLevel);
        return this;
    }

    public TaboolaApi setImagePlaceholder(Drawable placeholderDrawable) {
        this.mDefaultTBPublisherApi.setImagePlaceholder(placeholderDrawable);
        return this;
    }

    public void setImageErrorListener(TBImageErrorListener tbImageErrorListener) {
        this.mPicassoHelper.setImageErrorListener(tbImageErrorListener);
    }

    @Override
    public void clear() {
        super.clear();
        for (TBPublisherApi tbPublisherApi : this.mTBPublisherApiMap.values()) {
            if (tbPublisherApi == null) continue;
            tbPublisherApi.clear();
        }
        this.mTBPublisherApiMap.clear();
        this.mDefaultTBPublisherApi = null;
        this.mEventsListener = null;
    }

    public void setTaboolaEventsListener(TaboolaEventsListener eventsListener) {
        this.mEventsListener = eventsListener;
    }

    @Nullable
    TaboolaEventsListener getTaboolaEventsListener() {
        return this.mEventsListener;
    }

    public void reportEventToListener(int actionType, String data) {
        if (this.mEventsListener != null) {
            this.mEventsListener.onEvent(actionType, data);
        }
    }

    public static abstract class TaboolaEventsListener {
        public abstract void onEvent(int var1, String var2);
    }

    private static class LazyHolder {
        static final TaboolaApi INSTANCE = new TaboolaApi();

        private LazyHolder() {
        }
    }
}

