/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Keep;
import android.support.annotation.MainThread;
import android.util.Log;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.taboola.android.api.PublicApi;
import com.taboola.android.api.TBPublisherApi;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TBRecommendationsRequest;
import com.taboola.android.utils.Logger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Keep
public class TBPlacement
implements PublicApi.PublicTBPlacement,
Parcelable {
    private static final String TAG = "TBPlacement";
    @SerializedName(value="id")
    @Expose
    private String id;
    @SerializedName(value="ui")
    @Expose
    private String ui;
    @SerializedName(value="variant")
    @Expose
    private String variant;
    private String mPlacementName;
    private String mPublisherId;
    @SerializedName(value="list")
    @Expose
    private List<TBRecommendationItem> mRecommendationItems = new ArrayList<TBRecommendationItem>();
    private boolean hasReportedAvailability;
    private boolean hasReportedVisibility;
    private boolean mIsHighlighted;
    private TBRecommendationsRequest mNextBatchRequest;
    public static final Parcelable.Creator<TBPlacement> CREATOR = new Parcelable.Creator<TBPlacement>(){

        public TBPlacement createFromParcel(Parcel in) {
            return new TBPlacement(in);
        }

        public TBPlacement[] newArray(int size) {
            return new TBPlacement[size];
        }
    };
    private TBPublisherApi mTBPublisherApi;
    private transient ApiMonitorHandler mApiMonitorHandler;

    protected TBPlacement(Parcel in) {
        this.id = in.readString();
        this.ui = in.readString();
        this.variant = in.readString();
        this.mPlacementName = in.readString();
        this.mPublisherId = in.readString();
        this.mRecommendationItems = in.createTypedArrayList(TBRecommendationItem.CREATOR);
        this.hasReportedAvailability = in.readByte() != 0;
        this.hasReportedVisibility = in.readByte() != 0;
        this.mIsHighlighted = in.readByte() != 0;
        this.mNextBatchRequest = (TBRecommendationsRequest)in.readParcelable(TBRecommendationsRequest.class.getClassLoader());
        for (TBRecommendationItem recommendationItem : this.mRecommendationItems) {
            recommendationItem.setPlacement(this);
        }
    }

    @Override
    public List<TBRecommendationItem> getItems() {
        return this.mRecommendationItems;
    }

    @Override
    public void prefetchThumbnails() {
        for (TBRecommendationItem item : this.mRecommendationItems) {
            item.prefetchThumbnail();
        }
    }

    public void notifyAvailable() {
        this.onItemAvailable();
    }

    public int getBatchId() {
        return this.mNextBatchRequest.getPlacementRequests().values().iterator().next().getBatchCounter() - 1;
    }

    void onItemAvailable() {
        if (!this.hasReportedAvailability) {
            this.hasReportedAvailability = true;
            if (this.mTBPublisherApi.isInitialized()) {
                this.mTBPublisherApi.onPlacementAvailable(this.id, this);
                if (this.mTBPublisherApi.isSdkMonitorEnabled()) {
                    this.mTBPublisherApi.sendApiAvailable(this.id);
                }
            } else {
                this.reportErrorNotInitialized();
            }
        }
    }

    private void reportErrorNotInitialized() {
        Logger.e(TAG, "TBPublisherApi is not initialized, mPublisherId =  " + this.mPublisherId, new Exception());
    }

    void onItemVisible() {
        Log.d((String)TAG, (String)"onItemVisible() called");
        if (!this.hasReportedVisibility) {
            this.hasReportedVisibility = true;
            if (this.mTBPublisherApi.isInitialized()) {
                this.mTBPublisherApi.onPlacementVisible(this.id, this);
                if (this.mTBPublisherApi.isSdkMonitorEnabled()) {
                    this.mTBPublisherApi.sendApiVisible(this.id);
                }
            } else {
                this.reportErrorNotInitialized();
            }
        }
    }

    @MainThread
    public void reportEvent(String type, Map<String, String> data, String password) {
        if (this.mTBPublisherApi.isInitialized()) {
            this.mTBPublisherApi.reportClientEvent(type, data, password, this.id);
        } else {
            this.reportErrorNotInitialized();
        }
    }

    String getName() {
        return this.mPlacementName;
    }

    void setName(String name) {
        this.mPlacementName = name;
    }

    public String getPublisherId() {
        return this.mPublisherId;
    }

    void setPublisherId(String publisherId) {
        this.mPublisherId = publisherId;
    }

    String getId() {
        return this.id;
    }

    void setHasReportedAvailability(boolean hasReportedAvailability) {
        this.hasReportedAvailability = hasReportedAvailability;
    }

    TBRecommendationsRequest getNextBatchRequest() {
        return this.mNextBatchRequest;
    }

    void setNextBatchRequest(TBRecommendationsRequest nextBatchRequest) {
        this.mNextBatchRequest = nextBatchRequest;
    }

    private boolean isHighlighted() {
        return this.mIsHighlighted;
    }

    private void setHighlighted(boolean isHighlighted) {
        this.mIsHighlighted = isHighlighted;
        for (TBRecommendationItem item : this.mRecommendationItems) {
            item.setHighlighted(this.mIsHighlighted);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.ui);
        dest.writeString(this.variant);
        dest.writeString(this.mPlacementName);
        dest.writeString(this.mPublisherId);
        dest.writeTypedList(this.mRecommendationItems);
        dest.writeByte((byte)(this.hasReportedAvailability ? 1 : 0));
        dest.writeByte((byte)(this.hasReportedVisibility ? 1 : 0));
        dest.writeByte((byte)(this.mIsHighlighted ? 1 : 0));
        dest.writeParcelable((Parcelable)this.mNextBatchRequest, flags);
    }

    ApiMonitorHandler getApiMonitorHandler() {
        if (this.mApiMonitorHandler == null) {
            this.mApiMonitorHandler = new ApiMonitorHandler(this);
        }
        return this.mApiMonitorHandler;
    }

    public void setTBPublisherApi(TBPublisherApi TBPublisherApi2) {
        this.mTBPublisherApi = TBPublisherApi2;
        for (TBRecommendationItem recommendationItem : this.mRecommendationItems) {
            recommendationItem.setTBPublisherApiInstance(this.mTBPublisherApi);
        }
    }

    static class ApiMonitorHandler
    extends Handler {
        private final WeakReference<TBPlacement> mPlacementWeakReference;

        ApiMonitorHandler(TBPlacement placement) {
            this.mPlacementWeakReference = new WeakReference<TBPlacement>(placement);
        }

        public void handleMessage(Message msg) {
            TBPlacement placement = (TBPlacement)this.mPlacementWeakReference.get();
            switch (msg.what) {
                case 291: {
                    if (placement == null) break;
                    placement.setHighlighted(!placement.isHighlighted());
                }
            }
        }
    }
}

