/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.webkit.CookieManager;
import android.webkit.WebView;
import com.taboola.android.ITaboolaImpl;
import com.taboola.android.Taboola;
import com.taboola.android.TaboolaHybridParent;
import com.taboola.android.js.OnRenderListener;
import com.taboola.android.js.OnResizeListener;
import com.taboola.android.js.TaboolaJs;
import com.taboola.android.listeners.MediationEventListener;
import com.taboola.android.listeners.TaboolaDetectAdEventsListener;
import com.taboola.android.listeners.TaboolaEventListener;
import com.taboola.android.listeners.TaboolaUpdateContentListener;
import com.taboola.android.listeners.TaboolaUserActionListener;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.VisibilityUtil;
import java.util.HashMap;

@Keep
public class TaboolaWidget
extends TaboolaHybridParent {
    private static final String TAG = TaboolaWidget.class.getSimpleName();

    public TaboolaWidget(Context context) {
        super(context);
        this.commonConstructor(context);
    }

    public TaboolaWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.commonConstructor(context);
        this.parseXmlAttributes(context, attrs);
        Logger.d(TAG, "initialized basic components");
    }

    public TaboolaWidget(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.commonConstructor(context);
        this.parseXmlAttributes(context, attrs);
        Logger.d(TAG, "initialized basic components");
    }

    private void commonConstructor(Context context) {
        ITaboolaImpl taboolaImpl = Taboola.getTaboolaImpl();
        this.mPublisherInfo = taboolaImpl.getPublisherInfo();
        this.mAdvertisingIdInfo = taboolaImpl.getAdvertisingIdInfo();
        this.initWidgetSettings();
        this.initTaboolaJS(context);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void initTaboolaJS(Context context) {
        TaboolaJs.getInstance().init(context.getApplicationContext(), true);
        CookieManager.getInstance().setAcceptCookie(true);
        this.updateScrollBehaviour();
        OnRenderListener onRenderListener = new OnRenderListener(){

            @Override
            public void onRenderSuccessful(WebView webView, String placementName, int height) {
                if (Build.VERSION.SDK_INT <= 19) {
                    TaboolaWidget.this.startInvalidationOnScrollEvents();
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            TaboolaWidget.this.invalidateWebView(TaboolaWidget.this);
                        }
                    }, 3000L);
                }
                Logger.d(TAG, "onRenderSuccessful: " + placementName);
                TaboolaWidget.this.dispatchLoadSuccessful();
            }

            @Override
            public void onRenderFailed(WebView webView, String placementName, String errorMessage) {
                Logger.e(TAG, "onRenderFailed: " + placementName + " " + errorMessage);
                TaboolaWidget.this.dispatchLoadFailed(errorMessage);
            }
        };
        OnResizeListener onResizeListener = new OnResizeListener(){

            @Override
            public void onResize(WebView webView, String placementName, int height) {
                TaboolaJs taboolaJs = TaboolaJs.getInstance();
                int heightPx = VisibilityUtil.convertCssPixelToPixel(height);
                TaboolaWidget.this.resizeWidget(taboolaJs, taboolaJs.getWebViewManager(TaboolaWidget.this), heightPx);
            }

            @Override
            public void onOrientationChange(WebView webView, int height) {
                int heightPx = VisibilityUtil.convertCssPixelToPixel(height);
                TaboolaWidget.this.onOrientationChange(heightPx);
            }
        };
        TaboolaJs.getInstance().registerWebView(this, onRenderListener);
        TaboolaJs.getInstance().setOnResizeListener(this, onResizeListener);
    }

    protected void onOrientationChange(int heightPx) {
        TaboolaJs taboolaJs = TaboolaJs.getInstance();
        super.onOrientationChange(taboolaJs, taboolaJs.getWebViewManager(this), heightPx);
    }

    @Override
    protected void clearDependencies() {
        TaboolaJs.getInstance().unregisterWebView(this);
        TaboolaJs.getInstance().setOnClickListener(this, null);
        TaboolaJs.getInstance().setTaboolaUserActionListener(null);
        super.clearDependencies();
    }

    @Override
    protected void clearTaboolaWebInstance() {
    }

    @Override
    public void notifyUpdateHeight() {
        TaboolaJs.getInstance().notifyUpdateHeight(this);
    }

    public TaboolaWidget fetchContent() {
        TaboolaJs taboolaJs = TaboolaJs.getInstance();
        super.fetchContent(taboolaJs, taboolaJs.getWebViewManager(this));
        return this;
    }

    public TaboolaWidget refresh() {
        TaboolaJs taboolaJs = TaboolaJs.getInstance();
        super.refresh(taboolaJs, taboolaJs.getWebViewManager(this));
        return this;
    }

    public TaboolaWidget reset() {
        super.reset();
        return this;
    }

    public TaboolaWidget setAutoResizeHeight(boolean shouldAutoResizeHeight) {
        super.setAutoResizeHeight(shouldAutoResizeHeight);
        return this;
    }

    @Override
    public boolean isAutoResizeHeight() {
        return super.isAutoResizeHeight();
    }

    public TaboolaWidget setScrollEnabled(boolean isScrollEnabled) {
        super.setScrollEnabled(isScrollEnabled);
        return this;
    }

    @Override
    public boolean isScrollEnabled() {
        return super.isScrollEnabled();
    }

    public TaboolaWidget setOptionalWidgetStyle(String newCSSStyle) {
        super.setOptionalWidgetStyle(newCSSStyle);
        return this;
    }

    @Override
    public String getOptionalWidgetStyle() {
        return super.getOptionalWidgetStyle();
    }

    public TaboolaWidget setMediatedVia(String mediatedVia) {
        super.setMediatedVia(mediatedVia);
        return this;
    }

    @Override
    public void setInterceptScroll(boolean bIntercept) {
        super.setInterceptScroll(bIntercept);
    }

    @Override
    public String getPublisher() {
        return super.getPublisher();
    }

    public TaboolaWidget setPublisher(String newPub) {
        super.setPublisher(newPub);
        return this;
    }

    public TaboolaWidget setViewId(String viewID) {
        super.setViewId(viewID);
        return this;
    }

    public TaboolaWidget setTag(@NonNull String tag) {
        TaboolaJs.getInstance().setTag(this, tag);
        return this;
    }

    @Override
    public String getMode() {
        return super.getMode();
    }

    public TaboolaWidget setMode(String newMode) {
        super.setMode(newMode);
        return this;
    }

    @Override
    public String getPlacement() {
        return super.getPlacement();
    }

    @Override
    public String getPageType() {
        return super.getPageType();
    }

    public TaboolaWidget setPlacement(String newPlacement) {
        super.setPlacement(newPlacement);
        return this;
    }

    public TaboolaWidget setPageType(String newPageType) {
        super.setPageType(newPageType);
        return this;
    }

    @Override
    public String getTargetType() {
        return super.getTargetType();
    }

    public TaboolaWidget setTargetType(String newTargetType) {
        super.setTargetType(newTargetType);
        return this;
    }

    @Override
    public String getPageUrl() {
        return super.getPageUrl();
    }

    public TaboolaWidget setPageUrl(String newPageUrl) {
        super.setPageUrl(newPageUrl);
        return this;
    }

    @Override
    public String getPageId() {
        return super.getPageId();
    }

    public TaboolaWidget setPageId(String newPageId) {
        super.setPageId(newPageId);
        return this;
    }

    public TaboolaWidget setProgressBarEnabled(boolean isEnabled) {
        super.setProgressBarEnabled(isEnabled);
        return this;
    }

    public TaboolaWidget setProgressBarColor(@ColorInt int progressColor) {
        super.setProgressBarColor(progressColor);
        return this;
    }

    public TaboolaWidget setProgressBarDuration(float duration) {
        super.setProgressBarDuration(duration);
        return this;
    }

    @Override
    @Deprecated
    public boolean isItemClickEnabled() {
        return super.isItemClickEnabled();
    }

    @Override
    @Deprecated
    public void setItemClickEnabled(boolean mIsItemClickEnabled) {
        super.setFocusableInTouchMode(mIsItemClickEnabled);
    }

    public TaboolaWidget setTaboolaEventListener(TaboolaEventListener newListener) {
        TaboolaJs taboolaJs = TaboolaJs.getInstance();
        super.setTaboolaEventListener(taboolaJs, taboolaJs.getWebViewManager(this), newListener);
        return this;
    }

    public TaboolaWidget setTaboolaUserActionListener(TaboolaUserActionListener listener) {
        TaboolaJs.getInstance().setTaboolaUserActionListener(listener);
        return this;
    }

    public TaboolaWidget setTaboolaDetectAdEventsListener(TaboolaDetectAdEventsListener newListener) {
        this.mTaboolaDetectAdEventsListener = newListener;
        return this;
    }

    public TaboolaWidget setMediationEventListener(MediationEventListener mediationEventListener) {
        this.mMediationEventListener = mediationEventListener;
        return this;
    }

    public void setLogLevel(int logLevel) {
        Taboola.setLogLevel(logLevel);
    }

    public int getTextZoom() {
        return this.getSettings().getTextZoom();
    }

    public TaboolaWidget setTextZoom(int textZoom) {
        this.getSettings().setTextZoom(textZoom);
        return this;
    }

    public TaboolaWidget setExtraProperties(HashMap<String, String> extraProperties) {
        super.setExtraProperties(extraProperties);
        return this;
    }

    @Deprecated
    public TaboolaWidget setOptionalPageCommands(HashMap<String, String> arrCommands) {
        super.setOptionalPageCommands(arrCommands);
        return this;
    }

    @Deprecated
    public TaboolaWidget setOptionalModeCommands(HashMap<String, String> arrCommands) {
        super.pushCommands(arrCommands);
        return this;
    }

    @Override
    @Deprecated
    public void pushCommands(HashMap<String, String> arrCommands) {
        super.pushCommands(arrCommands);
    }

    private void startInvalidationOnScrollEvents() {
        super.startInvalidationOnScrollEvents(this);
    }

    public void updateAction(int actionType, String actionString) {
        TaboolaJs.getInstance().updatePassedAction(actionType, actionString, this);
    }

    public TaboolaWidget setAction(int actionType, String data) {
        super.setAction(actionType, data);
        return this;
    }

    public TaboolaWidget setUserId(String userId) {
        this.mUserId = userId;
        TaboolaJs.getInstance().setUserId(this, userId);
        return this;
    }

    @Override
    public void updateContent(TaboolaUpdateContentListener updateContentListener) {
        TaboolaJs.getInstance().updateContent(this, updateContentListener);
    }
}

