/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.content.Context;
import android.support.annotation.NonNull;
import com.taboola.android.ITaboolaImpl;
import com.taboola.android.PublisherInfo;
import com.taboola.android.TaboolaHybridBuilder;
import com.taboola.android.api.TaboolaNativeBuilder;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.eventsmanager.EventsManager;
import com.taboola.android.global_components.eventsmanager.SessionInfo;
import com.taboola.android.global_components.eventsmanager.events.TaboolaEvent;
import com.taboola.android.global_components.eventsmanager.events.TaboolaMobileEvent;
import com.taboola.android.global_components.gueh.GlobalUncaughtExceptionHandler;
import com.taboola.android.global_components.gueh.TaboolaExceptionHandler;
import com.taboola.android.global_components.gueh.impl.ProductionGuehImpl;
import com.taboola.android.global_components.monitor.MonitorHelper;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.js.TaboolaWebBuilder;
import com.taboola.android.utils.ExtraProperty;
import com.taboola.android.utils.IntegrationVerifierUtils;
import com.taboola.android.utils.Logger;
import java.util.ArrayList;
import java.util.Map;

class TaboolaImpl
implements ITaboolaImpl {
    private static final String TAG = TaboolaImpl.class.getSimpleName();
    private NetworkManager mNetworkManager;
    private GlobalUncaughtExceptionHandler mGlobalExceptionHandler;
    private IntegrationVerifier mIntegrationVerifier;
    private EventsManager mEventsManager;
    private PublisherInfo mPublisherInfo;
    private ConfigManager mConfigManager;
    private MonitorHelper mMonitorHelper;
    private Context mContext;
    private AdvertisingIdInfo mAdvertisingIdInfo;

    TaboolaImpl() {
        Logger.d(TAG, "TaboolaImpl constructed.");
    }

    @Override
    public void internalGlobalInit(Context context) {
        Logger.d(TAG, "TaboolaImpl | init called..");
        this.mContext = context;
        this.mAdvertisingIdInfo = new AdvertisingIdInfo(context);
        this.mNetworkManager = new NetworkManager(context);
        this.mEventsManager = new EventsManager(context, this.mNetworkManager);
        this.mIntegrationVerifier = new IntegrationVerifier(this.mNetworkManager);
        this.mGlobalExceptionHandler = this.getGuehImpl(this.mNetworkManager, context);
        this.mConfigManager = new ConfigManager(this.mNetworkManager, this.mGlobalExceptionHandler, this.mEventsManager);
        this.mMonitorHelper = new MonitorHelper();
    }

    @Override
    public int getImplementationId() {
        return 0;
    }

    @Override
    public void init(PublisherInfo publisherInfo) {
        this.mPublisherInfo = publisherInfo;
    }

    @Override
    public TaboolaHybridBuilder getTaboolaHybridBuilder(Context context, String pageUrl, String pageType) {
        return new TaboolaHybridBuilder(context, this.mIntegrationVerifier, this.mNetworkManager, this.loadAndGetConfigManager(), this.mPublisherInfo, this.mAdvertisingIdInfo, this.mMonitorHelper).setPageUrl(pageUrl).setPageType(pageType);
    }

    @Override
    public TaboolaNativeBuilder getTaboolaNativeBuilder(String sourceType, String pageUrl) {
        return new TaboolaNativeBuilder(this.mIntegrationVerifier, this.mNetworkManager, this.loadAndGetConfigManager(), this.mMonitorHelper, this.mPublisherInfo, this.mAdvertisingIdInfo).setSourceType(sourceType).setPageUrl(pageUrl);
    }

    @Override
    public TaboolaWebBuilder getTaboolaWebBuilder() {
        return new TaboolaWebBuilder(this.mIntegrationVerifier, this.mNetworkManager, this.loadAndGetConfigManager(), this.mAdvertisingIdInfo, this.mMonitorHelper, false);
    }

    @Override
    public EventsManager getEventsManager() {
        return this.mEventsManager;
    }

    @Override
    public void reportTaboolaEvent(SessionInfo sessionInfo, TaboolaEvent ... events) {
        this.reportTaboolaEvent(this.mPublisherInfo, sessionInfo, events);
    }

    @Override
    public void reportTaboolaEvent(PublisherInfo publisherInfo, SessionInfo sessionInfo, TaboolaEvent ... events) {
        if (events != null) {
            ArrayList<TaboolaMobileEvent> taboolaMobileEvents = new ArrayList<TaboolaMobileEvent>();
            for (TaboolaEvent event : events) {
                if (event instanceof TaboolaMobileEvent) {
                    TaboolaMobileEvent taboolaMobileEvent = (TaboolaMobileEvent)event;
                    taboolaMobileEvents.add(taboolaMobileEvent);
                    continue;
                }
                Logger.e(TAG, "Taboola event type is unrecognizable.");
            }
            if (!taboolaMobileEvents.isEmpty()) {
                this.mEventsManager.reportTaboolaMobileEvent(publisherInfo, sessionInfo, taboolaMobileEvents.toArray(new TaboolaMobileEvent[0]));
            }
        }
    }

    @Override
    public GlobalUncaughtExceptionHandler getGuehImpl(NetworkManager networkManager, Context context) {
        return new ProductionGuehImpl(networkManager, context).start();
    }

    @Override
    public void registerTaboolaExceptionHandler(TaboolaExceptionHandler taboolaExceptionHandler) {
        if (this.mGlobalExceptionHandler != null) {
            this.mGlobalExceptionHandler.registerExceptionHandler(taboolaExceptionHandler);
        } else {
            Logger.d(TAG, "registerTaboolaExceptionHandler | not registering handler, mGlobalExceptionHandler is null.");
        }
    }

    @Override
    public GlobalUncaughtExceptionHandler getGlobalExceptionHandler() {
        return this.mGlobalExceptionHandler;
    }

    @Override
    public void setExtraProperties(@NonNull Map<String, String> extraProperties) {
        IntegrationVerifierUtils.verifyExtraProperties(this.mIntegrationVerifier, 0, extraProperties);
        for (String key : extraProperties.keySet()) {
            String value = extraProperties.get(key);
            ExtraProperty extraProperty = ExtraProperty.getExtraProperty(key);
            switch (extraProperty) {
                case SET_GUEH: {
                    if (this.mGlobalExceptionHandler != null) {
                        this.mGlobalExceptionHandler.toggle(Boolean.parseBoolean(value));
                        break;
                    }
                    Logger.e(TAG, "Trying to enable/disable GUEH before initialization. mGlobalExceptionHandler = null.");
                    break;
                }
                case EVENTS_MANAGER_ENABLE: {
                    if (this.mEventsManager == null) break;
                    this.mEventsManager.toggleEventsManager(Boolean.parseBoolean(value));
                    break;
                }
                case EVENTS_MANAGER_MAX_QUEUE_SIZE: {
                    if (this.mEventsManager == null) break;
                    this.mEventsManager.setsQueueMaxSize(Integer.valueOf(value));
                }
            }
        }
    }

    @Override
    public void verifyIntegration(boolean stopOnMandatoryFail) {
        this.mIntegrationVerifier.verifyIntegration(this.mContext, stopOnMandatoryFail);
    }

    @Override
    public NetworkManager getNetworkManager() {
        return this.mNetworkManager;
    }

    @Override
    public IntegrationVerifier getIntegrationVerifier() {
        return this.mIntegrationVerifier;
    }

    @Override
    public ConfigManager loadAndGetConfigManager() {
        this.mConfigManager.loadConfig();
        return this.mConfigManager;
    }

    @Override
    public boolean isKillSwitchEnabled(String placement) {
        if (this.mConfigManager != null) {
            return this.mConfigManager.getConfigValue(placement, "killSwitch", false);
        }
        return false;
    }

    @Override
    public AdvertisingIdInfo getAdvertisingIdInfo() {
        return this.mAdvertisingIdInfo;
    }

    @Override
    public PublisherInfo getPublisherInfo() {
        return this.mPublisherInfo;
    }

    @Override
    public MonitorHelper getMonitorHelper() {
        return this.mMonitorHelper;
    }

    @Override
    public void setLogLevel(int logLevel) {
        Logger.setLogLevel(this.mMonitorHelper.isSdkMonitorEnabled() != false ? 3 : logLevel);
    }
}

