/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SharedPrefUtil;
import java.nio.IntBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class GLHelper {
    private static final String TAG = GLHelper.class.getSimpleName();

    public static int getCachedMaxWidgetSize(Context context) {
        return SharedPrefUtil.getCachedMaxWidgetSize(context);
    }

    public static void getMaxWidgetSize(ViewGroup widget, @NonNull onMaxWidgetSizeRetrievedCallback callback) {
        GLSurfaceView glView = new GLSurfaceView(widget.getContext());
        glView.setRenderer((GLSurfaceView.Renderer)new ClearRenderer(widget, callback, glView));
        glView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
        widget.addView((View)glView);
    }

    static interface onMaxWidgetSizeRetrievedCallback {
        public void onMaxWidgetSizeRetrieved(int var1);
    }

    static class ClearRenderer
    implements GLSurfaceView.Renderer {
        ViewGroup mWidget;
        onMaxWidgetSizeRetrievedCallback callback;
        GLSurfaceView glView;

        public ClearRenderer(ViewGroup widget, onMaxWidgetSizeRetrievedCallback callback, GLSurfaceView glView) {
            this.mWidget = widget;
            this.callback = callback;
            this.glView = glView;
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            IntBuffer textureLimit = IntBuffer.allocate(1);
            gl.glGetIntegerv(3379, textureLimit);
            final int maxTextureSize = textureLimit.get(0);
            Handler mainHandler = new Handler(this.mWidget.getContext().getMainLooper());
            mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ClearRenderer.this.mWidget != null) {
                            ClearRenderer.this.mWidget.removeView((View)ClearRenderer.this.glView);
                            int maxWidgetSize = maxTextureSize - 100;
                            Logger.d(TAG, "onMaxWidgetSizeRetrieved :: size " + maxWidgetSize);
                            ClearRenderer.this.callback.onMaxWidgetSizeRetrieved(maxWidgetSize);
                            SharedPrefUtil.setCachedMaxWidgetSize(ClearRenderer.this.mWidget.getContext(), maxWidgetSize);
                        }
                    }
                    catch (Exception e) {
                        Logger.e(TAG, e.getMessage(), e);
                    }
                    finally {
                        ClearRenderer.this.mWidget = null;
                        ClearRenderer.this.callback = null;
                        ClearRenderer.this.glView = null;
                    }
                }
            });
        }

        public void onSurfaceChanged(GL10 gl, int w, int h) {
        }

        public void onDrawFrame(GL10 gl) {
            gl.glClear(16384);
        }
    }
}

