/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.lightnetwork.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SharedPrefUtil {
    private static final String TAG = SharedPrefUtil.class.getSimpleName();
    private static final String SHARED_PREFS_KEY = "com.taboola.lightnetwork.SHARED_PREFERENCES_KEY";
    private static final String TRACK_HEADER_SHARED_PREFS_KEY_PREFIX = "com.taboola.lightnetwork.TRACK_HEADER_SHARED_PREFS_KEY_%s";

    @SuppressLint(value={"ApplySharedPref"})
    public static void setTrackHeadersMap(Context context, Map<String, String> trackHeaderMap, String trackHeader) {
        if (context == null) {
            Log.e((String)TAG, (String)"setTrackHeadersMap: cannot save headers with null context.");
            return;
        }
        JSONObject jsonObject = new JSONObject(trackHeaderMap);
        String jsonString = jsonObject.toString();
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFS_KEY, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(String.format(TRACK_HEADER_SHARED_PREFS_KEY_PREFIX, trackHeader), jsonString);
        editor.commit();
    }

    public static HashMap<String, String> getTrackHeadersMap(Context context, String trackHeader) {
        if (context == null) {
            Log.e((String)TAG, (String)"setTrackHeadersMap: cannot set headers in request with null context.");
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFS_KEY, 0);
        String jsonString = preferences.getString(String.format(TRACK_HEADER_SHARED_PREFS_KEY_PREFIX, trackHeader), null);
        HashMap<String, String> trackHeaderMap = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)jsonString)) {
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                Iterator keysItr = jsonObject.keys();
                while (keysItr.hasNext()) {
                    String key = (String)keysItr.next();
                    String value = jsonObject.getString(key);
                    trackHeaderMap.put(key, value);
                }
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Failed inflating TrackHeaders map.", (Throwable)e);
            }
        }
        return trackHeaderMap;
    }
}

