/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.lightnetwork.protocols.http;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.lightnetwork.protocols.http.CookiesTracker;
import com.taboola.lightnetwork.protocols.http.HeadersManager;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.Normalizer;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

abstract class HttpRequest {
    private static final String TAG = HttpRequest.class.getSimpleName();
    private static final String HEADER_FIELD_LOCATION = "Location";
    private int mConfiguredTimeout;
    private HeadersManager mHeadersManager;
    private CookiesTracker mCookiesTracker;
    private WeakReference<Looper> mOriginalLooper;
    Map<String, String> mRequestHeaders;
    String mUrl;
    String mTrackHeadersByGroup;
    String mTrackHeadersKey;

    public HttpRequest(int configuredTimeout, HeadersManager headersManager, CookiesTracker cookiesTracker) {
        this.mConfiguredTimeout = configuredTimeout;
        this.mHeadersManager = headersManager;
        this.mCookiesTracker = cookiesTracker;
    }

    void performRequsetOnBackgroundThread(final HttpManager.NetworkResponse networkResponse) {
        this.mOriginalLooper = new WeakReference<Looper>(Looper.myLooper());
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    HttpRequest.this.performRequest(networkResponse);
                }
            }).start();
        } else {
            this.performRequest(networkResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRequest(HttpManager.NetworkResponse networkResponse) {
        HttpURLConnection connection = null;
        try {
            if (this.mUrl.toLowerCase().contains("https://")) {
                connection = (HttpsURLConnection)new URL(this.mUrl).openConnection();
            } else if (this.mUrl.toLowerCase().contains("http://")) {
                connection = (HttpURLConnection)new URL(this.mUrl).openConnection();
            } else {
                this.returnError(networkResponse, new HttpError("Url must begin with http:// or https://"));
                return;
            }
            this.mHeadersManager.setHeadersInRequest(connection, this.mRequestHeaders);
            this.mCookiesTracker.setCookiesInRequest(connection, this.mTrackHeadersByGroup);
            connection.setConnectTimeout(this.mConfiguredTimeout);
            connection.setReadTimeout(this.mConfiguredTimeout);
            this.adjustUserAgent(connection);
            this.protocolSpecificConnectionSetup(connection);
            connection.connect();
            this.handleResponse(networkResponse, connection);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("performRequest error: " + e.getLocalizedMessage()));
            this.returnError(networkResponse, new HttpError("Exception: " + e.getLocalizedMessage()));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void adjustUserAgent(HttpURLConnection connection) {
        String HTTP_AGENT = "http.agent";
        String USER_AGENT_PROPERTY = "User-Agent";
        String userAgent = System.getProperty("http.agent");
        if (!TextUtils.isEmpty((CharSequence)userAgent)) {
            userAgent = this.removeNonAscii(userAgent);
            connection.setRequestProperty("User-Agent", userAgent);
        }
    }

    private String removeNonAscii(String src) {
        return Normalizer.normalize(src, Normalizer.Form.NFD).replaceAll("[^\\x00-\\x7F]", "");
    }

    abstract void protocolSpecificConnectionSetup(HttpURLConnection var1) throws IOException;

    private void handleResponse(HttpManager.NetworkResponse networkResponse, HttpURLConnection connection) throws IOException {
        int status = connection.getResponseCode();
        if (status >= 200 && status < 300) {
            this.handleResponseOK(networkResponse, status, connection);
        } else if (status == 301 || status == 302 || status == 303) {
            this.handleResponseRedirect(networkResponse, connection);
        } else {
            Log.v((String)TAG, (String)("HttpRequest | handleResponse | error, response code = " + status));
            this.returnError(networkResponse, new HttpError("Invalid response code: " + status));
        }
    }

    private void handleResponseOK(HttpManager.NetworkResponse networkResponse, int statusCode, HttpURLConnection connection) throws IOException {
        String line;
        Map<String, List<String>> headerFields = this.mHeadersManager.getHeadersFromResponse(connection);
        this.mCookiesTracker.getCookiesFromResponse(connection, this.mTrackHeadersKey, this.mTrackHeadersByGroup);
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((line = br.readLine()) != null) {
            response.append(line).append("\n");
        }
        br.close();
        this.returnResponse(networkResponse, new HttpResponse(statusCode, response.toString(), headerFields));
    }

    private void handleResponseRedirect(HttpManager.NetworkResponse networkResponse, HttpURLConnection connection) {
        this.mUrl = connection.getHeaderField(HEADER_FIELD_LOCATION);
        Log.v((String)TAG, (String)("HttpRequest | handleResponse | redirect, url = " + this.mUrl));
        this.performRequest(networkResponse);
    }

    private void returnResponse(final HttpManager.NetworkResponse networkResponse, final HttpResponse response) {
        if (networkResponse != null) {
            Looper looper = this.getBestThreadLooepr();
            new Handler(looper).post(new Runnable(){

                @Override
                public void run() {
                    networkResponse.onResponse(response);
                }
            });
        }
    }

    private void returnError(final HttpManager.NetworkResponse networkResponse, final HttpError error) {
        if (networkResponse != null) {
            Looper looper = this.getBestThreadLooepr();
            new Handler(looper).post(new Runnable(){

                @Override
                public void run() {
                    networkResponse.onError(error);
                }
            });
        }
    }

    private Looper getBestThreadLooepr() {
        Looper looper = (Looper)this.mOriginalLooper.get();
        if (looper == null) {
            looper = Looper.getMainLooper();
            Log.d((String)TAG, (String)"Network cannot return response callback on calling Thread. Is calling Thread still alive? Returning callback on main Thread.");
        }
        return looper;
    }
}

