/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.TextView;
import com.taboola.android.api.PublicApi;
import com.taboola.android.api.SdkVisibilityCheckScheduler;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.VisibilityUtil;

@Keep
public class TBTextView
extends TextView
implements PublicApi.PublicTBView {
    private static final String TAG = TBTextView.class.getSimpleName();
    private TBRecommendationItem mRecommendationItem;
    @Nullable
    private SdkVisibilityCheckScheduler mSdkVisibilityCheckScheduler;

    TBTextView(Context context, String publisherId) {
        super(context);
        super.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TBTextView.this.mRecommendationItem.onViewClick(TBTextView.this.getContext());
            }
        });
        this.mSdkVisibilityCheckScheduler = new SdkVisibilityCheckScheduler((View)this, publisherId);
    }

    @Override
    public void handleClick() {
        this.mRecommendationItem.handleClick(this.getContext());
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        throw new UnsupportedOperationException("To set custom onClick handling use TaboolaRestSDK.setOnClickListener()");
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mRecommendationItem.onViewAvailable();
        Logger.d(TAG, "onAttachedToWindow: isShown() " + this.isShown());
        if (this.isShown()) {
            this.startVisibilityCheck();
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        Logger.d(TAG, "onVisibilityChanged: isShown() " + this.isShown());
        if (this.isShown()) {
            this.startVisibilityCheck();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopVisibilityCheck();
    }

    void startVisibilityCheck() {
        if (this.mSdkVisibilityCheckScheduler != null) {
            this.mSdkVisibilityCheckScheduler.startVisibilityMonitoring();
        }
    }

    void stopVisibilityCheck() {
        if (this.mSdkVisibilityCheckScheduler != null) {
            this.mSdkVisibilityCheckScheduler.stopVisibilityMonitoring();
        }
    }

    void checkVisibility() {
        if (this.isVisible()) {
            this.mRecommendationItem.onViewVisible();
            this.stopVisibilityCheck();
            this.mSdkVisibilityCheckScheduler = null;
        }
    }

    private boolean isVisible() {
        int visiblePercent = VisibilityUtil.getVisiblePercent((View)this);
        return visiblePercent >= 99;
    }

    void setRecommendationItem(TBRecommendationItem recommendationItem) {
        this.mRecommendationItem = recommendationItem;
    }
}

