/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils.network;

import android.util.Base64;
import com.taboola.android.utils.Logger;
import com.taboola.lightnetwork.url_components.UrlParameter;
import com.taboola.lightnetwork.url_components.UrlParameters;
import java.io.UnsupportedEncodingException;

public class OptionalPageCommands
extends UrlParameters {
    private static final String TAG = "OptionalPageCommands";
    private boolean mIsOnlineTemplate;

    public OptionalPageCommands(boolean isOnlineTemplate) {
        this.mIsOnlineTemplate = isOnlineTemplate;
    }

    public void setOnlineTemplate(boolean onlineTemplate) {
        this.mIsOnlineTemplate = onlineTemplate;
    }

    public String getCommandString() {
        if (this.mParameters.isEmpty()) {
            return "";
        }
        return this.mIsOnlineTemplate ? this.getOnlineTemplateCommandString() : this.getLocalTemplateCommandString();
    }

    private String getLocalTemplateCommandString() {
        StringBuilder retVal = new StringBuilder();
        retVal.append("_taboola.push(").append(this.commandToLocalString()).append(");");
        Logger.d(TAG, "getCommandsString  " + retVal.toString());
        return retVal.toString();
    }

    private String commandToLocalString() {
        StringBuilder retValue = new StringBuilder();
        boolean isFirst = true;
        for (UrlParameter parameter : this.mParameters) {
            if (!isFirst) {
                retValue.append(",");
            } else {
                isFirst = false;
            }
            retValue.append(parameter.mKey).append(":'").append(parameter.mValue).append("'");
        }
        Logger.d(TAG, " commandToLocalString   {" + retValue.toString() + "}");
        return "{" + retValue.toString() + "}";
    }

    private String getOnlineTemplateCommandString() {
        try {
            String optionalPageCommandsString = super.toString();
            Logger.d(TAG, "OptionalPageCommands | OptionalPageCommands() | optionalPageCommandsString (pre Base64) = " + optionalPageCommandsString);
            byte[] optionalPageCommandsByteArr = optionalPageCommandsString.getBytes("UTF-8");
            return Base64.encodeToString((byte[])optionalPageCommandsByteArr, (int)0);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Logger.d(TAG, "TaboolaWidget | getCommandsString() | There was an issue, returning empty String.");
            return "";
        }
    }

    @Override
    public String toString() {
        if (this.mIsOnlineTemplate) {
            return super.toString();
        }
        return this.getLocalTemplateCommandString();
    }
}

