/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.utility.IVLogger;
import com.taboola.android.integration_verifier.utility.IntegrationTypeNameParser;
import com.taboola.android.utils.PermissionUtils;
import java.util.ArrayList;

public class PermissionsVerificationTest
extends VerificationTest {
    private static final String TEST_NAME = "PermissionsVerification";
    public static final String KEY_PERMISSIONS_LIST = "permissionsVerification_key_permissions_list";
    public static final String INTERNET_PERMISSION = "android.permission.INTERNET";
    public static final String ACCESS_NETWORK_STATE_PERMISSION = "android.permission.ACCESS_NETWORK_STATE";
    private boolean allPermissionsGranted = true;
    private StringBuilder stringBuilder = new StringBuilder("PermissionsVerificationTest | The following Taboola Permissions were not asked or permission was not granted: ");

    public PermissionsVerificationTest(int id, boolean isMandatory) {
        super(id, isMandatory);
    }

    @Override
    public void execute(@Nullable Context context, @Nullable Bundle bundle, @NonNull VerificationTest.TestResults testResults) {
        boolean success = this.areAllTaboolaPermissionsGranted(context, bundle);
        if (success) {
            testResults.onSuccess();
        } else {
            testResults.onFail(this.isMandatory());
        }
    }

    private boolean areAllTaboolaPermissionsGranted(Context context, Bundle bundle) {
        ArrayList permissionsToCheck = bundle.getStringArrayList(KEY_PERMISSIONS_LIST);
        for (String permission2 : permissionsToCheck) {
            if (PermissionUtils.isPermissionGranted(context, permission2)) continue;
            this.allPermissionsGranted = false;
            this.stringBuilder.append(permission2 + " ");
        }
        IVLogger.log("PermissionsVerificationTest | execute() | areAllTaboolaPermissionsGranted() | allPermissionsGranted = " + this.allPermissionsGranted);
        return this.allPermissionsGranted;
    }

    @Override
    public VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle bundle) {
        VerificationOutputTargets verificationOutputTargets = new VerificationOutputTargets(new VerificationOutputTarget[0]);
        Bundle consoleBundle = new Bundle();
        String failMessage = this.stringBuilder.toString();
        consoleBundle.putString("consoleOutput_key_log_error_string", failMessage);
        verificationOutputTargets.add(new VerificationOutputTarget(2, consoleBundle));
        verificationOutputTargets.add(new VerificationOutputTarget(3, this.getKibanaBundle(IntegrationTypeNameParser.getNameFor(bundle.getInt("integration_verifier_key_integrationType")), TEST_NAME, failMessage)));
        return verificationOutputTargets;
    }
}

