/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.handlers;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Keep;
import android.text.TextUtils;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.OnClickHelper;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import java.util.HashMap;

@Keep
public class TrackingHandler {
    private static final String TAG = TrackingHandler.class.getSimpleName();
    private static final String PRE_CLICK_BASE_URL = "https://tracking.taboola.com/mobile/%s/click/pre-click";
    private HttpManager mHttpManager;

    public void setHttpManager(HttpManager httpManager) {
        this.mHttpManager = httpManager;
    }

    public void reportPreClick(Context applicationContext, String publisherId, String clickUrl, String sdkType) {
        if (applicationContext == null) {
            Logger.e(TAG, "reportPreClick | Cannot report, context is null.");
            return;
        }
        String expectedBrowser = SdkDetailsHelper.getDefaultBrowser(applicationContext);
        if (TextUtils.isEmpty((CharSequence)expectedBrowser)) {
            expectedBrowser = "undefined";
        } else if (OnClickHelper.areChromeCustomTabsSupported(applicationContext)) {
            expectedBrowser = expectedBrowser + " (Custom tab)";
        }
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("cache-control", "no-cache");
        requestHeaders.put("x-tracking-click-url", clickUrl);
        requestHeaders.put("x-tracking-expected-post-click-browser", expectedBrowser);
        requestHeaders.put("x-tracking-os", "Android");
        requestHeaders.put("x-tracking-os-version", Build.VERSION.RELEASE);
        requestHeaders.put("x-tracking-sdk-type", sdkType);
        requestHeaders.put("x-tracking-sdk-version", "2.3.4-48420-5");
        this.mHttpManager.get(String.format(PRE_CLICK_BASE_URL, publisherId), requestHeaders, null, null, null);
    }
}

