/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.eventsmanager;

import android.content.Context;
import android.support.annotation.Nullable;
import com.taboola.android.PublisherInfo;
import com.taboola.android.global_components.eventsmanager.EventQueue;
import com.taboola.android.global_components.eventsmanager.SessionInfo;
import com.taboola.android.global_components.eventsmanager.events.TaboolaEvent;
import com.taboola.android.global_components.eventsmanager.events.TaboolaMobileEvent;
import com.taboola.android.global_components.eventsmanager.session.GetSessionListener;
import com.taboola.android.global_components.eventsmanager.session.ReportEventsSessionManager;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.utils.Logger;

public class EventsManager {
    private static final String TAG = EventsManager.class.getSimpleName();
    private static final int INVALID_QUEUE_SIZE = -1;
    private NetworkManager mNetworkManager;
    private EventQueue mEventQueue;
    private ReportEventsSessionManager mSessionManager;
    private boolean mIsEnabled = true;

    public EventsManager(Context context, NetworkManager networkManager) {
        this(networkManager, new EventQueue(context));
    }

    public EventsManager(NetworkManager networkManager, EventQueue eventQueue) {
        this.mNetworkManager = networkManager;
        this.mEventQueue = eventQueue;
        this.mSessionManager = new ReportEventsSessionManager(networkManager);
        this.mEventQueue.loadQueue();
    }

    public synchronized void reportTaboolaMobileEvent(final PublisherInfo publisherInfo, @Nullable SessionInfo callingSessionInfo, final TaboolaMobileEvent ... events) {
        if (!this.mIsEnabled) {
            return;
        }
        if (publisherInfo == null) {
            Logger.e(TAG, "Cannot report events, publisherInfo is null. Did you call Taboola.init()?");
            return;
        }
        this.mSessionManager.getSession(publisherInfo, callingSessionInfo, new GetSessionListener(){

            @Override
            public void onSessionRetrieved(SessionInfo sessionInfo) {
                for (TaboolaMobileEvent event : events) {
                    if (event == null) continue;
                    event.setSessionId(sessionInfo.getSessionId());
                    event.setResponseId(sessionInfo.getResponseId());
                    event.setPublisherId(publisherInfo.getPublisherId());
                    event.setApiKey(publisherInfo.getApiKey());
                }
                EventsManager.this.reportEvent(events);
            }
        });
    }

    public synchronized void reportEvent(TaboolaEvent ... events) {
        if (!this.mIsEnabled) {
            return;
        }
        this.mEventQueue.addEvent(events);
        this.sendEventsInQueue();
    }

    public synchronized void sendEventsInQueue() {
        if (!this.mIsEnabled) {
            return;
        }
        int queueSize = this.mEventQueue.size();
        for (int i = 0; i < queueSize; ++i) {
            final TaboolaEvent currentTaboolaEvent = this.mEventQueue.popFirstEvent();
            if (currentTaboolaEvent == null) continue;
            currentTaboolaEvent.sendEvent(this.mNetworkManager, new TaboolaEvent.SendEventCallback(){

                @Override
                public void onSuccess() {
                    Logger.d(TAG, "Event sent successfully.");
                }

                @Override
                public void onFailure() {
                    Logger.d(TAG, "Failed sending event, adding back to queue.");
                    EventsManager.this.mEventQueue.addEvent(currentTaboolaEvent);
                }
            });
        }
    }

    public synchronized void clearEventsInQueue() {
        this.mEventQueue.clear();
    }

    public synchronized int getQueueSize() {
        return this.mEventQueue == null ? -1 : this.mEventQueue.size();
    }

    public synchronized void setsQueueMaxSize(int queueMaxSize) {
        if (this.mEventQueue != null) {
            this.mEventQueue.setMaxSize(queueMaxSize);
        }
    }

    public synchronized int getQueueMaxSize() {
        return this.mEventQueue.getMaxSize();
    }

    public synchronized void toggleEventsManager(boolean enable) {
        this.mIsEnabled = enable;
    }
}

