/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RequiresPermission;
import com.taboola.android.global_components.TaboolaContextManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.PermissionUtils;

@Keep
public class State {
    private static final String TAG = State.class.getSimpleName();
    private final Context mContext = TaboolaContextManager.getInstance().getApplicationContext();

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnected() {
        if (Build.VERSION.SDK_INT >= 28) {
            return this.isConnected_Q();
        }
        return this.isConnected_preQ();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnectedThroughWifi() {
        if (Build.VERSION.SDK_INT >= 28) {
            return this.isConnectedThroughWifi_Q();
        }
        return this.isConnectedThroughWifi_preQ();
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(api=21)
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private boolean isConnected_Q() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        if (connectivityManager != null) {
            Network activeNetwork = connectivityManager.getActiveNetwork();
            if (activeNetwork == null) {
                return false;
            }
            NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(activeNetwork);
            if (networkCapabilities != null && this.isConnectionValidated(networkCapabilities)) {
                return true;
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private boolean isConnected_preQ() {
        if (this.checkNetworkStatePermission()) {
            return false;
        }
        NetworkInfo activeNetworkInfo = this.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(api=21)
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private boolean isConnectedThroughWifi_Q() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        if (connectivityManager != null) {
            Network activeNetwork = connectivityManager.getActiveNetwork();
            if (activeNetwork == null) {
                return false;
            }
            NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(activeNetwork);
            if (networkCapabilities != null && this.isConnectionValidated(networkCapabilities) && this.isWifiTypeConnection(networkCapabilities)) {
                return true;
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private boolean isConnectedThroughWifi_preQ() {
        if (this.checkNetworkStatePermission()) {
            return false;
        }
        NetworkInfo activeNetworkInfo = this.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected() && activeNetworkInfo.getType() == 1;
    }

    @RequiresApi(api=21)
    private boolean isWifiTypeConnection(NetworkCapabilities networkCapabilities) {
        return networkCapabilities.hasTransport(1);
    }

    @RequiresApi(api=23)
    private boolean isConnectionValidated(NetworkCapabilities networkCapabilities) {
        return networkCapabilities.hasCapability(16);
    }

    private boolean checkNetworkStatePermission() {
        if (!PermissionUtils.isPermissionGranted(this.mContext, "android.permission.ACCESS_NETWORK_STATE")) {
            Logger.d(TAG, "isConnected() | Failed to check connectivity, ACCESS_NETWORK_STATE permission not asked or granted.");
            return true;
        }
        return false;
    }

    @Nullable
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private NetworkInfo getActiveNetworkInfo() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        return connectivityManager == null ? null : connectivityManager.getActiveNetworkInfo();
    }
}

