/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.utility.IVLogger;
import com.taboola.android.integration_verifier.utility.IntegrationTypeNameParser;
import com.taboola.android.utils.BuildUtils;

public class AlertReleaseVerificationTest
extends VerificationTest {
    private static final String WARNING_MESSAGE = "AlertReleaseVerificationTest | If this application instance is built for release you might want to consider turning IntegrationVerifier off.";
    private static final String TEST_NAME = "AlertReleaseVerification";

    public AlertReleaseVerificationTest(int id, boolean isMandatory) {
        super(id, isMandatory);
    }

    @Override
    public void execute(@Nullable Context context, @Nullable Bundle bundle, @NonNull VerificationTest.TestResults testResults) {
        IVLogger.log("AlertReleaseVerificationTest | isHostAppInDebugMode | Checking if app is in debug mode..");
        if (context == null) {
            IVLogger.log("AlertReleaseVerificationTest | execute | context is null");
            testResults.onUnavailable();
            return;
        }
        boolean success = BuildUtils.isHostAppInDebugMode(context);
        if (success) {
            testResults.onSuccess();
        } else {
            testResults.onFail(this.isMandatory());
        }
    }

    @Override
    public VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle bundle) {
        VerificationOutputTargets verificationOutputTargets = new VerificationOutputTargets(new VerificationOutputTarget[0]);
        Bundle consoleBundle = new Bundle();
        consoleBundle.putString("consoleOutput_key_log_error_string", WARNING_MESSAGE);
        verificationOutputTargets.add(new VerificationOutputTarget(2, consoleBundle));
        verificationOutputTargets.add(new VerificationOutputTarget(3, this.getKibanaBundle(IntegrationTypeNameParser.getNameFor(bundle.getInt("integration_verifier_key_integrationType")), TEST_NAME, WARNING_MESSAGE)));
        return verificationOutputTargets;
    }
}

