/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests.extra_property_values;

import android.text.TextUtils;
import com.taboola.android.utils.ExtraProperty;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtraPropertyTester {
    public boolean isValueInAcceptableRange(String key, String value) {
        ExtraProperty extraProperty = ExtraProperty.getExtraProperty(key);
        switch (extraProperty) {
            case OVERRIDE_IMAGE_LOAD: 
            case ENABLE_HORIZONTAL_SCROLL_PROP: 
            case ENABLE_RAW_PROP_FULL: 
            case ENABLE_RAW_DATA_PROP: 
            case ALLOW_NON_ORGANIC_OVERRIDE_PROP: 
            case USE_HTTP_PROP: 
            case KEEP_DEPENDENCIES_PROP: 
            case SET_GUEH: 
            case FORCE_FIXED_HEIGHT: {
                return this.isValidBoolean(value);
            }
            case FEATURE_FORCE_CLICK_ON_APP: {
                return this.isValidPackageName(value);
            }
            case API_PARAMS: {
                return this.isValidKeyValueChain(value);
            }
            case HOST_NAME: {
                return this.isValidURI(value);
            }
        }
        return true;
    }

    private boolean isValidBoolean(String booleanString) {
        if (TextUtils.isEmpty((CharSequence)booleanString)) {
            return false;
        }
        return booleanString.toLowerCase().equals("false") || booleanString.toLowerCase().equals("true");
    }

    private boolean isValidPackageName(String value) {
        return this.doesStringMatchPattern("^([A-Za-z]{1}[A-Za-z\\d_]*\\.)+[A-Za-z][A-Za-z\\d_]*$", value);
    }

    private boolean isValidKeyValueChain(String value) {
        return this.doesStringMatchPattern("^((\\w*)[\\=]{1}(\\w*)){1}(\\&(\\w*)[\\=]{1}(\\w*))*$", value);
    }

    private boolean doesStringMatchPattern(String patternString, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        Pattern pattern = Pattern.compile(patternString);
        Matcher m = pattern.matcher(string);
        return m.find();
    }

    private boolean isValidURI(String value) {
        try {
            new URI(value);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    public boolean isKeyKnown(String key) {
        return ExtraProperty.getExtraProperty(key) != ExtraProperty.UNRECOGNIZABLE;
    }
}

