/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.taboola.android.GLHelper;
import com.taboola.android.OnScrollChangedListenerImpl;
import com.taboola.android.R;
import com.taboola.android.Taboola;
import com.taboola.android.TaboolaInterfaceComponent;
import com.taboola.android.TaboolaWebView;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.integration_verifier.requests.VerificationRequest;
import com.taboola.android.integration_verifier.testing.TestIDs;
import com.taboola.android.integration_verifier.testing.tests.publisher_config.PublisherConfigParams_STD;
import com.taboola.android.js.OnRenderListener;
import com.taboola.android.js.OnResizeListener;
import com.taboola.android.js.TaboolaJs;
import com.taboola.android.listeners.MediationEventListener;
import com.taboola.android.listeners.TaboolaDetectAdEventsListener;
import com.taboola.android.listeners.TaboolaEventListener;
import com.taboola.android.listeners.TaboolaUserActionListener;
import com.taboola.android.utils.AssetUtil;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.OnClickHelper;
import com.taboola.android.utils.PropertiesHashed;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.android.utils.StringUtil;
import com.taboola.android.utils.TaboolaSerializable;
import com.taboola.android.utils.VisibilityUtil;
import com.taboola.android.utils.network.OptionalPageCommands;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;

@Keep
public class TaboolaWidget
extends TaboolaWebView
implements TaboolaInterfaceComponent {
    private static final String TAG = TaboolaWidget.class.getSimpleName();
    private static final String HTML_TEMPLATE_FILE_NAME = "template.html";
    private static final String CUSTOM_TAB_PACKAGE_NAME = "com.android.chrome";
    private static int sMaxWidgetSizeGpu = 0;
    private CustomTabsClient mCustomTabsClient = null;
    private CustomTabsSession mCustomTabsSession = null;
    private CustomTabsServiceConnection mCustomTabsServiceConnection = null;
    private TaboolaEventListener mEventListener;
    private TaboolaDetectAdEventsListener mTaboolaDetectAdEventsListener;
    private MediationEventListener mMediationEventListener;
    private boolean mHasDispatchedLoadEvent = false;
    private boolean mShouldAllowNonOrganicClickOverride = false;
    private boolean mShouldKeepDependencies = false;
    private boolean isChromeTabLaunched = false;
    private boolean isContextActivity = false;
    private boolean isCustomTabsSupported = false;
    private boolean shouldCheckCacheSize = false;
    private OptionalPageCommands mOptionalPageCommands;
    private boolean mIsItemClickEnabled;
    private String mPublisher;
    private String mMode;
    private String mPlacement;
    private String mPageType;
    private String mTargetType;
    private String mPageId;
    private String mPageUrl;
    private String mWidgetStyle;
    private String mFramework;
    private String mViewID;
    private String mProgressBarColor;
    private float mProgressBarDuration = -1.0f;
    @Nullable
    private String mMediatedVia;
    private boolean mIsScrollEnabled;
    private boolean mIsAutoResizeHeight;
    private int mScreenMaxHeight;
    private int mWidgetMaxHeight;
    private IntegrationVerifier integrationVerifier;
    private Handler mInvalidationHandler;
    private ViewTreeObserver.OnScrollChangedListener mOnScrollChangedListener;
    private OnScrollChangedListenerImpl mScrollChangedListenerImpl;
    private boolean shouldIgnoreScrollEvents = false;
    private OnAttachStateChangeListenerImpl mOnAttachStateChangeListener;
    private Integer mInitalHeight;

    public TaboolaWidget(Context context) {
        super(context);
        this.initWidgetSettings();
    }

    public TaboolaWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initWidgetSettings();
        this.parseXmlAttributes(context, attrs);
        Logger.d(TAG, "initialized basic components");
    }

    public TaboolaWidget(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initWidgetSettings();
        this.parseXmlAttributes(context, attrs);
        Logger.d(TAG, "initialized basic components");
    }

    private void initWidgetSettings() {
        if (IntegrationVerifier.isEnabled()) {
            this.integrationVerifier = Taboola.getTaboolaImpl().getIntegrationVerifier();
        }
        Context context = this.getContext();
        this.isContextActivity = context instanceof Activity;
        this.isCustomTabsSupported = OnClickHelper.areChromeCustomTabsSupported(context);
        if (!this.isContextActivity) {
            Logger.w(TAG, "Widget should be created using Activity context if possible");
        }
        TaboolaJs.getInstance().setLogLevel(Logger.getLogLevel());
        this.updateMaxWidgetSize();
        this.mScreenMaxHeight = SdkDetailsHelper.getDisplayHeight(context) * 2;
        this.setDefValues();
        this.mOptionalPageCommands = new OptionalPageCommands(this.mIsOnline);
        this.setSaveEnabled(true);
        this.setWillNotDraw(false);
        this.setBackgroundColor(0);
        this.getSettings().setLoadsImagesAutomatically(true);
        this.getSettings().setLoadWithOverviewMode(true);
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setUseWideViewPort(true);
        this.setWebViewClient(this.getWebViewClient());
        this.setWebChromeClient(this.getWebChromeClient());
        this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        this.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
        this.getSettings().setCacheMode(1);
        if (Build.VERSION.SDK_INT >= 19) {
            this.setLayerType(2, null);
        } else {
            this.setLayerType(1, null);
            this.shouldCheckCacheSize = true;
        }
        if (Build.VERSION.SDK_INT >= 19 && Logger.getLogLevel() <= 3) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        Logger.d(TAG, "initWebView :: initialized WebView");
        this.initTaboolaJS();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initTaboolaJS() {
        Context context = this.getContext();
        TaboolaJs.getInstance().init(context.getApplicationContext(), true);
        CookieManager.getInstance().setAcceptCookie(true);
        this.updateScrollBehaviour();
        TaboolaJs.getInstance().registerWebView(this);
        TaboolaJs.getInstance().setOnRenderListener(this, new OnRenderListener(){

            @Override
            public void onRenderSuccessful(WebView webView, String placementName, int height) {
                if (Build.VERSION.SDK_INT <= 19) {
                    TaboolaWidget.this.startInvalidationOnScrollEvents();
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            TaboolaWidget.this.invalidateWebView();
                        }
                    }, 3000L);
                }
                Log.d((String)TAG, (String)("onRenderSuccessful: " + placementName));
                TaboolaWidget.this.dispatchLoadSuccessful();
            }

            @Override
            public void onRenderFailed(WebView webView, String placementName, String errorMessage) {
                Log.e((String)TAG, (String)("onRenderFailed: " + placementName + " " + errorMessage));
                TaboolaWidget.this.dispatchLoadFailed(errorMessage);
            }
        });
        TaboolaJs.getInstance().setOnResizeListener(this, new OnResizeListener(){

            @Override
            public void onResize(WebView webView, String placementName, int height) {
                int heightPx = VisibilityUtil.convertCssPixelToPixel(height);
                TaboolaWidget.this.resizeWidget(heightPx);
            }
        });
    }

    @Override
    protected void clearDependencies() {
        super.clearDependencies();
        this.mShouldKeepDependencies = false;
        if (this.mOnAttachStateChangeListener != null) {
            this.mOnAttachStateChangeListener.clear();
            this.mOnAttachStateChangeListener = null;
        }
        if (this.mScrollChangedListenerImpl != null) {
            this.mScrollChangedListenerImpl.removeListener(this.mOnScrollChangedListener);
        }
        this.clearScrollChangeListener();
        TaboolaJs.getInstance().unregisterWebView(this);
        TaboolaJs.getInstance().setOnClickListener(this, null);
        TaboolaJs.getInstance().setTaboolaUserActionListener(null);
        if (IntegrationVerifier.isEnabled()) {
            this.integrationVerifier.getTestsManager().getMethodCallOrderTracker().clearTrackedMethods(1);
            this.integrationVerifier.clearStatusReport();
        }
        this.mEventListener = null;
        this.mTaboolaDetectAdEventsListener = null;
        this.mMediationEventListener = null;
    }

    private void parseXmlAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TaboolaWidget, 0, 0);
        String pageType = a.getString(R.styleable.TaboolaWidget_pageType);
        String targetType = a.getString(R.styleable.TaboolaWidget_targetType);
        String pageUrl = a.getString(R.styleable.TaboolaWidget_pageUrl);
        this.setAutoResizeHeight(a.getBoolean(R.styleable.TaboolaWidget_autoResizeHeight, this.mIsAutoResizeHeight));
        this.setScrollEnabled(a.getBoolean(R.styleable.TaboolaWidget_scrollEnabled, this.mIsScrollEnabled));
        this.setProgressBarEnabled(a.getBoolean(R.styleable.TaboolaWidget_progressBarEnabled, this.mProgressBarEnabled));
        this.setProgressBarColor(a.getColor(R.styleable.TaboolaWidget_progressBarColor, -1));
        this.setProgressBarDuration(a.getFloat(R.styleable.TaboolaWidget_progressBarDuration, this.mProgressBarDuration));
        this.setItemClickEnabled(a.getBoolean(R.styleable.TaboolaWidget_itemClickEnabled, this.mIsItemClickEnabled));
        String newPageType = a.getString(R.styleable.TaboolaWidget_page_type);
        String newTargetType = a.getString(R.styleable.TaboolaWidget_target_type);
        String newPageUrl = a.getString(R.styleable.TaboolaWidget_url);
        if (newPageType != null) {
            pageType = newPageType;
        }
        if (newTargetType != null) {
            targetType = newTargetType;
        }
        if (newPageUrl != null) {
            pageUrl = newPageUrl;
        }
        String mode = a.getString(R.styleable.TaboolaWidget_mode);
        String publisher = a.getString(R.styleable.TaboolaWidget_publisher);
        String placement = a.getString(R.styleable.TaboolaWidget_placement);
        this.setAutoResizeHeight(a.getBoolean(R.styleable.TaboolaWidget_auto_resize_height, this.mIsAutoResizeHeight));
        this.setScrollEnabled(a.getBoolean(R.styleable.TaboolaWidget_scroll_enabled, this.mIsScrollEnabled));
        this.setItemClickEnabled(a.getBoolean(R.styleable.TaboolaWidget_item_click_enabled, this.mIsItemClickEnabled));
        if (pageType != null) {
            this.setPageType(pageType);
        }
        if (targetType != null) {
            this.setTargetType(targetType);
        }
        if (pageUrl != null) {
            this.setPageUrl(pageUrl);
        }
        if (mode != null) {
            this.setMode(mode);
        }
        if (publisher != null) {
            this.setPublisher(publisher);
        }
        if (placement != null) {
            this.setPlacement(placement);
        }
        a.recycle();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Logger.d(TAG, "onAttachedToWindow");
        this.bindCustomTabsService();
        if (this.mScrollviewParent != null && this.mOnAttachStateChangeListener == null) {
            this.mOnAttachStateChangeListener = new OnAttachStateChangeListenerImpl(this);
            this.mScrollviewParent.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this.mOnAttachStateChangeListener);
            this.mShouldKeepDependencies = true;
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.mShouldKeepDependencies) {
            this.clearDependencies();
        }
        Logger.d(TAG, "onDetachedFromWindow");
        this.unbindCustomTabsService();
        super.onDetachedFromWindow();
    }

    public void onDestroy() {
        this.clearDependencies();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (this.isChromeTabLaunched && visibility == 0) {
            if (this.mMediationEventListener != null) {
                this.mMediationEventListener.onAdClosed();
            }
            this.isChromeTabLaunched = false;
        }
    }

    public TaboolaWidget fetchContent() {
        if (IntegrationVerifier.isEnabled()) {
            this.integrationVerifier.getTestsManager().getMethodCallOrderTracker().rememberNonInitApiMethodCall(1, "fetchContent");
            Bundle crawlUrlBundle = new Bundle();
            crawlUrlBundle.putSerializable("crawlingUrlTest_key_crawling_url", (Serializable)((Object)this.mPageUrl));
            crawlUrlBundle.putInt("integration_verifier_key_integrationType", 1);
            this.integrationVerifier.verify(new VerificationRequest(this.getContext(), crawlUrlBundle, new TestIDs(8)));
        }
        if (this.mViewID == null) {
            this.setViewId(null);
        }
        Logger.d(TAG, "publisher[" + this.mPublisher + "] mode[" + this.mMode + "] placement[" + this.mPlacement + "] pageType[" + this.mPageType + "] pageUrl[" + this.mPageUrl + "] viewID[" + this.mViewID + "]");
        HashMap<String, String> extraProperties = new HashMap<String, String>();
        extraProperties.put("allowNonOrganicClickOverride", this.mShouldAllowNonOrganicClickOverride ? "true" : "false");
        extraProperties.put("isUsedInTaboolaWidget", "true");
        extraProperties.put("mediatedVia", this.mMediatedVia);
        TaboolaJs.getInstance().setExtraProperties(this, extraProperties);
        if (IntegrationVerifier.isEnabled()) {
            this.verifyConfigParams();
        }
        this.notifyFetchContent();
        if (this.getUrl() != null && this.mIsOnline) {
            this.mHasDispatchedLoadEvent = false;
            this.reload();
        } else if (this.hasMinimalAttributes()) {
            this.clearWebView();
            this.mHasDispatchedLoadEvent = false;
            this.loadWebView();
        } else {
            String message = "Required parameters are not set";
            Logger.e(TAG, message);
            this.dispatchLoadFailed(message);
        }
        return this;
    }

    private void verifyConfigParams() {
        Bundle verifyJsParamsBundle = new Bundle();
        verifyJsParamsBundle.putSerializable("publisherConfigurationTest_key_configuration_params", (Serializable)new PublisherConfigParams_STD(this.mPublisher, this.mMode, this.mPlacement, this.mPageType, this.mTargetType));
        verifyJsParamsBundle.putInt("integration_verifier_key_integrationType", 1);
        this.integrationVerifier.verify(new VerificationRequest(verifyJsParamsBundle, new TestIDs(6, 7)));
    }

    private void notifyFetchContent() {
        if (TaboolaJs.getInstance().isSdkMonitorEnabled()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("publisher", this.mPublisher);
            parameters.put("mode", this.mMode);
            parameters.put("placement", this.mPlacement);
            parameters.put("pageType", this.mPageType);
            parameters.put("targetType", this.mTargetType);
            parameters.put("pageId", this.mPageId);
            parameters.put("pageUrl", this.mPageUrl);
            parameters.put("viewID", this.mViewID);
            parameters.put("framework", this.mFramework);
            parameters.put("commandsString", this.mOptionalPageCommands.toString());
            parameters.put("allowNonOrganicClickOverride", String.valueOf(this.mShouldAllowNonOrganicClickOverride));
            parameters.put("keepDependencies", String.valueOf(this.mShouldKeepDependencies));
            TaboolaJs.getInstance().sendFetchContentParamsToMonitor(this, this.mPlacement, parameters);
        }
    }

    public TaboolaWidget refresh() {
        this.fetchContent();
        return this;
    }

    public TaboolaWidget reset() {
        this.setDefValues();
        this.clearWebView();
        return this;
    }

    private void clearWebView() {
        this.loadUrl("about:blank");
        this.clearHistory();
    }

    private void loadWebView() {
        if (this.mIsOnline) {
            this.loadWebViewOnline();
            return;
        }
        String baseUrl = "https://cdn.taboola.com/mobile-sdk/init/";
        String commandsString = this.mOptionalPageCommands.getCommandString();
        String html = String.format(AssetUtil.getHtmlTemplateFileContent(this.getContext(), HTML_TEMPLATE_FILE_NAME), this.mPublisher, this.mWidgetStyle, commandsString, this.mPageType, this.mPageId, this.mPageUrl, this.mMode, this.mPlacement, this.mFramework, this.mTargetType, this.mPublisher, this.mViewID);
        Logger.d(TAG, "loadWebView html:\n" + html);
        this.mHasDispatchedLoadEvent = false;
        this.loadDataWithBaseURL(baseUrl, html, "text/html", "utf-8", null);
    }

    private void dispatchLoadSuccessful() {
        if (!this.mHasDispatchedLoadEvent) {
            this.mHasDispatchedLoadEvent = true;
            if (this.mTaboolaDetectAdEventsListener != null) {
                this.mTaboolaDetectAdEventsListener.onTaboolaDidReceiveAd(this);
            }
            if (this.mMediationEventListener != null) {
                this.mMediationEventListener.onAdLoaded();
            }
            this.postGlobalNotification("TABOOLA_DID_RECEIVE_AD", this, null);
        }
    }

    private void dispatchLoadFailed(String description) {
        if (!this.mHasDispatchedLoadEvent) {
            this.mHasDispatchedLoadEvent = true;
            if (this.mTaboolaDetectAdEventsListener != null) {
                this.mTaboolaDetectAdEventsListener.onTaboolaDidFailAd(description);
            }
            if (this.mMediationEventListener != null) {
                this.mMediationEventListener.onAdFailedToLoad(description);
            }
            this.postGlobalNotification("TABOOLA_DID_FAIL_AD", this, description);
        }
    }

    private void postGlobalNotification(String message, TaboolaWidget taboolaWidget, @Nullable Object value) {
        Intent intent = new Intent("com.taboola.android.GLOBAL_NOTIFICATIONS_KEY");
        intent.putExtra("GLOBAL_NOTIFICATIONS_MESSAGES_KEY", message);
        TaboolaSerializable taboolaSerializable = new TaboolaSerializable();
        taboolaSerializable.setTaboolaWidget(taboolaWidget);
        intent.putExtra("GLOBAL_NOTIFICATIONS_WIDGET_KEY", (Serializable)taboolaSerializable);
        switch (message) {
            case "TABOOLA_VIEW_RESIZED": {
                intent.putExtra("GLOBAL_NOTIFICATIONS_VALUE_KEY", ((Integer)value).intValue());
                break;
            }
            case "TABOOLA_DID_FAIL_AD": {
                intent.putExtra("GLOBAL_NOTIFICATIONS_VALUE_KEY", (String)value);
            }
        }
        LocalBroadcastManager.getInstance((Context)this.getContext()).sendBroadcast(intent);
        Logger.d(TAG, "post global notification " + message);
    }

    private void resizeWidget(final int heightPx) {
        Integer viewHeight;
        Logger.d(TAG, "resizeWidget(" + heightPx + ")");
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        Integer n = viewHeight = layoutParams != null ? Integer.valueOf(layoutParams.height) : null;
        if (this.mInitalHeight == null) {
            this.mInitalHeight = viewHeight != null ? viewHeight : -2;
        }
        if (sMaxWidgetSizeGpu == 0) {
            Log.d((String)TAG, (String)"resizeWidget: postponing resizing until max widget size is resolved");
            Handler mainHandler = new Handler(this.getContext().getMainLooper());
            mainHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    TaboolaWidget.this.resizeWidget(heightPx);
                }
            }, 500L);
            return;
        }
        if (this.mWidgetMaxHeight == 0) {
            this.mWidgetMaxHeight = Math.min(sMaxWidgetSizeGpu, this.mScreenMaxHeight);
        }
        if (this.mInitalHeight < 0) {
            viewHeight = this.mInitalHeight;
        }
        int heightLimit = viewHeight != null && viewHeight > 0 ? Math.min(viewHeight, this.mWidgetMaxHeight) : this.mWidgetMaxHeight;
        boolean forceAutoResize = false;
        int actualHeightPx = heightPx;
        if (heightPx > heightLimit) {
            actualHeightPx = heightLimit;
            forceAutoResize = true;
        }
        if (forceAutoResize) {
            this.setScrollEnabled(true);
        }
        if (forceAutoResize || this.isAutoResizeHeight()) {
            ViewGroup.LayoutParams params = layoutParams;
            if (params != null) {
                params.height = actualHeightPx;
            } else {
                params = new ViewGroup.LayoutParams(-1, actualHeightPx);
            }
            this.setLayoutParams(params);
            Logger.d(TAG, "resized widget height to " + actualHeightPx + " px");
            this.postGlobalNotification("TABOOLA_VIEW_RESIZED", this, actualHeightPx);
            if (this.getTaboolaEventListener() != null) {
                this.getTaboolaEventListener().taboolaViewResizeHandler(this, actualHeightPx);
            }
        }
        if (this.shouldCheckCacheSize && this.isCacheTooSmall(actualHeightPx)) {
            this.setLayerType(0, null);
            this.shouldCheckCacheSize = false;
            this.fetchContent();
        }
    }

    private boolean isCacheTooSmall(int heightPx) {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        if (wm != null) {
            DisplayMetrics metrics = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(metrics);
            long bmpSize = metrics.widthPixels * heightPx * 4;
            long maxCache = ViewConfiguration.get((Context)this.getContext()).getScaledMaximumDrawingCacheSize();
            return bmpSize > maxCache;
        }
        return false;
    }

    private int dpToPx(int dp) {
        float density = this.getResources().getDisplayMetrics().density;
        return Math.round((float)dp * density);
    }

    private void bindCustomTabsService() {
        try {
            this.mCustomTabsServiceConnection = new CustomTabsServiceConnection(){

                public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
                    TaboolaWidget.this.mCustomTabsClient = client;
                    if (TaboolaWidget.this.mCustomTabsClient != null) {
                        TaboolaWidget.this.mCustomTabsClient.warmup(0L);
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    TaboolaWidget.this.mCustomTabsClient = null;
                }
            };
            CustomTabsClient.bindCustomTabsService((Context)this.getContext(), (String)CUSTOM_TAB_PACKAGE_NAME, (CustomTabsServiceConnection)this.mCustomTabsServiceConnection);
        }
        catch (Exception e) {
            Logger.e(TAG, "bindCustomTabsService :: failed bind custom tab service : " + e.toString());
        }
    }

    private void unbindCustomTabsService() {
        if (this.mCustomTabsServiceConnection == null) {
            return;
        }
        if (this.isContextActivity) {
            try {
                this.getContext().unbindService((ServiceConnection)this.mCustomTabsServiceConnection);
            }
            catch (Exception e) {
                Logger.e(TAG, "unbindCustomTabsService :: failed to unbind custom tab service : " + e.toString());
            }
        }
        this.mCustomTabsServiceConnection = null;
        this.mCustomTabsSession = null;
        this.mCustomTabsClient = null;
    }

    private CustomTabsSession getSession() {
        if (this.mCustomTabsClient == null) {
            this.mCustomTabsSession = null;
        } else if (this.mCustomTabsSession == null) {
            this.mCustomTabsSession = this.mCustomTabsClient.newSession(null);
        }
        return this.mCustomTabsSession;
    }

    private boolean onItemClick(String clickUrl, boolean isOrganic) {
        Logger.d(TAG, "onItemClick() inner called with: clickUrl = [" + clickUrl + "], isOrganic = [" + isOrganic + "]");
        if (this.mMediationEventListener != null) {
            this.mMediationEventListener.onAdClicked();
        }
        this.postGlobalNotification("TABOOLA_ITEM_DID_CLICK", this, null);
        if (this.isItemClickEnabled() && this.getTaboolaEventListener() != null) {
            Logger.d(TAG, "onItemClick() passed to listener with: clickUrl = [" + clickUrl + "], isOrganic = [" + isOrganic + "]");
            return this.getTaboolaEventListener().taboolaViewItemClickHandler(clickUrl, isOrganic);
        }
        return true;
    }

    private void openUrlInTabsOrBrowser(String url) {
        try {
            if (this.isCustomTabsSupported && this.isContextActivity) {
                this.openChromeTab(url);
            } else {
                this.openNativeBrowser(url);
            }
        }
        catch (Exception e) {
            Logger.e(TAG, "openUrlInTabsOrBrowser :: failed to open url " + e.toString());
        }
    }

    private void openChromeTab(String url) {
        if (this.isChromeTabLaunched) {
            return;
        }
        if (this.mMediationEventListener != null) {
            this.mMediationEventListener.onAdOpened();
        }
        Logger.d(TAG, "openChromeTab :: opening ad in a ChromeTab");
        this.isChromeTabLaunched = true;
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder(this.getSession());
        CustomTabsIntent customTabsIntent = builder.build();
        customTabsIntent.launchUrl(this.getContext(), Uri.parse((String)url));
    }

    private void openNativeBrowser(String url) {
        if (this.mMediationEventListener != null) {
            this.mMediationEventListener.onAdLeftApplication();
        }
        Logger.d(TAG, "openNativeBrowser :: opening add");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        if (!this.isContextActivity) {
            intent.addFlags(0x10000000);
            Logger.d(TAG, "Widget is not using Activity context, so browser will be opened with Intent.FLAG_ACTIVITY_NEW_TASK flag");
        }
        this.getContext().startActivity(intent);
    }

    public WebViewClient getWebViewClient() {
        WebViewClient webViewClient = new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                TaboolaWidget.this.dispatchLoadFailed(description);
            }

            @TargetApi(value=23)
            public void onReceivedError(WebView view, WebResourceRequest req, WebResourceError error) {
                this.onReceivedError(view, error.getErrorCode(), error.getDescription().toString(), req.getUrl().toString());
            }
        };
        Logger.d(TAG, "getWebViewClient :: initialized");
        return webViewClient;
    }

    public WebChromeClient getWebChromeClient() {
        return new WebChromeClient(){
            private final String TAG = WebChromeClient.class.getSimpleName();

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                Logger.d(this.TAG, "onJsAlert :: " + message);
                return super.onJsAlert(view, url, message, result);
            }

            public boolean onConsoleMessage(ConsoleMessage cm) {
                Log.d((String)this.TAG, (String)(cm.message() + ", source: " + cm.sourceId() + " From line " + cm.lineNumber()));
                return true;
            }
        };
    }

    public String getOptionalWidgetStyle() {
        return this.mWidgetStyle;
    }

    public TaboolaWidget setOptionalWidgetStyle(String newCSSStyle) {
        this.mWidgetStyle = newCSSStyle;
        return this;
    }

    public TaboolaWidget setMediatedVia(String mediatedVia) {
        this.mMediatedVia = mediatedVia;
        return this;
    }

    public boolean isScrollEnabled() {
        return this.mIsScrollEnabled;
    }

    public TaboolaWidget setScrollEnabled(boolean isScrollEnabled) {
        this.mIsScrollEnabled = isScrollEnabled;
        this.updateScrollBehaviour();
        return this;
    }

    public boolean isAutoResizeHeight() {
        return this.mIsAutoResizeHeight;
    }

    public TaboolaWidget setAutoResizeHeight(boolean shouldAutoResizeHeight) {
        this.mIsAutoResizeHeight = shouldAutoResizeHeight;
        return this;
    }

    public void setInterceptScroll(boolean bIntercept) {
        this.mShouldInterceptScroll = bIntercept;
        if (this.mShouldInterceptScroll) {
            this.setAutoResizeHeight(false);
            this.setScrollEnabled(true);
        }
    }

    public String getPublisher() {
        return this.mPublisher;
    }

    public TaboolaWidget setPublisher(String newPub) {
        if (newPub != null && !newPub.isEmpty()) {
            this.mPublisher = newPub;
            if (IntegrationVerifier.isEnabled()) {
                this.integrationVerifier.getSessionData().setPublisherId(this.mPublisher);
            }
        }
        return this;
    }

    public TaboolaWidget setViewId(String viewID) {
        this.mViewID = viewID != null && !viewID.isEmpty() ? viewID : Long.toString(System.currentTimeMillis());
        return this;
    }

    public TaboolaWidget setTag(@NonNull String tag) {
        TaboolaJs.getInstance().setTag(this, tag);
        return this;
    }

    public String getMode() {
        return this.mMode;
    }

    public TaboolaWidget setMode(String newMode) {
        if (newMode != null && !newMode.isEmpty()) {
            this.mMode = newMode;
        }
        return this;
    }

    public String getPlacement() {
        return this.mPlacement;
    }

    public TaboolaWidget setPlacement(String newPlacement) {
        if (newPlacement != null && !newPlacement.isEmpty()) {
            this.mPlacement = newPlacement;
        }
        return this;
    }

    public String getPageType() {
        return this.mPageType;
    }

    public TaboolaWidget setPageType(String newPageType) {
        if (newPageType != null && !newPageType.isEmpty()) {
            this.mPageType = newPageType;
        }
        return this;
    }

    public String getTargetType() {
        return this.mPageType;
    }

    public TaboolaWidget setTargetType(String newTargetType) {
        if (newTargetType != null && !newTargetType.isEmpty()) {
            this.mTargetType = newTargetType;
        }
        return this;
    }

    public String getPageUrl() {
        return this.mPageUrl;
    }

    public TaboolaWidget setPageUrl(String newPageUrl) {
        if (newPageUrl != null && !newPageUrl.isEmpty()) {
            this.mPageUrl = newPageUrl;
        }
        return this;
    }

    public String getPageId() {
        return this.mPageId;
    }

    public TaboolaWidget setPageId(String newPageId) {
        if (newPageId != null && !newPageId.isEmpty()) {
            this.mPageId = newPageId;
        }
        return this;
    }

    public TaboolaWidget setProgressBarEnabled(boolean isEnabled) {
        this.mProgressBarEnabled = isEnabled;
        return this;
    }

    public TaboolaWidget setProgressBarColor(@ColorInt int progressColor) {
        if (progressColor != -1) {
            this.mProgressBarColor = StringUtil.colorToHexString(progressColor);
        }
        return this;
    }

    public TaboolaWidget setProgressBarDuration(float duration) {
        if (duration >= 0.0f) {
            this.mProgressBarDuration = duration;
        } else {
            Logger.w(TAG, "setProgressBarDuration | Duration cannot be negative. Using default duration: " + this.mProgressBarDuration);
        }
        return this;
    }

    public void showProgressBar() {
        if (this.mProgressBarEnabled) {
            TaboolaJs.getInstance().showProgressBar(this);
        } else {
            Logger.w(TAG, "progress bar is manually disabled");
        }
    }

    public TaboolaEventListener getTaboolaEventListener() {
        return this.mEventListener;
    }

    public TaboolaWidget setTaboolaEventListener(TaboolaEventListener newListener) {
        this.mEventListener = newListener;
        this.updateClickListener();
        return this;
    }

    public TaboolaWidget setTaboolaUserActionListener(TaboolaUserActionListener listener) {
        TaboolaJs.getInstance().setTaboolaUserActionListener(listener);
        return this;
    }

    private void updateClickListener() {
        TaboolaJs.getInstance().setOnClickListener(this, new TaboolaOnClickListener(){

            @Override
            public boolean onItemClick(String placementName, String itemId, String clickUrl, boolean isOrganic) {
                Logger.d(TAG, "onItemClick() called from TaboolaWidget with: placementName = [" + placementName + "], itemId = [" + itemId + "], clickUrl = [" + clickUrl + "], isOrganic = [" + isOrganic + "]");
                return TaboolaWidget.this.onItemClick(clickUrl, isOrganic);
            }
        });
    }

    public TaboolaWidget setTaboolaDetectAdEventsListener(TaboolaDetectAdEventsListener newListener) {
        this.mTaboolaDetectAdEventsListener = newListener;
        return this;
    }

    public TaboolaWidget setMediationEventListener(MediationEventListener mediationEventListener) {
        this.mMediationEventListener = mediationEventListener;
        return this;
    }

    public void setLogLevel(int logLevel) {
        TaboolaJs.getInstance().setLogLevel(logLevel);
    }

    public int getTextZoom() {
        return this.getSettings().getTextZoom();
    }

    public TaboolaWidget setTextZoom(int textZoom) {
        this.getSettings().setTextZoom(textZoom);
        return this;
    }

    @Deprecated
    public boolean isItemClickEnabled() {
        return this.mIsItemClickEnabled;
    }

    @Deprecated
    public void setItemClickEnabled(boolean mIsItemClickEnabled) {
        this.mIsItemClickEnabled = mIsItemClickEnabled;
    }

    public TaboolaWidget setExtraProperties(HashMap<String, String> extraProperties) {
        if (extraProperties == null || extraProperties.isEmpty()) {
            return this;
        }
        Iterator<String> iterator = extraProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            String value = extraProperties.get(key);
            boolean shouldRemoved = value != null;
            switch (PropertiesHashed.md5(key).toLowerCase()) {
                case "b18f6a812a51478281506648e0e6b4c8": {
                    this.mShouldAllowNonOrganicClickOverride = Boolean.parseBoolean(value);
                    break;
                }
                case "6397e73a7f5461665f599a71cdbe54eb": {
                    this.mIsOnline = Boolean.parseBoolean(value);
                    this.mOptionalPageCommands.setOnlineTemplate(this.mIsOnline);
                    break;
                }
                case "0435c6b587ddf57804ee764b92a60de0": {
                    this.mShouldKeepDependencies = Boolean.parseBoolean(value);
                    break;
                }
                case "5889408cff661122bd1109d5bc8b1e54": {
                    this.mEnableHorizontalScroll = Boolean.parseBoolean(value);
                    break;
                }
                default: {
                    shouldRemoved = false;
                }
            }
            if (!shouldRemoved) continue;
            iterator.remove();
        }
        this.pushCommands(extraProperties);
        return this;
    }

    @Deprecated
    public TaboolaWidget setOptionalPageCommands(HashMap<String, String> arrCommands) {
        return this.setExtraProperties(arrCommands);
    }

    @Deprecated
    public TaboolaWidget setOptionalModeCommands(HashMap<String, String> arrCommands) {
        this.pushCommands(arrCommands);
        return this;
    }

    @Deprecated
    public void pushCommands(HashMap<String, String> arrCommands) {
        this.mOptionalPageCommands.addParameters(arrCommands);
    }

    private void setDefValues() {
        this.mPublisher = "";
        this.mMode = "";
        this.mPlacement = "";
        this.mPageType = "";
        this.mTargetType = "mix";
        this.mPageId = "auto";
        this.mPageUrl = "";
        this.mWidgetStyle = "";
        this.mFramework = "mobile-sdk";
        this.mIsScrollEnabled = false;
        this.mIsItemClickEnabled = true;
        this.mIsAutoResizeHeight = true;
        Logger.d(TAG, "setDefValues :: initialize fields with default values");
    }

    private boolean hasMinimalAttributes() {
        return !TextUtils.isEmpty((CharSequence)this.mPublisher) && !TextUtils.isEmpty((CharSequence)this.mMode) && !TextUtils.isEmpty((CharSequence)this.mPlacement) && !TextUtils.isEmpty((CharSequence)this.mPageUrl) && !TextUtils.isEmpty((CharSequence)this.mPageType);
    }

    private void updateMaxWidgetSize() {
        Logger.d(TAG, "updateMaxWidgetSize :: called");
        if (sMaxWidgetSizeGpu == 0) {
            int size = GLHelper.getCachedMaxWidgetSize(this.getContext());
            if (size != 0) {
                sMaxWidgetSizeGpu = size;
            } else {
                GLHelper.getMaxWidgetSize(this, new GLHelper.onMaxWidgetSizeRetrievedCallback(){

                    @Override
                    public void onMaxWidgetSizeRetrieved(int size) {
                        sMaxWidgetSizeGpu = size;
                    }
                });
            }
        }
    }

    private void updateScrollBehaviour() {
        this.setVerticalScrollBarEnabled(this.mIsScrollEnabled);
        Logger.d(TAG, "updateScrollBehaviour :: scroll enabled " + this.mIsScrollEnabled);
    }

    private void clearScrollChangeListener() {
        if (this.mScrollChangedListenerImpl != null) {
            this.mScrollChangedListenerImpl.clear();
            this.mScrollChangedListenerImpl = null;
        }
    }

    private void stopInvalidationOnScrollEvents() {
    }

    private void startInvalidationOnScrollEvents() {
        if (this.mInvalidationHandler == null) {
            this.mInvalidationHandler = new Handler();
        }
        long delayMillisShort = 500L;
        long delayMillisLong = 5000L;
        final Runnable shortScrollRunnable = new Runnable(){

            @Override
            public void run() {
                TaboolaWidget.this.shouldIgnoreScrollEvents = false;
                TaboolaWidget.this.invalidateWebView();
            }
        };
        final Runnable longScrollRunnable = new Runnable(){

            @Override
            public void run() {
                TaboolaWidget.this.invalidateWebView();
            }
        };
        if (this.mScrollChangedListenerImpl == null) {
            this.mScrollChangedListenerImpl = new OnScrollChangedListenerImpl((View)this);
        } else {
            this.mScrollChangedListenerImpl.removeListener(this.mOnScrollChangedListener);
        }
        if (this.mOnScrollChangedListener == null) {
            this.mOnScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

                public void onScrollChanged() {
                    if (!TaboolaWidget.this.shouldIgnoreScrollEvents) {
                        TaboolaWidget.this.shouldIgnoreScrollEvents = true;
                        if (TaboolaWidget.this.mInvalidationHandler != null) {
                            TaboolaWidget.this.mInvalidationHandler.postDelayed(shortScrollRunnable, 500L);
                            TaboolaWidget.this.mInvalidationHandler.postDelayed(longScrollRunnable, 5000L);
                        }
                    }
                }
            };
        }
        this.mScrollChangedListenerImpl.addListener(this.mOnScrollChangedListener);
    }

    public void invalidateWebView() {
        this.post(new Runnable(){

            @Override
            public void run() {
                TaboolaWidget.this.invalidate();
                Logger.d(TAG, "invalidateWebView executed");
            }
        });
    }

    private void loadWebViewOnline() {
        String commandsString = this.mOptionalPageCommands.getCommandString();
        try {
            this.mHasDispatchedLoadEvent = false;
            String baseUrl = "https://cdn.taboola.com/shared/templateJS.html?pageType=" + Uri.encode((String)this.mPageType) + "&pageId=" + Uri.encode((String)this.mPageId) + "&publisher=" + Uri.encode((String)this.mPublisher) + "&DIV_ID=taboola&targetType=" + Uri.encode((String)this.mTargetType) + "&placementextra=" + Uri.encode((String)commandsString) + "&styleRules=" + Uri.encode((String)this.mWidgetStyle) + "#viewID=" + this.mViewID + "&pageUrl=" + Uri.encode((String)this.mPageUrl) + "&placement=" + Uri.encode((String)this.mPlacement) + "&mode=" + Uri.encode((String)this.mMode);
            if (this.mProgressBarEnabled) {
                if (!TextUtils.isEmpty((CharSequence)this.mProgressBarColor)) {
                    baseUrl = baseUrl + "&pcolor=" + Uri.encode((String)this.mProgressBarColor);
                }
                if (this.mProgressBarDuration != -1.0f) {
                    baseUrl = baseUrl + "&pduration=" + this.mProgressBarDuration;
                }
            }
            this.loadUrl(baseUrl);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("loadWebView failed " + e.toString()), (Throwable)e);
        }
    }

    static class OnAttachStateChangeListenerImpl
    implements View.OnAttachStateChangeListener {
        WeakReference<TaboolaWidget> mWidgetWeakReference;

        OnAttachStateChangeListenerImpl(TaboolaWidget taboolaWidget) {
            if (this.mWidgetWeakReference == null) {
                this.mWidgetWeakReference = new WeakReference<TaboolaWidget>(taboolaWidget);
            }
        }

        public void onViewAttachedToWindow(View v) {
        }

        public void onViewDetachedFromWindow(View v) {
            if (this.mWidgetWeakReference != null && this.mWidgetWeakReference.get() != null) {
                ((TaboolaWidget)this.mWidgetWeakReference.get()).clearDependencies();
            }
        }

        public void clear() {
            this.mWidgetWeakReference.clear();
            this.mWidgetWeakReference = null;
        }
    }
}

