/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.js;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Messenger;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.SparseArray;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.taboola.android.MonitorManager;
import com.taboola.android.Taboola;
import com.taboola.android.TaboolaInterfaceComponent;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.integration_verifier.requests.VerificationRequest;
import com.taboola.android.integration_verifier.testing.TestIDs;
import com.taboola.android.integration_verifier.testing.tests.publisher_config.PublisherConfigParams_JS;
import com.taboola.android.integration_verifier.utility.IVLogger;
import com.taboola.android.js.JsInitDataObserver;
import com.taboola.android.js.MonitorWebViewClient;
import com.taboola.android.js.OnRenderListener;
import com.taboola.android.js.OnResizeListener;
import com.taboola.android.js.PublicApi;
import com.taboola.android.js.SdkJSMonitorHandler;
import com.taboola.android.js.WebViewManager;
import com.taboola.android.listeners.TaboolaUserActionListener;
import com.taboola.android.monitor.TBNetworkMonitoring;
import com.taboola.android.monitor.TBSdkFeature;
import com.taboola.android.monitor.TBSimCodeChange;
import com.taboola.android.monitor.TBSuspendMonitor;
import com.taboola.android.utils.AdvertisingIdClient;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import com.taboola.android.utils.OnClickHelper;
import com.taboola.android.utils.PropertiesHashed;
import com.taboola.android.utils.SdkDetailsHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class TaboolaJs
implements PublicApi.PublicTaboolaJs,
TaboolaInterfaceComponent {
    public static final String PLACEMENT_TAG_DIVIDER = "##";
    public static final String INJECTED_OBJECT_NAME = "taboolaNative";
    public static final String TAG = TaboolaJs.class.getSimpleName();
    @Nullable
    private static String sAdvertisingId = null;
    private static final TaboolaJs ourInstance = new TaboolaJs();
    private Handler mHandler;
    private boolean mShouldAllowNonOrganicClickOverride = false;
    @Nullable
    private TaboolaOnClickListener mOnClickListener;
    private TaboolaUserActionListener mTaboolaUserActionListener;
    private Map<WebView, WebViewManager> mWebViewManagers = new HashMap<WebView, WebViewManager>();
    private MonitorManager mSdkMonitorManager = null;
    private Boolean mIsSdkMonitorInstalled;
    private SparseArray<TBSdkFeature> mSdkFeatures;
    private Messenger mMonitorMessenger;
    private Context mApplicationContext;
    private String mForceClickOnPackage;
    private boolean isCalledFromStdInit;
    private IntegrationVerifier integrationVerifier = Taboola.getTaboolaImpl().getIntegrationVerifier();

    private TaboolaJs() {
    }

    public static TaboolaJs getInstance() {
        return ourInstance;
    }

    @Override
    public TaboolaJs init(@NonNull Context ctx) {
        return this.init(ctx, false);
    }

    public TaboolaJs init(@NonNull Context ctx, boolean isCalledFromStdInit) {
        Context applicationContext = ctx.getApplicationContext();
        this.isCalledFromStdInit = isCalledFromStdInit;
        if (sAdvertisingId == null) {
            AdvertisingIdClient.updateCachedAdvertisingIdAsync(applicationContext);
        }
        if (MonitorUtils.isSdkMonitorInstalled(applicationContext)) {
            this.initSdkMonitor(applicationContext);
        }
        if (IntegrationVerifier.isEnabled()) {
            int integrationType = isCalledFromStdInit ? 1 : 2;
            Bundle integrationVerifierBundle = new Bundle();
            integrationVerifierBundle.putString("Sdk_version_verification_key", "2.1.3-42070-4");
            integrationVerifierBundle.putInt("integration_verifier_key_integrationType", integrationType);
            integrationVerifierBundle.putStringArrayList("permissionsVerification_key_permissions_list", (ArrayList)new ArrayList<String>(){
                {
                    this.add("android.permission.INTERNET");
                    this.add("android.permission.ACCESS_NETWORK_STATE");
                }
            });
            integrationVerifierBundle.putInt("integration_verifier_key_integrationType", integrationType);
            this.integrationVerifier.verify(new VerificationRequest(ctx, integrationVerifierBundle, new TestIDs(9, 2, 3, 4, 5)));
        }
        return this;
    }

    void initSdkMonitor(Context applicationContext) {
        this.mApplicationContext = applicationContext;
        if (this.mIsSdkMonitorInstalled == null) {
            this.mIsSdkMonitorInstalled = true;
            this.mSdkMonitorManager = MonitorManager.getInstance(SdkDetailsHelper.getApplicationName(applicationContext));
            this.mSdkMonitorManager.bindService(applicationContext);
            Logger.setSdkMonitorManager(this.mSdkMonitorManager);
            if (this.mHandler == null) {
                this.mHandler = new Handler(Looper.getMainLooper());
            }
            if (this.mMonitorMessenger == null) {
                this.mMonitorMessenger = new Messenger((Handler)new SdkJSMonitorHandler());
            }
        }
        if (this.mIsSdkMonitorInstalled.booleanValue()) {
            this.mSdkMonitorManager.sendGetFeatureSet(this.mMonitorMessenger, null);
        }
    }

    @Override
    public TaboolaJs registerWebView(@NonNull WebView webView) {
        this.registerWebView(webView, null);
        return this;
    }

    @Override
    public TaboolaJs registerWebView(@NonNull WebView webView, @Nullable OnRenderListener onRenderListener) {
        if (IntegrationVerifier.isEnabled()) {
            this.integrationVerifier.getTestsManager().getMethodCallOrderTracker().rememberNonInitApiMethodCall(2, "registerWebView");
        }
        if (webView == null || webView.getContext() == null) {
            Logger.e(TAG, "registerWebView, WebView is not attached ", new Exception());
            return this;
        }
        if (this.mWebViewManagers.containsKey(webView)) {
            Logger.e(TAG, "registerWebView: WebView is already registered");
        } else {
            WebViewManager webViewManager = new WebViewManager(webView);
            webViewManager.setOnRenderListener(onRenderListener);
            this.mWebViewManagers.put(webView, webViewManager);
            webViewManager.registerWebView();
        }
        if (this.isSdkMonitorEnabled()) {
            if (this.isShouldMonitorNetwork()) {
                webView.setWebViewClient((WebViewClient)new MonitorWebViewClient());
            }
            if (Build.VERSION.SDK_INT >= 19) {
                WebView.setWebContentsDebuggingEnabled((boolean)true);
                Logger.d(TAG, "WebView.setWebContentsDebuggingEnabled(true)");
            }
        }
        if (IntegrationVerifier.isEnabled()) {
            this.getInitDataFromWebView(webView);
        }
        return this;
    }

    private void getInitDataFromWebView(final WebView webView) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager == null) {
            IVLogger.log("TaboolaJs | getInitDataFromWebView | WebView is not registered.");
        } else {
            webViewManager.addJsInitDataObserver(new JsInitDataObserver(){

                @Override
                public void onData(String dataJsonString) {
                    IVLogger.log("TaboolaJs | getInitDataFromWebView | onJsInitDataAvailable | dataJsonString = " + dataJsonString);
                    try {
                        JSONObject dataJsonObject = new JSONObject(dataJsonString);
                        JSONArray placementsJsonArrayObject = dataJsonObject.getJSONArray("placements");
                        int placementsArrayLength = placementsJsonArrayObject.length();
                        if (placementsArrayLength == 0) {
                            TaboolaJs.this.verifyPublisherConfiguration("Stub", "Stub", null, "Stub", "Stub", "Stub");
                        } else {
                            TaboolaJs.this.integrationVerifier.getSessionData().setPublisherId(placementsJsonArrayObject.getJSONObject(0).optString("config_publisher"));
                            for (int i = 0; i < placementsArrayLength; ++i) {
                                JSONObject placementJsonObject = placementsJsonArrayObject.getJSONObject(i);
                                TaboolaJs.this.verifyPublisherConfiguration(placementJsonObject.optString("config_mode"), placementJsonObject.optString("config_container"), placementJsonObject.optString("config_placement"), placementJsonObject.optString("config_target_type"), dataJsonObject.optString("config_publisher"), dataJsonObject.optString("config_page_type"));
                            }
                        }
                        Bundle crawlUrlBundle = new Bundle();
                        crawlUrlBundle.putString("crawlingUrlTest_key_crawling_url", dataJsonObject.optString("config_pageurl"));
                        crawlUrlBundle.putInt("integration_verifier_key_integrationType", 2);
                        TaboolaJs.this.integrationVerifier.verify(new VerificationRequest(webView.getContext(), crawlUrlBundle, new TestIDs(8)));
                    }
                    catch (JSONException e) {
                        IVLogger.log("TaboolaJs | getInitDataFromWebView | JSONException = " + e.getLocalizedMessage());
                    }
                }
            });
        }
    }

    private void verifyPublisherConfiguration(String mode, String container, String placement, String targetType, String publisher, String pageType) {
        Bundle verifyJsParamsBundle = new Bundle();
        verifyJsParamsBundle.putSerializable("publisherConfigurationTest_key_configuration_params", (Serializable)new PublisherConfigParams_JS(mode, container, placement, targetType, publisher, pageType));
        verifyJsParamsBundle.putInt("integration_verifier_key_integrationType", 2);
        this.integrationVerifier.verify(new VerificationRequest(verifyJsParamsBundle, new TestIDs(6, 7)));
    }

    @Override
    public TaboolaJs unregisterWebView(@NonNull WebView webView) {
        if (IntegrationVerifier.isEnabled()) {
            this.integrationVerifier.getTestsManager().getMethodCallOrderTracker().rememberNonInitApiMethodCall(2, "unregisterWebView");
        }
        Logger.d(TAG, "unregisterWebView() ");
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager == null) {
            Logger.e(TAG, "unregisterWebView: WebView is not registered");
        } else {
            webViewManager.unregisterWebView();
            webViewManager.setOnRenderListener(null);
            this.mWebViewManagers.remove(webView);
        }
        return this;
    }

    public void fetchContent(@NonNull WebView webView) {
        if (webView == null || webView.getContext() == null) {
            Logger.e(TAG, "fetchContent, WebView is not attached ", new Exception());
            return;
        }
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager == null) {
            Logger.e(TAG, "fetchContent: WebView is not registered", new Exception());
        } else {
            webViewManager.fetchContent();
        }
    }

    public void showProgressBar(@NonNull WebView webView) {
        if (webView == null || webView.getContext() == null) {
            Logger.e(TAG, "showProgressBar, WebView is not attached ", new Exception());
            return;
        }
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.showProgressBar();
        } else {
            Logger.e(TAG, "showProgressBar: WebView is not registered", new Exception());
        }
    }

    @Override
    public TaboolaJs setLogLevel(int logLevel) {
        Logger.setLogLevel(this.isSdkMonitorEnabled() ? 3 : logLevel);
        return this;
    }

    @Override
    public TaboolaJs setOnRenderListener(@NonNull WebView webView, @Nullable OnRenderListener onRenderListener) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.setOnRenderListener(onRenderListener);
        } else {
            Logger.e(TAG, "setOnRenderListener: WebView is not registered");
        }
        return this;
    }

    public TaboolaJs setTag(@NonNull WebView webView, String tag) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            Logger.e(TAG, "setTag: was set with empty tag");
            return this;
        }
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.setTag(tag);
        } else {
            Logger.e(TAG, "setTag: WebView is not registered", new Exception());
        }
        return this;
    }

    public TaboolaJs setOnResizeListener(@NonNull WebView webView, @Nullable OnResizeListener onResizeListener) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.setOnResizeListener(onResizeListener);
        } else {
            Logger.e(TAG, "setOnResizeListener: WebView is not registered");
        }
        return this;
    }

    public TaboolaJs setOnClickListener(@NonNull WebView webView, @Nullable TaboolaOnClickListener onClickListener) {
        String logMsg = onClickListener != null ? "setOnClickListener " : "TaboolaOnClickListener was removed";
        Logger.d(TAG, logMsg);
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.setOnClickListener(onClickListener);
        } else {
            Logger.e(TAG, "setOnClickListener: WebView is not registered");
        }
        return this;
    }

    @Override
    @Deprecated
    public TaboolaJs setOnClickListener(@Nullable TaboolaOnClickListener onClickListener) {
        String logMsg = onClickListener != null ? "setOnClickListener " : "TaboolaOnClickListener was removed";
        Logger.d(TAG, logMsg);
        this.mOnClickListener = onClickListener;
        return this;
    }

    public TaboolaJs setExtraProperties(@NonNull Map<String, String> extraProperties) {
        for (String key : extraProperties.keySet()) {
            String keyHash = PropertiesHashed.md5(key).toLowerCase();
            String value = extraProperties.get(key);
            switch (keyHash) {
                case "b18f6a812a51478281506648e0e6b4c8": {
                    this.mShouldAllowNonOrganicClickOverride = Boolean.parseBoolean(value);
                    break;
                }
                case "9c978c01eb2af8871edcfe32d9f37388": {
                    this.mForceClickOnPackage = value;
                }
            }
        }
        return this;
    }

    public TaboolaJs setExtraProperties(@NonNull WebView webView, @NonNull Map<String, String> extraProperties) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.setExtraProperties(extraProperties);
        } else {
            Logger.e(TAG, "setExtraProperties: WebView is not registered");
        }
        return this;
    }

    boolean shouldAllowNonOrganicClickOverride() {
        return this.mShouldAllowNonOrganicClickOverride;
    }

    void openUrlInTabsOrBrowser(Context context, String url) {
        if (TextUtils.isEmpty((CharSequence)this.mForceClickOnPackage)) {
            OnClickHelper.openUrlInTabsOrBrowser(context, url);
        } else {
            OnClickHelper.openUrlInApp(context, url, this.mForceClickOnPackage);
        }
    }

    @Nullable
    TaboolaOnClickListener getOnClickListener() {
        return this.mOnClickListener;
    }

    @Nullable
    String getAdvertisingIdFromMemory() {
        return sAdvertisingId;
    }

    void getAdvertisingId(final AdvertisingIdRetrievedCallback callback, @NonNull Context applicationContext) {
        if (sAdvertisingId == null) {
            String cachedId = AdvertisingIdClient.getCachedAdvertisingId(applicationContext);
            if (cachedId != null) {
                sAdvertisingId = cachedId;
                callback.onAdIdRetrieved(sAdvertisingId);
            } else {
                AdvertisingIdClient.updateAdvertisingIdAsync(applicationContext, new AdvertisingIdClient.AdvertisingIdCallback(){

                    @Override
                    public void onIdRetrieved(String advertisingId) {
                        sAdvertisingId = advertisingId;
                        callback.onAdIdRetrieved(sAdvertisingId);
                    }

                    @Override
                    public void onIdUnavailable() {
                        sAdvertisingId = "";
                        callback.onAdIdRetrieved(sAdvertisingId);
                    }
                });
            }
        } else if (sAdvertisingId.isEmpty()) {
            callback.onAdIdRetrieved(sAdvertisingId);
        } else {
            callback.onAdIdRetrieved(sAdvertisingId);
        }
    }

    public boolean isSdkMonitorEnabled() {
        return this.mIsSdkMonitorInstalled != null && this.mIsSdkMonitorInstalled != false && !this.isSdkMonitorSuspended();
    }

    boolean isSdkMonitorSuspended() {
        TBSuspendMonitor suspendMonitor = (TBSuspendMonitor)this.getFeature(2);
        return suspendMonitor != null && suspendMonitor.isShouldSuspend();
    }

    boolean isShouldMonitorNetwork() {
        TBNetworkMonitoring tbWebViewMonitor = (TBNetworkMonitoring)this.getFeature(4);
        return tbWebViewMonitor == null || tbWebViewMonitor.isShouldMonitor();
    }

    public MonitorManager getSdkMonitorManager() {
        return this.mSdkMonitorManager;
    }

    void setSdkFeatures(SparseArray<TBSdkFeature> sdkFeatures) {
        this.mSdkFeatures = sdkFeatures;
        SdkDetailsHelper.verifyIfNeededToChangeSimCode((TBSimCodeChange)this.getFeature(5));
        if (this.isSdkMonitorEnabled()) {
            Logger.setSdkMonitorLevelActive();
        }
    }

    private boolean isMissingSdkFeatures() {
        return this.mSdkFeatures == null || this.mSdkFeatures.size() == 0;
    }

    @Nullable
    <T extends TBSdkFeature> T getFeature(Integer key) {
        if (this.isMissingSdkFeatures()) {
            return null;
        }
        TBSdkFeature sdkFeature = (TBSdkFeature)this.mSdkFeatures.get(key.intValue());
        return (T)sdkFeature;
    }

    void sendUrlToMonitor(final long timestamp, final String url) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                TaboolaJs.this.mSdkMonitorManager.sendNetworkCall(timestamp, url);
            }
        });
    }

    public void clear() {
        if (IntegrationVerifier.isEnabled()) {
            this.integrationVerifier.getTestsManager().getMethodCallOrderTracker().clearTrackedMethods(2);
            this.integrationVerifier.clearStatusReport();
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        this.mOnClickListener = null;
        this.mTaboolaUserActionListener = null;
        if (this.mIsSdkMonitorInstalled != null && this.mIsSdkMonitorInstalled.booleanValue() && this.mSdkMonitorManager != null) {
            this.mIsSdkMonitorInstalled = null;
            this.mSdkMonitorManager.unbindService(this.mApplicationContext);
            Logger.setSdkMonitorManager(null);
            this.mSdkMonitorManager = null;
            this.mMonitorMessenger = null;
            if (this.mSdkFeatures != null) {
                this.mSdkFeatures.clear();
            }
        }
        this.mApplicationContext = null;
    }

    public void sendFetchContentParamsToMonitor(WebView webView, String placement, HashMap<String, String> parameters) {
        WebViewManager webViewManager;
        if (this.isSdkMonitorEnabled() && (webViewManager = this.mWebViewManagers.get(webView)) != null) {
            webViewManager.prepareAndSendParamsToMonitor(placement, parameters);
        }
    }

    void sendWebPlacementFetchContent(final String placementId, final String placementType, final String placementName, final HashMap<String, String> parameters) {
        if (this.isSdkMonitorEnabled()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TaboolaJs.this.mSdkMonitorManager.sendWebPlacementFetchContent(placementId, placementType, placementName, parameters);
                }
            });
        }
    }

    void reportDeviceDataToMonitor(String deviceData) {
        if (this.isSdkMonitorEnabled()) {
            this.mSdkMonitorManager.sendGetFeatureSet(this.mMonitorMessenger, deviceData);
        }
    }

    public void reportUserAction(int actionType, String dataJsonString) {
        if (this.mTaboolaUserActionListener != null) {
            this.mTaboolaUserActionListener.clickedOnAction(actionType, dataJsonString);
            Logger.d(TAG, " mTaboolaUserActionListener.clickedOnAction()");
        } else {
            Logger.d(TAG, "mTaboolaUserActionListener == null");
        }
    }

    public TaboolaJs setTaboolaUserActionListener(@Nullable TaboolaUserActionListener userActionListener) {
        String logMsg = userActionListener != null ? "setTaboolaUserActionListener " : "TaboolaUserActionListener was removed";
        Logger.d(TAG, logMsg);
        this.mTaboolaUserActionListener = userActionListener;
        return this;
    }

    static interface AdvertisingIdRetrievedCallback {
        public void onAdIdRetrieved(String var1);
    }
}

